/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayNG;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayUtil;
import com.hazelcast.shaded.org.locationtech.jts.operation.union.UnaryUnionOp;
import com.hazelcast.shaded.org.locationtech.jts.operation.union.UnionStrategy;
import java.util.Collection;

public class UnaryUnionNG {
    public static Geometry union(Geometry geom, PrecisionModel pm) {
        UnaryUnionOp op = new UnaryUnionOp(geom);
        op.setUnionFunction(UnaryUnionNG.createUnionStrategy(pm));
        return op.union();
    }

    public static Geometry union(Collection<Geometry> geoms, PrecisionModel pm) {
        UnaryUnionOp op = new UnaryUnionOp(geoms);
        op.setUnionFunction(UnaryUnionNG.createUnionStrategy(pm));
        return op.union();
    }

    public static Geometry union(Collection<Geometry> geoms, GeometryFactory geomFact, PrecisionModel pm) {
        UnaryUnionOp op = new UnaryUnionOp(geoms, geomFact);
        op.setUnionFunction(UnaryUnionNG.createUnionStrategy(pm));
        return op.union();
    }

    private static UnionStrategy createUnionStrategy(final PrecisionModel pm) {
        UnionStrategy unionSRFun = new UnionStrategy(){

            @Override
            public Geometry union(Geometry g0, Geometry g1) {
                return OverlayNG.overlay(g0, g1, 2, pm);
            }

            @Override
            public boolean isFloatingPrecision() {
                return OverlayUtil.isFloating(pm);
            }
        };
        return unionSRFun;
    }

    private UnaryUnionNG() {
    }
}

