/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geomgraph;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geomgraph.Edge;
import com.hazelcast.shaded.org.locationtech.jts.geomgraph.EdgeIntersection;
import com.hazelcast.shaded.org.locationtech.jts.geomgraph.Label;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EdgeIntersectionList {
    private Map nodeMap = new TreeMap();
    Edge edge;

    public EdgeIntersectionList(Edge edge) {
        this.edge = edge;
    }

    public EdgeIntersection add(Coordinate intPt, int segmentIndex, double dist) {
        EdgeIntersection eiNew = new EdgeIntersection(intPt, segmentIndex, dist);
        EdgeIntersection ei = (EdgeIntersection)this.nodeMap.get(eiNew);
        if (ei != null) {
            return ei;
        }
        this.nodeMap.put(eiNew, eiNew);
        return eiNew;
    }

    public Iterator iterator() {
        return this.nodeMap.values().iterator();
    }

    public boolean isIntersection(Coordinate pt) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EdgeIntersection ei = (EdgeIntersection)it.next();
            if (!ei.coord.equals(pt)) continue;
            return true;
        }
        return false;
    }

    public void addEndpoints() {
        int maxSegIndex = this.edge.pts.length - 1;
        this.add(this.edge.pts[0], 0, 0.0);
        this.add(this.edge.pts[maxSegIndex], maxSegIndex, 0.0);
    }

    public void addSplitEdges(List edgeList) {
        this.addEndpoints();
        Iterator it = this.iterator();
        EdgeIntersection eiPrev = (EdgeIntersection)it.next();
        while (it.hasNext()) {
            EdgeIntersection ei = (EdgeIntersection)it.next();
            Edge newEdge = this.createSplitEdge(eiPrev, ei);
            edgeList.add(newEdge);
            eiPrev = ei;
        }
    }

    Edge createSplitEdge(EdgeIntersection ei0, EdgeIntersection ei1) {
        boolean useIntPt1;
        int npts = ei1.segmentIndex - ei0.segmentIndex + 2;
        Coordinate lastSegStartPt = this.edge.pts[ei1.segmentIndex];
        boolean bl = useIntPt1 = ei1.dist > 0.0 || !ei1.coord.equals2D(lastSegStartPt);
        if (!useIntPt1) {
            --npts;
        }
        Coordinate[] pts = new Coordinate[npts];
        int ipt = 0;
        pts[ipt++] = new Coordinate(ei0.coord);
        for (int i = ei0.segmentIndex + 1; i <= ei1.segmentIndex; ++i) {
            pts[ipt++] = this.edge.pts[i];
        }
        if (useIntPt1) {
            pts[ipt] = ei1.coord;
        }
        return new Edge(pts, new Label(this.edge.label));
    }

    public void print(PrintStream out) {
        out.println("Intersections:");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EdgeIntersection ei = (EdgeIntersection)it.next();
            ei.print(out);
        }
    }
}

