/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.util;

import com.hazelcast.shaded.com.google.common.base.Preconditions;
import com.hazelcast.shaded.org.apache.calcite.util.JdbcType;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;

enum JdbcTypeImpl implements JdbcType
{
    BIG_DECIMAL((Class)BigDecimal.class, false){

        public BigDecimal get(int column, ResultSet resultSet) throws SQLException {
            return Objects.requireNonNull(resultSet.getBigDecimal(column), "getBigDecimal");
        }
    }
    ,
    BIG_DECIMAL_NULLABLE((Class)BigDecimal.class, true){

        public @Nullable BigDecimal get(int column, ResultSet resultSet) throws SQLException {
            return resultSet.getBigDecimal(column);
        }
    }
    ,
    BOOLEAN((Class)Boolean.class, false){

        public Boolean get(int column, ResultSet resultSet) throws SQLException {
            boolean v = resultSet.getBoolean(column);
            Preconditions.checkArgument(v || !resultSet.wasNull());
            return v;
        }
    }
    ,
    BOOLEAN_NULLABLE((Class)Boolean.class, true){

        public @Nullable Boolean get(int column, ResultSet resultSet) throws SQLException {
            boolean v = resultSet.getBoolean(column);
            return !v && resultSet.wasNull() ? null : Boolean.valueOf(v);
        }
    }
    ,
    DOUBLE((Class)Double.class, false){

        public Double get(int column, ResultSet resultSet) throws SQLException {
            double v = resultSet.getDouble(column);
            Preconditions.checkArgument(v != 0.0 || !resultSet.wasNull());
            return v;
        }
    }
    ,
    DOUBLE_NULLABLE((Class)Double.class, true){

        public @Nullable Double get(int column, ResultSet resultSet) throws SQLException {
            double v = resultSet.getDouble(column);
            return v == 0.0 && resultSet.wasNull() ? null : Double.valueOf(v);
        }
    }
    ,
    INTEGER((Class)Integer.class, false){

        public Integer get(int column, ResultSet resultSet) throws SQLException {
            int v = resultSet.getInt(column);
            Preconditions.checkArgument(v != 0 || !resultSet.wasNull());
            return v;
        }
    }
    ,
    INTEGER_NULLABLE((Class)Integer.class, true){

        public @Nullable Integer get(int column, ResultSet resultSet) throws SQLException {
            int v = resultSet.getInt(column);
            return v == 0 && resultSet.wasNull() ? null : Integer.valueOf(v);
        }
    }
    ,
    STRING((Class)String.class, false){

        public String get(int column, ResultSet resultSet) throws SQLException {
            return Objects.requireNonNull(resultSet.getString(column), "getString");
        }
    }
    ,
    STRING_NULLABLE((Class)String.class, true){

        public @Nullable String get(int column, ResultSet resultSet) throws SQLException {
            return resultSet.getString(column);
        }
    };


    private JdbcTypeImpl(Class<?> unusedClass, boolean unusedNullable) {
    }
}

