/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.type;

import com.hazelcast.shaded.com.google.common.base.Preconditions;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class SqlReturnTypeInferenceChain
implements SqlReturnTypeInference {
    private final ImmutableList<SqlReturnTypeInference> rules;

    SqlReturnTypeInferenceChain(SqlReturnTypeInference ... rules) {
        Preconditions.checkArgument(rules.length > 1);
        this.rules = ImmutableList.copyOf(rules);
    }

    @Override
    public @Nullable RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        for (SqlReturnTypeInference rule : this.rules) {
            RelDataType ret = rule.inferReturnType(opBinding);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

