/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.internal.serialization.impl.compact.DeserializedSchemaBoundGenericRecordBuilder;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetUtils;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.nio.serialization.genericrecord.GenericRecordBuilder;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.RowValue;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class CompactUpsertTarget
implements UpsertTarget {
    private final Schema schema;
    private GenericRecordBuilder builder;

    CompactUpsertTarget(@Nonnull Schema schema) {
        this.schema = schema;
    }

    @Override
    public UpsertInjector createInjector(@Nullable String path, QueryDataType queryDataType) {
        if (path == null) {
            return UpsertInjector.FAILING_TOP_LEVEL_INJECTOR;
        }
        boolean hasField = this.schema.hasField(path);
        if (!hasField) {
            return value -> {
                throw QueryException.error((String)("Field \"" + path + "\" doesn't exist in Compact Schema"));
            };
        }
        FieldKind kind = this.schema.getField(path).getKind();
        switch (kind) {
            case STRING: {
                return value -> this.builder.setString(path, (String)value);
            }
            case NULLABLE_BOOLEAN: {
                return value -> this.builder.setNullableBoolean(path, (Boolean)value);
            }
            case NULLABLE_INT8: {
                return value -> this.builder.setNullableInt8(path, (Byte)value);
            }
            case NULLABLE_INT16: {
                return value -> this.builder.setNullableInt16(path, (Short)value);
            }
            case NULLABLE_INT32: {
                return value -> this.builder.setNullableInt32(path, (Integer)value);
            }
            case NULLABLE_INT64: {
                return value -> this.builder.setNullableInt64(path, (Long)value);
            }
            case DECIMAL: {
                return value -> this.builder.setDecimal(path, (BigDecimal)value);
            }
            case NULLABLE_FLOAT32: {
                return value -> this.builder.setNullableFloat32(path, (Float)value);
            }
            case NULLABLE_FLOAT64: {
                return value -> this.builder.setNullableFloat64(path, (Double)value);
            }
            case TIME: {
                return value -> this.builder.setTime(path, (LocalTime)value);
            }
            case DATE: {
                return value -> this.builder.setDate(path, (LocalDate)value);
            }
            case TIMESTAMP: {
                return value -> this.builder.setTimestamp(path, (LocalDateTime)value);
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return value -> this.builder.setTimestampWithTimezone(path, (OffsetDateTime)value);
            }
            case COMPACT: {
                return this.createRowValueInjector(path, queryDataType);
            }
        }
        throw QueryException.error((String)(String.valueOf(kind) + " kind is not supported in SQL with Compact format!"));
    }

    @Override
    public void init() {
        this.builder = new DeserializedSchemaBoundGenericRecordBuilder(this.schema);
    }

    @Override
    public Object conclude() {
        GenericRecord record = this.builder.build();
        this.builder = null;
        return record;
    }

    private UpsertInjector createRowValueInjector(String path, QueryDataType targetDataType) {
        return value -> this.builder.setGenericRecord(path, UpsertTargetUtils.convertRowToCompactType((RowValue)value, targetDataType));
    }
}

