/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.iteration.IndexIterationPointer;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.internal.services.NodeAware;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.PredicateBuilder;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.exec.scan.index.IndexCompositeFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexEqualsFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexRangeFilter;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.UntrustedExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.row.JetSqlRow;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class QueryUtil {
    private QueryUtil() {
    }

    static Predicate<Object, Object> toPredicate(JetSqlRow left, int[] leftEquiJoinIndices, int[] rightEquiJoinIndices, QueryPath[] rightPaths) {
        PredicateBuilder builder = Predicates.newPredicateBuilder();
        PredicateBuilder.EntryObject entryObject = builder.getEntryObject();
        for (int i = 0; i < leftEquiJoinIndices.length; ++i) {
            PredicateBuilder.EntryObject object;
            Comparable<?> leftValue = QueryUtil.asComparable(left.get(leftEquiJoinIndices[i]));
            if (leftValue == null) {
                return null;
            }
            QueryPath rightPath = rightPaths[rightEquiJoinIndices[i]];
            if (rightPath.isKey()) {
                object = rightPath.isTopLevel() ? entryObject.key() : entryObject.key().get(rightPath.getPath());
            } else {
                PredicateBuilder.EntryObject entryObject2 = object = rightPath.isTopLevel() ? entryObject.get(rightPath.toString()) : entryObject.get(QueryPath.VALUE).get(rightPath.getPath());
            }
            if (i == 0) {
                object.equal(leftValue);
                continue;
            }
            builder.and((Predicate)object.equal(leftValue));
        }
        return builder;
    }

    private static Comparable<?> asComparable(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Comparable) {
            return (Comparable)value;
        }
        throw QueryException.error((String)("JOIN not supported for " + String.valueOf(value.getClass()) + ": not comparable"));
    }

    public static Projection<Map.Entry<Object, Object>, JetSqlRow> toProjection(KvRowProjector.Supplier rightRowProjectorSupplier, ExpressionEvalContext evalContext) {
        return new JoinProjection(rightRowProjectorSupplier, UntrustedExpressionEvalContext.from(evalContext));
    }

    static IndexIterationPointer[] indexFilterToPointers(IndexFilter indexFilter, boolean compositeIndex, boolean descending, ExpressionEvalContext evalContext) {
        List<Object> result = new ArrayList<IndexIterationPointer>();
        QueryUtil.createFromIndexFilterInt(indexFilter, compositeIndex, descending, evalContext, result);
        result = IndexIterationPointer.normalizePointers(result, (boolean)descending);
        return result.toArray(new IndexIterationPointer[0]);
    }

    private static void createFromIndexFilterInt(IndexFilter indexFilter, boolean compositeIndex, boolean descending, ExpressionEvalContext evalContext, List<IndexIterationPointer> result) {
        if (indexFilter == null) {
            if (!compositeIndex && descending) {
                result.add(IndexIterationPointer.ALL_ALT_DESC);
            } else {
                result.add(descending ? IndexIterationPointer.ALL_DESC : IndexIterationPointer.ALL);
            }
        }
        if (indexFilter instanceof IndexRangeFilter) {
            int cmp;
            Object from;
            IndexRangeFilter rangeFilter = (IndexRangeFilter)indexFilter;
            if (rangeFilter.getFrom() == null && rangeFilter.getTo() == null) {
                assert (!compositeIndex) : "IS NOT NULL range should not be generated for composite index";
                result.add(descending ? IndexIterationPointer.IS_NOT_NULL_DESC : IndexIterationPointer.IS_NOT_NULL);
                return;
            }
            Object object = from = compositeIndex ? null : AbstractIndex.NULL;
            if (rangeFilter.getFrom() != null) {
                Comparable fromValue = rangeFilter.getFrom().getValue(evalContext);
                if (fromValue == null) {
                    return;
                }
                from = fromValue;
            }
            Comparable to = null;
            if (rangeFilter.getTo() != null) {
                Comparable toValue = rangeFilter.getTo().getValue(evalContext);
                if (toValue == null) {
                    return;
                }
                to = toValue;
            }
            if (!(from == null || to == null || (cmp = from.compareTo(to)) <= 0 && (cmp != 0 || rangeFilter.isFromInclusive() && rangeFilter.isToInclusive()))) {
                return;
            }
            result.add(IndexIterationPointer.create((Comparable)from, (boolean)rangeFilter.isFromInclusive(), (Comparable)to, (boolean)rangeFilter.isToInclusive(), (boolean)descending, null));
        } else if (indexFilter instanceof IndexEqualsFilter) {
            IndexEqualsFilter equalsFilter = (IndexEqualsFilter)indexFilter;
            Comparable value = equalsFilter.getComparable(evalContext);
            result.add(IndexIterationPointer.create((Comparable)value, (boolean)true, (Comparable)value, (boolean)true, (boolean)descending, null));
        } else if (indexFilter instanceof IndexCompositeFilter) {
            IndexCompositeFilter inFilter = (IndexCompositeFilter)indexFilter;
            for (IndexFilter filter : inFilter.getFilters()) {
                QueryUtil.createFromIndexFilterInt(filter, compositeIndex, descending, evalContext, result);
            }
        }
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
    private static final class JoinProjection
    implements Projection<Map.Entry<Object, Object>, JetSqlRow>,
    DataSerializable,
    NodeAware,
    SerializationServiceAware {
        private KvRowProjector.Supplier rightRowProjectorSupplier;
        private List<Object> arguments;
        private transient Node node;
        private transient ExpressionEvalContext evalContext;
        private transient Extractors extractors;

        private JoinProjection() {
        }

        private JoinProjection(KvRowProjector.Supplier rightRowProjectorSupplier, UntrustedExpressionEvalContext evalContext) {
            this.rightRowProjectorSupplier = rightRowProjectorSupplier;
            this.evalContext = evalContext;
            this.extractors = Extractors.newBuilder((InternalSerializationService)evalContext.getSerializationService()).build();
            this.arguments = evalContext.getArguments();
        }

        public JetSqlRow transform(Map.Entry<Object, Object> entry) {
            return this.rightRowProjectorSupplier.get(this.evalContext, this.extractors).project(entry.getKey(), entry.getValue());
        }

        public void setNode(Node node) {
            assert (this.node == null || this.node == node) : "Unexpected change of Node instance";
            this.node = node;
        }

        public void setSerializationService(SerializationService serializationService) {
            assert (this.evalContext == null || this.evalContext.getSerializationService() == serializationService) : "Unexpected change of serialization service";
            assert (this.node != null) : "setNode should be called before setSerializationService";
            this.initContext((InternalSerializationService)serializationService);
        }

        private void initContext(InternalSerializationService iss) {
            if (this.evalContext != null) {
                return;
            }
            this.evalContext = new UntrustedExpressionEvalContext(this.arguments, iss, (NodeEngine)this.node.nodeEngine);
            this.extractors = Extractors.newBuilder((InternalSerializationService)iss).build();
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.rightRowProjectorSupplier);
            out.writeObject(this.arguments);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.rightRowProjectorSupplier = (KvRowProjector.Supplier)in.readObject();
            this.arguments = (List)in.readObject();
        }
    }
}

