/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.postgres;

import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import java.util.Iterator;

public class PostgresUpsertQueryBuilder
extends AbstractQueryBuilder {
    public PostgresUpsertQueryBuilder(JdbcTable jdbcTable, SqlDialect dialect) {
        super(jdbcTable, dialect);
        StringBuilder sb = new StringBuilder();
        this.appendInsertClause(sb);
        sb.append(' ');
        this.appendValuesClause(sb);
        sb.append(' ');
        this.appendOnConflictClause(sb);
        this.query = sb.toString();
    }

    void appendInsertClause(StringBuilder sb) {
        sb.append("INSERT INTO ");
        this.dialect.quoteIdentifier(sb, this.jdbcTable.getExternalNameList());
        sb.append(' ');
        this.appendFieldNames(sb, this.jdbcTable.dbFieldNames());
    }

    void appendValuesClause(StringBuilder sb) {
        sb.append("VALUES ");
        this.appendValues(sb, this.jdbcTable.dbFieldNames().size());
    }

    void appendOnConflictClause(StringBuilder sb) {
        sb.append("ON CONFLICT ");
        this.appendFieldNames(sb, this.jdbcTable.getPrimaryKeyList());
        sb.append(" DO UPDATE SET ");
        Iterator<String> it = this.jdbcTable.dbFieldNames().iterator();
        while (it.hasNext()) {
            String dbFieldName = it.next();
            this.dialect.quoteIdentifier(sb, dbFieldName);
            sb.append(" = EXCLUDED.");
            this.dialect.quoteIdentifier(sb, dbFieldName);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
    }
}

