/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.file.FileFormat;
import com.hazelcast.jet.pipeline.file.impl.FileProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.file.impl.FileTraverser;
import com.hazelcast.jet.sql.impl.connector.file.FileTableField;
import com.hazelcast.jet.sql.impl.connector.file.Metadata;
import com.hazelcast.jet.sql.impl.connector.file.ProcessorMetaSupplierProvider;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import java.util.List;
import java.util.Map;

abstract class MetadataResolver<T> {
    MetadataResolver() {
    }

    List<MappingField> resolveAndValidateFields(List<MappingField> userFields, Map<String, ?> options) {
        return !userFields.isEmpty() ? this.validateFields(userFields) : this.resolveFieldsFromSample((T)options);
    }

    private List<MappingField> validateFields(List<MappingField> userFields) {
        for (MappingField userField : userFields) {
            String externalName = userField.externalName();
            if (externalName == null || externalName.indexOf(46) < 0) continue;
            throw QueryException.error((String)("Invalid field external name - '" + externalName + "'. Nested fields are not supported."));
        }
        return userFields;
    }

    private List<MappingField> resolveFieldsFromSample(Map<String, ?> options) {
        List<MappingField> list;
        block9: {
            FileProcessorMetaSupplier fileProcessorMetaSupplier = (FileProcessorMetaSupplier)new ProcessorMetaSupplierProvider(options, this.sampleFormat()).get();
            FileTraverser traverser = fileProcessorMetaSupplier.traverser();
            try {
                Object sample = traverser.next();
                if (sample == null) {
                    throw QueryException.error((String)"No sample found to resolve the columns");
                }
                list = this.resolveFieldsFromSample(sample);
                if (traverser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (traverser != null) {
                        try {
                            traverser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionUtil.sneakyThrow((Throwable)e);
                }
            }
            traverser.close();
        }
        return list;
    }

    protected abstract String supportedFormat();

    protected abstract FileFormat<?> sampleFormat();

    protected abstract List<MappingField> resolveFieldsFromSample(T var1);

    protected abstract Metadata resolveMetadata(List<MappingField> var1, Map<String, ?> var2);

    protected List<TableField> toFields(List<MappingField> resolvedFields) {
        return Util.toList(resolvedFields, field -> new FileTableField(field.name(), field.type(), field.externalName() == null ? field.name() : field.externalName()));
    }
}

