/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;

public class RowProjector
implements Row {
    private final QueryTarget target;
    private final QueryExtractor[] extractors;
    private final Expression<Boolean> predicate;
    private final List<Expression<?>> projection;
    private final ExpressionEvalContext evalContext;

    public RowProjector(String[] paths, QueryDataType[] types, QueryTarget target, Expression<Boolean> predicate, List<Expression<?>> projection, ExpressionEvalContext evalContext) {
        Preconditions.checkTrue((paths.length == types.length ? 1 : 0) != 0, (String)"paths.length != types.length");
        this.target = target;
        this.extractors = RowProjector.createExtractors(target, paths, types);
        this.predicate = predicate != null ? predicate : ConstantExpression.create(true, QueryDataType.BOOLEAN);
        this.projection = projection;
        this.evalContext = evalContext;
    }

    private static QueryExtractor[] createExtractors(QueryTarget target, String[] paths, QueryDataType[] types) {
        QueryExtractor[] extractors = new QueryExtractor[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            QueryDataType type = types[i];
            extractors[i] = target.createExtractor(path, type);
        }
        return extractors;
    }

    public JetSqlRow project(Object object) {
        this.target.setTarget(object, null);
        return ExpressionUtil.projection(this.predicate, this.projection, this, this.evalContext);
    }

    public <T> T get(int index, boolean useLazyDeserialization) {
        return (T)this.extractors[index].get(useLazyDeserialization);
    }

    public <T> T get(int index) {
        return (T)this.extractors[index].get();
    }

    public int getColumnCount() {
        return this.extractors.length;
    }
}

