/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryException;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MaxSqlAggregation
implements SqlAggregation {
    private Object value;

    @Override
    public void accumulate(Object value) {
        if (value == null) {
            return;
        }
        if (this.value == null || this.compare(this.value, value) < 0) {
            this.value = value;
        }
    }

    @Override
    public void combine(SqlAggregation other0) {
        MaxSqlAggregation other = (MaxSqlAggregation)other0;
        Object value = other.value;
        if (this.value == null || value != null && this.compare(this.value, value) < 0) {
            this.value = value;
        }
    }

    private int compare(Object left, Object right) {
        assert (left != null);
        assert (right != null);
        Comparable<?> leftComparable = MaxSqlAggregation.asComparable(left);
        Comparable<?> rightComparable = MaxSqlAggregation.asComparable(right);
        return leftComparable.compareTo(rightComparable);
    }

    private static Comparable<?> asComparable(Object value) {
        if (value instanceof Comparable) {
            return (Comparable)value;
        }
        throw QueryException.error((String)("MAX not supported for " + String.valueOf(value.getClass()) + ": not comparable"));
    }

    @Override
    public Object collect() {
        return this.value;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.value);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.value = in.readObject();
    }
}

