/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.math;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.Triangle;
import com.hazelcast.shaded.org.locationtech.jts.geom.impl.CoordinateArraySequence;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTWriter;
import com.hazelcast.shaded.org.locationtech.jts.math.DD;

public class TriPredicate {
    public static boolean isInCircle(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        boolean isInCircle = (a.x * a.x + a.y * a.y) * TriPredicate.triArea(b, c, p) - (b.x * b.x + b.y * b.y) * TriPredicate.triArea(a, c, p) + (c.x * c.x + c.y * c.y) * TriPredicate.triArea(a, b, p) - (p.x * p.x + p.y * p.y) * TriPredicate.triArea(a, b, c) > 0.0;
        return isInCircle;
    }

    private static double triArea(Coordinate a, Coordinate b, Coordinate c) {
        return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
    }

    public static boolean isInCircleRobust(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        return TriPredicate.isInCircleDD(a, b, c, p);
    }

    public static boolean isInCircleDD(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        DD px = new DD(p.x);
        DD py = new DD(p.y);
        DD ax = new DD(a.x);
        DD ay = new DD(a.y);
        DD bx = new DD(b.x);
        DD by = new DD(b.y);
        DD cx = new DD(c.x);
        DD cy = new DD(c.y);
        DD aTerm = ax.multiply(ax).add(ay.multiply(ay)).multiply(TriPredicate.triAreaDD(bx, by, cx, cy, px, py));
        DD bTerm = bx.multiply(bx).add(by.multiply(by)).multiply(TriPredicate.triAreaDD(ax, ay, cx, cy, px, py));
        DD cTerm = cx.multiply(cx).add(cy.multiply(cy)).multiply(TriPredicate.triAreaDD(ax, ay, bx, by, px, py));
        DD pTerm = px.multiply(px).add(py.multiply(py)).multiply(TriPredicate.triAreaDD(ax, ay, bx, by, cx, cy));
        DD sum = aTerm.subtract(bTerm).add(cTerm).subtract(pTerm);
        boolean isInCircle = sum.doubleValue() > 0.0;
        return isInCircle;
    }

    public static boolean isInCircleDD2(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        DD aTerm = DD.sqr((double)a.x).selfAdd(DD.sqr((double)a.y)).selfMultiply(TriPredicate.triAreaDD2(b, c, p));
        DD bTerm = DD.sqr((double)b.x).selfAdd(DD.sqr((double)b.y)).selfMultiply(TriPredicate.triAreaDD2(a, c, p));
        DD cTerm = DD.sqr((double)c.x).selfAdd(DD.sqr((double)c.y)).selfMultiply(TriPredicate.triAreaDD2(a, b, p));
        DD pTerm = DD.sqr((double)p.x).selfAdd(DD.sqr((double)p.y)).selfMultiply(TriPredicate.triAreaDD2(a, b, c));
        DD sum = aTerm.selfSubtract(bTerm).selfAdd(cTerm).selfSubtract(pTerm);
        boolean isInCircle = sum.doubleValue() > 0.0;
        return isInCircle;
    }

    public static boolean isInCircleDD3(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        DD adx = DD.valueOf((double)a.x).selfSubtract(p.x);
        DD ady = DD.valueOf((double)a.y).selfSubtract(p.y);
        DD bdx = DD.valueOf((double)b.x).selfSubtract(p.x);
        DD bdy = DD.valueOf((double)b.y).selfSubtract(p.y);
        DD cdx = DD.valueOf((double)c.x).selfSubtract(p.x);
        DD cdy = DD.valueOf((double)c.y).selfSubtract(p.y);
        DD abdet = adx.multiply(bdy).selfSubtract(bdx.multiply(ady));
        DD bcdet = bdx.multiply(cdy).selfSubtract(cdx.multiply(bdy));
        DD cadet = cdx.multiply(ady).selfSubtract(adx.multiply(cdy));
        DD alift = adx.multiply(adx).selfSubtract(ady.multiply(ady));
        DD blift = bdx.multiply(bdx).selfSubtract(bdy.multiply(bdy));
        DD clift = cdx.multiply(cdx).selfSubtract(cdy.multiply(cdy));
        DD sum = alift.selfMultiply(bcdet).selfAdd(blift.selfMultiply(cadet)).selfAdd(clift.selfMultiply(abdet));
        boolean isInCircle = sum.doubleValue() > 0.0;
        return isInCircle;
    }

    public static DD triAreaDD(DD ax, DD ay, DD bx, DD by, DD cx, DD cy) {
        return bx.subtract(ax).multiply(cy.subtract(ay)).subtract(by.subtract(ay).multiply(cx.subtract(ax)));
    }

    public static DD triAreaDD2(Coordinate a, Coordinate b, Coordinate c) {
        DD t1 = DD.valueOf((double)b.x).selfSubtract(a.x).selfMultiply(DD.valueOf((double)c.y).selfSubtract(a.y));
        DD t2 = DD.valueOf((double)b.y).selfSubtract(a.y).selfMultiply(DD.valueOf((double)c.x).selfSubtract(a.x));
        return t1.selfSubtract(t2);
    }

    public static boolean isInCircleCC(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        Coordinate cc = Triangle.circumcentre((Coordinate)a, (Coordinate)b, (Coordinate)c);
        double ccRadius = a.distance(cc);
        double pRadiusDiff = p.distance(cc) - ccRadius;
        return pRadiusDiff <= 0.0;
    }

    private static void checkRobustInCircle(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        boolean nonRobustInCircle = TriPredicate.isInCircle(a, b, c, p);
        boolean isInCircleDD = TriPredicate.isInCircleDD(a, b, c, p);
        boolean isInCircleCC = TriPredicate.isInCircleCC(a, b, c, p);
        Coordinate circumCentre = Triangle.circumcentre((Coordinate)a, (Coordinate)b, (Coordinate)c);
        System.out.println("p radius diff a = " + Math.abs(p.distance(circumCentre) - a.distance(circumCentre)) / a.distance(circumCentre));
        if (nonRobustInCircle != isInCircleDD || nonRobustInCircle != isInCircleCC) {
            System.out.println("inCircle robustness failure (double result = " + nonRobustInCircle + ", DD result = " + isInCircleDD + ", CC result = " + isInCircleCC + ")");
            System.out.println(WKTWriter.toLineString((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{a, b, c, p})));
            System.out.println("Circumcentre = " + WKTWriter.toPoint((Coordinate)circumCentre) + " radius = " + a.distance(circumCentre));
            System.out.println("p radius diff a = " + Math.abs(p.distance(circumCentre) / a.distance(circumCentre) - 1.0));
            System.out.println("p radius diff b = " + Math.abs(p.distance(circumCentre) / b.distance(circumCentre) - 1.0));
            System.out.println("p radius diff c = " + Math.abs(p.distance(circumCentre) / c.distance(circumCentre) - 1.0));
            System.out.println();
        }
    }
}

