/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.index;

import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.index.ItemVisitor;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.STRtree;
import com.hazelcast.shaded.org.locationtech.jts.util.Stopwatch;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;
import test.jts.perf.index.CountItemVisitor;

public class STRtreePerfTest
extends PerformanceTestCase {
    private STRtree index;

    public static void main(String[] args) {
        PerformanceTestRunner.run(STRtreePerfTest.class);
    }

    public STRtreePerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{100, 10000, 100000});
        this.setRunIterations(1);
    }

    @Override
    public void setUp() {
    }

    @Override
    public void startRun(int size) {
        System.out.println("----- Tree size: " + size);
        this.index = new STRtree();
        int side = (int)Math.sqrt(size);
        for (int i = 0; i < side; ++i) {
            for (int j = 0; j < side; ++j) {
                Envelope env = new Envelope((double)i, (double)(i + 10), (double)j, (double)(j + 10));
                this.index.insert(env, (Object)(i + "-" + j));
            }
        }
        Stopwatch sw = new Stopwatch();
        this.index.build();
        System.out.println("Build time = " + sw.getTimeString());
    }

    public void runQueries() {
        CountItemVisitor visitor = new CountItemVisitor();
        int size = this.index.size();
        int side = (int)Math.sqrt(size);
        for (int i = 0; i < side; ++i) {
            for (int j = 0; j < side; ++j) {
                Envelope env = new Envelope((double)i, (double)(i + 40), (double)j, (double)(j + 40));
                this.index.query(env, (ItemVisitor)visitor);
            }
        }
        System.out.println("Total query result items = " + visitor.count);
    }
}

