/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.index;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.index.kdtree.KdTree;

public class KdtreeStressTest {
    int NUM_PTS = 50000;

    public static void main(String[] args) throws Exception {
        KdtreeStressTest test = new KdtreeStressTest();
        test.run();
    }

    private void run() {
        System.out.format("Loading iIndex with %d points\n", this.NUM_PTS);
        KdTree index = this.createUnbalancedTree(this.NUM_PTS);
        System.out.format("Querying Index loaded with %d points\n", this.NUM_PTS);
        for (int i = 0; i < this.NUM_PTS; ++i) {
            Envelope env = new Envelope((double)i, (double)(i + 10), 0.0, 1.0);
            index.query(env);
        }
        System.out.format("Queries complete\n", new Object[0]);
    }

    private KdTree createUnbalancedTree(int numPts) {
        KdTree index = new KdTree();
        for (int i = 0; i < numPts; ++i) {
            Coordinate pt = new Coordinate((double)i, 0.0);
            index.insert(pt);
        }
        return index;
    }
}

