/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.geom.util;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.GeometryFixer;

public class GeometryFixerFuzzer {
    private static final int GEOM_EXTENT_SIZE = 100;
    private static final int NUM_ITER = 10000;
    private static final boolean IS_VERBOSE = false;
    public GeometryFactory factory = new GeometryFactory();

    public static void main(String[] args) {
        GeometryFixerFuzzer.run();
    }

    private static void run() {
        GeometryFixerFuzzer fuzzer = new GeometryFixerFuzzer();
        fuzzer.run(10000);
    }

    private void run(int numIter) {
        System.out.println("GeometryFixer fuzzer: iterations = " + numIter);
        for (int i = 0; i < numIter; ++i) {
            int numHoles = (int)(10.0 * Math.random());
            Geometry invalidPoly = this.createRandomCirclePoly(100, numHoles);
            Geometry result = GeometryFixer.fix((Geometry)invalidPoly);
            boolean isValid = result.isValid();
            this.report(i, invalidPoly, result, isValid);
        }
    }

    private void report(int i, Geometry invalidPoly, Geometry result, boolean isValid) {
        String status = isValid ? "valid" : "INVALID";
        String msg = String.format("%d: Pts - input %d, output %d - %s", i, invalidPoly.getNumPoints(), result.getNumPoints(), status);
        if (!isValid) {
            System.out.println(msg);
            System.out.println(invalidPoly);
        }
    }

    private Geometry createRandomLinePoly(int numPoints, int numHoles) {
        int numRingPoints = numPoints / (numHoles + 1);
        LinearRing shell = this.createRandomLineRing(numRingPoints);
        LinearRing[] holes = new LinearRing[numHoles];
        for (int i = 0; i < numHoles; ++i) {
            holes[i] = this.createRandomLineRing(numRingPoints);
        }
        return this.factory.createPolygon(shell, holes);
    }

    private LinearRing createRandomLineRing(int numPoints) {
        return this.factory.createLinearRing(this.createRandomPoints(numPoints));
    }

    private Coordinate[] createRandomPoints(int numPoints) {
        Coordinate[] pts = new Coordinate[numPoints + 1];
        for (int i = 0; i < numPoints; ++i) {
            Coordinate p;
            pts[i] = p = new Coordinate(this.randOrd(), this.randOrd());
        }
        pts[pts.length - 1] = pts[0].copy();
        return pts;
    }

    private double randOrd() {
        double ord = 100.0 * Math.random();
        return ord;
    }

    private Geometry createRandomCirclePoly(int numPoints, int numHoles) {
        int numRingPoints = numPoints / (numHoles + 1);
        LinearRing shell = this.ceateRandomCircleRing(numRingPoints);
        LinearRing[] holes = new LinearRing[numHoles];
        for (int i = 0; i < numHoles; ++i) {
            holes[i] = this.ceateRandomCircleRing(numRingPoints);
        }
        return this.factory.createPolygon(shell, holes);
    }

    private LinearRing ceateRandomCircleRing(int numPoints) {
        int numQuadSegs = numPoints / 4 + 1;
        if (numQuadSegs < 3) {
            numQuadSegs = 3;
        }
        Coordinate p = new Coordinate(this.randOrd(), this.randOrd());
        Point pt = this.factory.createPoint(p);
        double radius = 100.0 * Math.random() / 2.0;
        Polygon buffer = (Polygon)pt.buffer(radius, numQuadSegs);
        return buffer.getExteriorRing();
    }
}

