/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.geom.prep;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.SineStarFactory;
import com.hazelcast.shaded.org.locationtech.jts.util.GeometricShapeFactory;
import java.util.ArrayList;
import java.util.List;

public class TestDataBuilder {
    private GeometryFactory geomFact = new GeometryFactory();
    private Coordinate origin = new Coordinate(0.0, 0.0);
    private double size = 100.0;
    private int testDim = 1;

    public TestDataBuilder() {
    }

    public TestDataBuilder(GeometryFactory geomFact) {
        this.geomFact = geomFact;
    }

    public void setExtent(Coordinate origin, double size) {
        this.origin = origin;
        this.size = size;
    }

    public void setTestDimension(int testDim) {
        this.testDim = testDim;
    }

    public Geometry createCircle(int nPts) {
        GeometricShapeFactory gsf = new GeometricShapeFactory();
        gsf.setCentre(this.origin);
        gsf.setSize(this.size);
        gsf.setNumPoints(nPts);
        Polygon circle = gsf.createCircle();
        return circle;
    }

    public Geometry createSineStar(int nPts) {
        SineStarFactory gsf = new SineStarFactory();
        gsf.setCentre(this.origin);
        gsf.setSize(this.size);
        gsf.setNumPoints(nPts);
        gsf.setArmLengthRatio(0.1);
        gsf.setNumArms(20);
        Geometry poly = gsf.createSineStar();
        return poly;
    }

    public List createTestGeoms(Envelope env, int nItems, double size, int nPts) {
        int nCells = (int)Math.sqrt(nItems);
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        double width = env.getWidth();
        double xInc = width / (double)nCells;
        double yInc = width / (double)nCells;
        for (int i = 0; i < nCells; ++i) {
            for (int j = 0; j < nCells; ++j) {
                Coordinate base = new Coordinate(env.getMinX() + (double)i * xInc, env.getMinY() + (double)j * yInc);
                Geometry line = this.createLine(base, size, nPts);
                geoms.add(line);
            }
        }
        return geoms;
    }

    Geometry createLine(Coordinate base, double size, int nPts) {
        GeometricShapeFactory gsf = new GeometricShapeFactory();
        gsf.setCentre(base);
        gsf.setSize(size);
        gsf.setNumPoints(nPts);
        Polygon circle = gsf.createCircle();
        return circle.getBoundary();
    }
}

