/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.util.GeometricShapeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;

public class IndexedPointInAreaPerfTest
extends PerformanceTestCase {
    List<Coordinate> coords;
    Polygon polygon;

    public static void main(String[] args) {
        PerformanceTestRunner.run(IndexedPointInAreaPerfTest.class);
    }

    public IndexedPointInAreaPerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{100000});
        this.setRunIterations(1);
    }

    @Override
    public void startRun(int num) {
        System.out.println("Running with size " + num);
        GeometricShapeFactory factory = new GeometricShapeFactory();
        factory.setSize(100.0);
        this.polygon = factory.createCircle();
        this.coords = new ArrayList<Coordinate>();
        Random rand = new Random(1324L);
        for (int i = 0; i < num; ++i) {
            this.coords.add(new Coordinate(rand.nextDouble() * 100.0, rand.nextDouble() * 100.0));
        }
    }

    public void runParallel() {
        for (int i = 0; i < 1000; ++i) {
            IndexedPointInAreaLocator locator = new IndexedPointInAreaLocator((Geometry)this.polygon);
            this.coords.parallelStream().forEach(c -> this.isInside(locator, (Coordinate)c));
        }
    }

    private boolean isInside(IndexedPointInAreaLocator locator, Coordinate coord) {
        return locator.locate(coord) == 0;
    }
}

