/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan.node;

import com.hazelcast.sql.impl.CoreSqlTestSupport;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class PlanNodeSchemaTest
extends CoreSqlTestSupport {
    @Test
    public void testSingleSchema() {
        QueryDataType type0 = QueryDataType.VARCHAR;
        QueryDataType type1 = QueryDataType.DOUBLE;
        List<QueryDataType> types = Arrays.asList(type0, type1);
        PlanNodeSchema schema = new PlanNodeSchema(types);
        Assert.assertEquals(types, (Object)schema.getTypes());
        Assert.assertEquals((Object)type0, (Object)schema.getType(0));
        Assert.assertEquals((Object)type1, (Object)schema.getType(1));
        Assert.assertEquals((long)(type0.getTypeFamily().getEstimatedSize() + type1.getTypeFamily().getEstimatedSize()), (long)schema.getEstimatedRowSize());
    }

    @Test
    public void testCombinedSchemas() {
        QueryDataType type0 = QueryDataType.VARCHAR;
        QueryDataType type1 = QueryDataType.DOUBLE;
        PlanNodeSchema schema0 = new PlanNodeSchema(Collections.singletonList(type0));
        PlanNodeSchema schema1 = new PlanNodeSchema(Collections.singletonList(type1));
        PlanNodeSchema combinedSchema = PlanNodeSchema.combine((PlanNodeSchema)schema0, (PlanNodeSchema)schema1);
        Assert.assertEquals((long)2L, (long)combinedSchema.getTypes().size());
        Assert.assertEquals((Object)type0, (Object)combinedSchema.getType(0));
        Assert.assertEquals((Object)type1, (Object)combinedSchema.getType(1));
    }

    @Test
    public void testEquals() {
        List<QueryDataType> types1 = Arrays.asList(QueryDataType.INT, QueryDataType.VARCHAR);
        List<QueryDataType> types2 = Arrays.asList(QueryDataType.DECIMAL, QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME);
        PlanNodeSchemaTest.checkEquals(new PlanNodeSchema(types1), new PlanNodeSchema(types1), true);
        PlanNodeSchemaTest.checkEquals(new PlanNodeSchema(types1), new PlanNodeSchema(types2), false);
    }
}

