/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.extract;

import com.hazelcast.sql.impl.CoreSqlTestSupport;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class QueryPathTest
extends CoreSqlTestSupport {
    @Test
    public void testPathResolution() {
        this.checkPath(QueryPath.KEY, true, null);
        this.checkPath(QueryPath.VALUE, false, null);
        this.checkPath("attr", false, "attr");
        this.checkPath("attr1.attr2", false, "attr1.attr2");
        this.checkPath(QueryPath.KEY + ".attr", true, "attr");
        this.checkPath(QueryPath.KEY + ".attr1.attr2", true, "attr1.attr2");
        this.checkPath(QueryPath.VALUE + ".attr", false, "attr");
        this.checkPath(QueryPath.VALUE + ".attr1.attr2", false, "attr1.attr2");
        this.checkFails(null);
        this.checkFails("");
        this.checkFails(QueryPath.KEY + ".");
        this.checkFails(QueryPath.VALUE + ".");
    }

    @Test
    public void testSerialization() {
        QueryPath original = new QueryPath("test", true);
        QueryPath restored = (QueryPath)QueryPathTest.serializeAndCheck(original, 86);
        Assert.assertEquals((Object)original.getPath(), (Object)restored.getPath());
        Assert.assertEquals((Object)original.isKey(), (Object)restored.isKey());
    }

    private void checkFails(String path) {
        QueryPathTest.assertThrows(QueryException.class, () -> QueryPath.create((String)path));
    }

    private void checkPath(String originalPath, boolean expectedKey, String expectedPath) {
        QueryPath path = QueryPath.create((String)originalPath);
        Assert.assertEquals((Object)expectedKey, (Object)path.isKey());
        Assert.assertEquals((Object)expectedPath, (Object)path.getPath());
        Assert.assertEquals((Object)(expectedPath == null ? 1 : 0), (Object)path.isTopLevel());
    }
}

