/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.sql.impl.expression.ConcurrentInitialSetCache;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ConcurrentInitialSetCacheTest {
    @Test
    public void when_addingElementsToCacheInSingleThread_then_properSizeAndElements() {
        int i;
        int capacity = 20;
        int elementsToAdd = 100;
        ConcurrentInitialSetCache cache = new ConcurrentInitialSetCache(capacity);
        for (i = 0; i < elementsToAdd; ++i) {
            cache.computeIfAbsent((Object)i, Function.identity());
        }
        Assert.assertEquals((long)capacity, (long)cache.cache.size());
        for (i = 0; i < capacity; ++i) {
            Assert.assertTrue((boolean)cache.cache.containsKey(i));
        }
    }

    @Test
    public void when_addingElementsToCacheMultiThreaded_then_minProperSizeAndElements() {
        int capacity = 20;
        int elementsToAdd = 100;
        int threadCount = 10;
        ConcurrentInitialSetCache cache = new ConcurrentInitialSetCache(capacity);
        Runnable runnable = () -> {
            for (int i = 0; i < elementsToAdd; ++i) {
                cache.computeIfAbsent((Object)i, Function.identity());
            }
        };
        List<Thread> threadList = IntStream.range(0, threadCount).mapToObj(value -> new Thread(runnable)).collect(Collectors.toList());
        threadList.forEach(Thread::start);
        threadList.forEach(Thread::join);
        Assert.assertTrue((cache.cache.size() >= capacity ? 1 : 0) != 0);
        for (int i = 0; i < capacity; ++i) {
            Assert.assertTrue((boolean)cache.cache.containsKey(i));
        }
    }

    @Test
    public void when_creatingEmptyCache_then_fail() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new ConcurrentInitialSetCache(0));
    }
}

