/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientSqlResubmissionMode;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.client.SqlResubmissionTestSupport;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.SlowTest;
import java.util.concurrent.TimeUnit;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={SlowTest.class, ParallelJVMTest.class})
public class SqlResubmissionTimeoutTest
extends SqlResubmissionTestSupport {
    private static final int FAILING_MAP_SIZE = 100;
    @Parameterized.Parameter
    public Integer timeout;

    @Parameterized.Parameters(name="timeout:{0}")
    public static Object[] parameters() {
        return new Object[]{1, 10, 30};
    }

    @BeforeClass
    public static void setUpClass() {
        SqlResubmissionTimeoutTest.initialize((int)1, null);
    }

    @Test
    public void when_totalTimeOfResubmissionEnds_then_fail() {
        this.createMap(SqlResubmissionTimeoutTest.instance(), FAILING_MAP_NAME, 100, SqlResubmissionTestSupport.FailingDuringFieldAccessObject::new, SqlResubmissionTestSupport.FailingDuringFieldAccessObject.class);
        HazelcastInstance client = this.createClient();
        long startTime = System.currentTimeMillis();
        SqlStatement statement = new SqlStatement("update " + FAILING_MAP_NAME + " set field = field + 1");
        SqlResubmissionTimeoutTest.assertThrows(HazelcastSqlException.class, () -> client.getSql().execute(statement));
        long duration = System.currentTimeMillis() - startTime;
        SqlResubmissionTimeoutTest.assertGreaterOrEquals((String)"timeout", (long)TimeUnit.MILLISECONDS.toSeconds(duration), (long)this.timeout.intValue());
        client.shutdown();
    }

    private HazelcastInstance createClient() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty("hazelcast.client.invocation.timeout.seconds", "" + this.timeout);
        clientConfig.getSqlConfig().setResubmissionMode(ClientSqlResubmissionMode.RETRY_ALL);
        return SqlResubmissionTimeoutTest.factory().newHazelcastClient(clientConfig);
    }
}

