/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.slf4j.helpers;

import com.hazelcast.shaded.org.slf4j.helpers.BasicMDCAdapter;
import com.hazelcast.shaded.org.slf4j.spi.MDCAdapter;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class MDCAdapterTestBase {
    protected MDCAdapter mdc = this.instantiateMDC();

    protected MDCAdapter instantiateMDC() {
        return new BasicMDCAdapter();
    }

    @After
    public void tearDown() throws Exception {
        this.mdc.clear();
    }

    @Test
    public void testSettingAndGettingWithMDC() {
        Assert.assertNull((Object)this.mdc.get("testKey"));
        this.mdc.put("testKey", "testValue");
        Assert.assertEquals((Object)this.mdc.get("testKey"), (Object)"testValue");
    }

    @Test
    public void testOverwritingAKeyInMDC() {
        Assert.assertNull((Object)this.mdc.get("testKey"));
        this.mdc.put("testKey", "testValue");
        this.mdc.put("testKey", "differentTestValue");
        Assert.assertEquals((Object)this.mdc.get("testKey"), (Object)"differentTestValue");
    }

    @Test
    public void testGetCopyOfContextMapFromMDC() {
        this.mdc.put("testKey", "testValue");
        Map copy = this.mdc.getCopyOfContextMap();
        this.mdc.put("anotherTestKey", "anotherTestValue");
        Assert.assertFalse((copy.size() == this.mdc.getCopyOfContextMap().size() ? 1 : 0) != 0);
    }

    @Test
    public void testMDCInheritsValuesFromParentThread() throws Exception {
        this.mdc.put("parentKey", "parentValue");
        this.runAndWait(() -> {
            this.mdc.put("childKey", "childValue");
            Assert.assertEquals((Object)"parentValue", (Object)this.mdc.get("parentKey"));
        });
    }

    @Test
    public void testMDCDoesntGetValuesFromChildThread() throws Exception {
        this.mdc.put("parentKey", "parentValue");
        this.runAndWait(() -> this.mdc.put("childKey", "childValue"));
        Assert.assertEquals((Object)"parentValue", (Object)this.mdc.get("parentKey"));
        Assert.assertNull((Object)this.mdc.get("childKey"));
    }

    @Test
    public void testInvokingSetContextMap_WithANullMap_SLF4J_414() {
        this.mdc.setContextMap(null);
    }

    @Test
    public void testMDCChildThreadCanOverwriteParentThread() throws Exception {
        this.mdc.put("sharedKey", "parentValue");
        this.runAndWait(() -> {
            Assert.assertEquals((Object)"parentValue", (Object)this.mdc.get("sharedKey"));
            this.mdc.put("sharedKey", "childValue");
            Assert.assertEquals((Object)"childValue", (Object)this.mdc.get("sharedKey"));
        });
        Assert.assertEquals((Object)"parentValue", (Object)this.mdc.get("sharedKey"));
    }

    private void runAndWait(Runnable runnable) {
        RecordingExceptionHandler handler = new RecordingExceptionHandler();
        Thread thread = new Thread(runnable);
        thread.setUncaughtExceptionHandler(handler);
        thread.start();
        try {
            thread.join();
        }
        catch (Throwable t) {
            Assert.fail((String)("Unexpected failure in child thread:" + t.getMessage()));
        }
        Assert.assertFalse((String)handler.getMessage(), (boolean)handler.hadException());
    }

    private static class RecordingExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private Throwable exception;

        private RecordingExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.exception = e;
        }

        boolean hadException() {
            return this.exception != null;
        }

        String getMessage() {
            return this.exception != null ? this.exception.getMessage() : "";
        }
    }
}

