/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayNG;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayNGTest;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class OverlayNGTestOne
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(OverlayNGTestOne.class);
    }

    public OverlayNGTestOne(String name) {
        super(name);
    }

    public void xxtestCollapseTriBoxIntersection() {
        Geometry a = this.read("POLYGON ((1 2, 1 1, 9 1, 1 2))");
        Geometry b = this.read("POLYGON ((9 2, 9 1, 8 1, 8 2, 9 2))");
        Geometry expected = this.read("LINESTRING (8 1, 9 1)");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void testCollapseTriBoxesIntersection() {
        Geometry a = this.read("MULTIPOLYGON (((1 4, 1 1, 2 1, 2 4, 1 4)), ((9 4, 9 1, 10 1, 10 4, 9 4)))");
        Geometry b = this.read("POLYGON ((0 2, 11 3, 11 2, 0 2))");
        Geometry expected = this.read("GEOMETRYCOLLECTION (LINESTRING (1 2, 2 2), POLYGON ((9 2, 9 3, 10 3, 10 2, 9 2)))");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestCollapseBoxCutByTriangleUnion() {
        Geometry a = this.read("POLYGON ((100 10, 0 10, 100 11, 100 10))");
        Geometry b = this.read("POLYGON ((20 20, 0 20, 0 0, 20 0, 20 20))");
        Geometry expected = this.read("MULTIPOLYGON (((0 0, 0 10, 0 20, 20 20, 20 10, 20 0, 0 0)), ((20 10, 100 11, 100 10, 20 10)))");
        this.checkEqual(expected, OverlayNGTest.union(a, b, 1.0));
    }

    public void xtestCollapseBoxTriangleUnion() {
        Geometry a = this.read("POLYGON ((10 10, 100 10, 10 11, 10 10))");
        Geometry b = this.read("POLYGON ((90 0, 200 0, 200 200, 90 200, 90 0))");
        Geometry expected = this.read("MULTIPOLYGON (((90 10, 10 10, 10 11, 90 10)), ((90 10, 90 200, 200 200, 200 0, 90 0, 90 10)))");
        this.checkEqual(expected, OverlayNGTest.union(a, b, 1.0));
    }

    public void xtestParallelSpikes() {
        Geometry a = this.read("POLYGON ((1 3.3, 1.3 1.4, 3.1 1.4, 3.1 0.9, 1.3 0.9, 1 -0.2, 0.8 1.3, 1 3.3))");
        Geometry b = this.read("POLYGON ((1 2.9, 2.9 2.9, 2.9 1.3, 1.7 1, 1.3 0.9, 1 0.4, 1 2.9))");
        Geometry expected = this.read("POLYGON EMPTY");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }

    public void xtestBoxHoleCollapseAlongBEdgeDifference() {
        Geometry a = this.read("POLYGON ((0 3, 3 3, 3 0, 0 0, 0 3), (1 1.2, 1 1.1, 2.3 1.1, 1 1.2))");
        Geometry b = this.read("POLYGON ((1 1, 2 1, 2 0, 1 0, 1 1))");
        Geometry expected = this.read("POLYGON EMPTY");
        this.checkEqual(expected, OverlayNGTest.difference(b, a, 1.0));
    }

    public void xtestPolyPolyTouchIntersection() {
        Geometry a = this.read("POLYGON ((300 0, 100 0, 100 100, 300 100, 300 0))");
        Geometry b = this.read("POLYGON ((100 200, 300 200, 300 100, 200 100, 200 0, 100 0, 100 200))");
        Geometry expected = this.read("GEOMETRYCOLLECTION (LINESTRING (200 100, 300 100), POLYGON ((200 0, 100 0, 100 100, 200 100, 200 0)))");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }

    public void xtestBoxHoleCollapseAlongBEdgeUnion() {
        Geometry a = this.read("POLYGON ((0 3, 3 3, 3 0, 0 0, 0 3), (1 1.2, 1 1.1, 2.3 1.1, 1 1.2))");
        Geometry b = this.read("POLYGON ((1 1, 2 1, 2 0, 1 0, 1 1))");
        Geometry expected = this.read("POLYGON ((0 0, 0 3, 3 3, 3 0, 2 0, 1 0, 0 0))");
        this.checkEqual(expected, OverlayNGTest.union(b, a, 1.0));
    }

    public void xtestRoundedBoxesIntersection() {
        Geometry a = this.read("POLYGON ((0.6 0.1, 0.6 1.9, 2.9 1.9, 2.9 0.1, 0.6 0.1))");
        Geometry b = this.read("POLYGON ((1.1 3.9, 2.9 3.9, 2.9 2.1, 1.1 2.1, 1.1 3.9))");
        Geometry expected = this.read("LINESTRING (1 2, 3 2)");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }

    public void xtestRoundedLinesIntersection() {
        Geometry a = this.read("LINESTRING (3 2, 3 4)");
        Geometry b = this.read("LINESTRING (1.1 1.6, 3.8 1.9)");
        Geometry expected = this.read("POINT (3 2)");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }

    public void xtestRoundedPointsIntersection() {
        Geometry a = this.read("POINT (10.1 10)");
        Geometry b = this.read("POINT (10 10.1)");
        Geometry expected = this.read("POINT (10 10)");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }

    public void xtestLineLineIntersectionFloat() {
        Geometry a = this.read("LINESTRING (10 10, 20 20)");
        Geometry b = this.read("LINESTRING (13 13, 10 10, 10 20, 20 20, 17 17)");
        Geometry expected = this.read("LINESTRING (17 17, 20 20, 10 20, 10 10, 13 13, 17 17)");
        Geometry actual = OverlayNG.overlay((Geometry)a, (Geometry)b, (int)2);
        this.checkEqual(expected, actual);
    }

    public void xtestPolygonPointIntersection() {
        Geometry a = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
        Geometry b = this.read("MULTIPOINT ((150 150), (250 150))");
        Geometry expected = this.read("POINT (150 150)");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestPolygonPointUnion() {
        Geometry a = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
        Geometry b = this.read("MULTIPOINT ((150 150), (250 150))");
        Geometry expected = this.read("GEOMETRYCOLLECTION (POINT (250 150), POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200)))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestPolygoPolygonWithLineTouchIntersection() {
        Geometry a = this.read("POLYGON ((360 200, 220 200, 220 180, 300 180, 300 160, 300 140, 360 200))");
        Geometry b = this.read("MULTIPOLYGON (((280 180, 280 160, 300 160, 300 180, 280 180)), ((220 230, 240 230, 240 180, 220 180, 220 230)))");
        Geometry expected = this.read("POLYGON ((220 200, 240 200, 240 180, 220 180, 220 200))");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestLinePolygonIntersectionAlongCollapse() {
        Geometry a = this.read("POLYGON ((100 300, 300 300, 300 200, 130 200, 300 199.9, 300 100, 100 100, 100 300))");
        Geometry b = this.read("LINESTRING (130 200, 200 200)");
        Geometry expected = this.read("LINESTRING (130 200, 200 200)");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestLinePolygonIntersectionAlongPolyBoundary() {
        Geometry a = this.read("LINESTRING (150 300, 250 300)");
        Geometry b = this.read("POLYGON ((100 400, 200 400, 200 300, 100 300, 100 400))");
        Geometry expected = this.read("LINESTRING (200 300, 150 300)");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestPolygonMultiLineUnion() {
        Geometry a = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
        Geometry b = this.read("MULTILINESTRING ((150 250, 150 50), (250 250, 250 50))");
        Geometry expected = this.read("GEOMETRYCOLLECTION (LINESTRING (150 50, 150 100), LINESTRING (150 200, 150 250), LINESTRING (250 50, 250 250), POLYGON ((100 100, 100 200, 150 200, 200 200, 200 100, 150 100, 100 100)))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestLinePolygonUnion() {
        Geometry a = this.read("LINESTRING (50 150, 150 150)");
        Geometry b = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
        Geometry expected = this.read("GEOMETRYCOLLECTION (LINESTRING (50 150, 100 150), POLYGON ((100 200, 200 200, 200 100, 100 100, 100 150, 100 200)))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestBoxGoreIntersection() {
        Geometry a = this.read("MULTIPOLYGON (((1 1, 5 1, 5 0, 1 0, 1 1)), ((1 1, 5 2, 5 4, 1 4, 1 1)))");
        Geometry b = this.read("POLYGON ((1 0, 1 2, 2 2, 2 0, 1 0))");
        Geometry expected = this.read("POLYGON ((2 0, 1 0, 1 1, 1 2, 2 2, 2 1, 2 0))");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestBoxGoreUnion() {
        Geometry a = this.read("MULTIPOLYGON (((1 1, 5 1, 5 0, 1 0, 1 1)), ((1 1, 5 2, 5 4, 1 4, 1 1)))");
        Geometry b = this.read("POLYGON ((1 0, 1 2, 2 2, 2 0, 1 0))");
        Geometry expected = this.read("POLYGON ((2 0, 1 0, 1 1, 1 2, 1 4, 5 4, 5 2, 2 1, 5 1, 5 0, 2 0))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestCollapseBoxGoreIntersection() {
        Geometry a = this.read("MULTIPOLYGON (((1 1, 5 1, 5 0, 1 0, 1 1)), ((1 1, 5 2, 5 4, 1 4, 1 1)))");
        Geometry b = this.read("POLYGON ((1 0, 1 2, 2 2, 2 0, 1 0))");
        Geometry expected = this.read("POLYGON ((2 0, 1 0, 1 1, 1 2, 2 2, 2 1, 2 0))");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestCollapseTriBoxIntersection() {
        Geometry a = this.read("POLYGON ((1 2, 1 1, 9 1, 1 2))");
        Geometry b = this.read("POLYGON ((9 2, 9 1, 8 1, 8 2, 9 2))");
        Geometry expected = this.read("POLYGON EMPTY");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void XtestCollapseTriBoxUnion() {
        Geometry a = this.read("POLYGON ((1 2, 1 1, 9 1, 1 2))");
        Geometry b = this.read("POLYGON ((9 2, 9 1, 8 1, 8 2, 9 2))");
        Geometry expected = this.read("MULTIPOLYGON (((1 1, 1 2, 8 1, 1 1)), ((8 1, 8 2, 9 2, 9 1, 8 1)))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestAdjacentBoxesUnion() {
        Geometry a = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
        Geometry b = this.read("POLYGON ((300 200, 300 100, 200 100, 200 200, 300 200))");
        Geometry expected = this.read("POLYGON ((100 100, 100 200, 200 200, 300 200, 300 100, 200 100, 100 100))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestBoxTriIntersection() {
        Geometry a = this.read("POLYGON ((0 6, 4 6, 4 2, 0 2, 0 6))");
        Geometry b = this.read("POLYGON ((1 0, 2 5, 3 0, 1 0))");
        Geometry expected = this.read("POLYGON ((3 2, 1 2, 2 5, 3 2))");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestBoxTriUnion() {
        Geometry a = this.read("POLYGON ((0 6, 4 6, 4 2, 0 2, 0 6))");
        Geometry b = this.read("POLYGON ((1 0, 2 5, 3 0, 1 0))");
        Geometry expected = this.read("POLYGON ((0 6, 4 6, 4 2, 3 2, 3 0, 1 0, 1 2, 0 2, 0 6))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestMultiHoleBoxUnion() {
        Geometry a = this.read("MULTIPOLYGON (((0 200, 200 200, 200 0, 0 0, 0 200), (50 50, 190 50, 50 200, 50 50), (20 20, 20 50, 50 50, 50 20, 20 20)), ((60 100, 50 50, 100 60, 60 100)))");
        Geometry b = this.read("POLYGON ((60 110, 100 110, 100 60, 60 60, 60 110))");
        Geometry expected = this.read("POLYGON ((3 2, 1 2, 2 5, 3 2))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestNestedPolysUnion() {
        Geometry a = this.read("MULTIPOLYGON (((0 200, 200 200, 200 0, 0 0, 0 200), (50 50, 190 50, 50 200, 50 50)), ((60 100, 100 60, 50 50, 60 100)))");
        Geometry b = this.read("POLYGON ((135 176, 180 176, 180 130, 135 130, 135 176))");
        Geometry expected = this.read("MULTIPOLYGON (((0 0, 0 200, 50 200, 200 200, 200 0, 0 0), (50 50, 190 50, 50 200, 50 50)), ((50 50, 60 100, 100 60, 50 50)))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestMultiHoleSideTouchingBoxUnion() {
        Geometry a = this.read("MULTIPOLYGON (((0 200, 200 200, 200 0, 0 0, 0 200), (50 50, 190 50, 50 200, 50 50), (20 20, 20 50, 50 50, 50 20, 20 20)))");
        Geometry b = this.read("POLYGON ((100 100, 100 50, 50 50, 50 100, 100 100))");
        Geometry expected = this.read("POLYGON ((3 2, 1 2, 2 5, 3 2))");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestNestedShellsIntersection() {
        Geometry a = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
        Geometry b = this.read("POLYGON ((120 180, 180 180, 180 120, 120 120, 120 180))");
        Geometry expected = this.read("POLYGON ((120 180, 180 180, 180 120, 120 120, 120 180))");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestNestedShellsUnion() {
        Geometry a = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
        Geometry b = this.read("POLYGON ((120 180, 180 180, 180 120, 120 120, 120 180))");
        Geometry expected = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestBoxLineIntersection() {
        Geometry a = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
        Geometry b = this.read("LINESTRING (50 150, 150 150)");
        Geometry expected = this.read("LINESTRING (100 150, 150 150)");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestBoxLineUnion() {
        Geometry a = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
        Geometry b = this.read("LINESTRING (50 150, 150 150)");
        Geometry expected = this.read("GEOMETRYCOLLECTION (LINESTRING (50 150, 100 150), POLYGON ((100 200, 200 200, 200 100, 100 100, 100 150, 100 200)))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestAdjacentBoxesIntersection() {
        Geometry a = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
        Geometry b = this.read("POLYGON ((300 200, 300 100, 200 100, 200 200, 300 200))");
        Geometry expected = this.read("LINESTRING (200 100, 200 200)");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestBoxContainingPolygonCollapseIntersection() {
        Geometry a = this.read("POLYGON ((100 200, 300 200, 300 0, 100 0, 100 200))");
        Geometry b = this.read("POLYGON ((250 100, 150 100, 150 100.4, 250 100))");
        Geometry expected = this.read("LINESTRING (150 100, 250 100)");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestBoxContainingPolygonCollapseManyPtsIntersection() {
        Geometry a = this.read("POLYGON ((100 200, 300 200, 300 0, 100 0, 100 200))");
        Geometry b = this.read("POLYGON ((250 100, 150 100, 150 100.4, 160 100.2, 170 100.1, 250 100))");
        Geometry expected = this.read("MULTILINESTRING ((150 100, 160 100), (160 100, 170 100), (170 100, 250 100))");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestPolygonsSpikeCollapseIntersection() {
        Geometry a = this.read("POLYGON ((2.33906 48.78994, 2.33768 48.78857, 2.33768 48.78788, 2.33974 48.78719, 2.34009 48.78616, 2.33974 48.78513, 2.33871 48.78479, 2.33734 48.78479, 2.33631 48.78445, 2.33597 48.78342, 2.33631 48.78239, 2.337 48.7817, 2.33734 48.78067, 2.33734 48.7793, 2.337 48.77827, 2.3178 48.7849, 2.32099 48.79376, 2.33906 48.78994))");
        Geometry b = this.read("POLYGON ((2.33768 48.78857, 2.33768 48.78788, 2.33974 48.78719, 2.34009 48.78616, 2.33974 48.78513, 2.33871 48.78479, 2.33734 48.78479, 2.33631 48.78445, 2.3362 48.7841, 2.33562 48.78582, 2.33425 48.78719, 2.33768 48.78857))");
        Geometry expected = this.read("MULTILINESTRING ((150 100, 160 100), (160 100, 170 100), (170 100, 250 100))");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 100000.0);
        this.checkEqual(expected, actual);
    }

    public void xtestCollapseAIncompleteRingUnion() {
        Geometry a = this.read("POLYGON ((0.9 1.7, 1.3 1.4, 2.1 1.4, 2.1 0.9, 1.3 0.9, 0.9 0, 0.9 1.7))");
        Geometry b = this.read("POLYGON ((1 3, 3 3, 3 1, 1.3 0.9, 1 0.4, 1 3))");
        Geometry expected = this.read("GEOMETRYCOLLECTION (LINESTRING (1 0, 1 1), POLYGON ((1 1, 1 2, 1 3, 3 3, 3 1, 2 1, 1 1)))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestCollapseHoleAlongEdgeOfBIntersection() {
        Geometry a = this.read("POLYGON ((0 3, 3 3, 3 0, 0 0, 0 3), (1 1.2, 1 1.1, 2.3 1.1, 1 1.2))");
        Geometry b = this.read("POLYGON ((1 1, 2 1, 2 0, 1 0, 1 1))");
        Geometry expected = this.read("POLYGON ((1 1, 2 1, 2 0, 1 0, 1 1))");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestCollapseResultShouldHavePolygonUnion() {
        Geometry a = this.read("POLYGON ((1 3.3, 1.3 1.4, 3.1 1.4, 3.1 0.9, 1.3 0.9, 1 -0.2, 0.8 1.3, 1 3.3))");
        Geometry b = this.read("POLYGON ((1 2.9, 2.9 2.9, 2.9 1.3, 1.7 1, 1.3 0.9, 1 0.4, 1 2.9))");
        Geometry expected = this.read("POLYGON ((1 1, 1 3, 3 3, 3 1, 2 1, 1 1))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestVerySmallBIntersection() {
        Geometry a = this.read("POLYGON ((2.526855443750341 48.82324221874807, 2.5258255 48.8235855, 2.5251389 48.8242722, 2.5241089 48.8246155, 2.5254822 48.8246155, 2.5265121 48.8242722, 2.526855443750341 48.82324221874807))");
        Geometry b = this.read("POLYGON ((2.526512100000002 48.824272199999996, 2.5265120999999953 48.8242722, 2.5265121 48.8242722, 2.526512100000002 48.824272199999996))");
        Geometry expected = this.read("POLYGON EMPTY");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1.0E8);
        this.checkEqual(expected, actual);
    }

    public void xtestEdgeDisappears() {
        Geometry a = this.read("LINESTRING (2.1279144 48.8445282, 2.126884443750796 48.84555818124935, 2.1268845 48.8455582, 2.1268845 48.8462448)");
        Geometry b = this.read("LINESTRING EMPTY");
        Geometry expected = this.read("LINESTRING EMPTY");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1000000.0);
        this.checkEqual(expected, actual);
    }

    public void xtestBcollapseLocateIssue() {
        Geometry a = this.read("POLYGON ((2.3442078 48.9331054, 2.3435211 48.9337921, 2.3428345 48.9358521, 2.3428345 48.9372253, 2.3433495 48.9370537, 2.3440361 48.936367, 2.3442078 48.9358521, 2.3442078 48.9331054))");
        Geometry b = this.read("POLYGON ((2.3442078 48.9331054, 2.3435211 48.9337921, 2.3433494499999985 48.934307100000005, 2.3438644 48.9341354, 2.3442078 48.9331055, 2.3442078 48.9331054))");
        Geometry expected = this.read("POLYGON EMPTY");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 1000.0);
        this.checkEqual(expected, actual);
    }

    public void xtestBcollapseEdgeLabeledInterior() {
        Geometry a = this.read("POLYGON ((2.384376506250038 48.91765596875102, 2.3840332 48.916626, 2.3840332 48.9138794, 2.3833466 48.9118195, 2.3812866 48.9111328, 2.37854 48.9111328, 2.3764801 48.9118195, 2.3723602 48.9159393, 2.3703003 48.916626, 2.3723602 48.9173126, 2.3737335 48.9186859, 2.3757935 48.9193726, 2.3812866 48.9193726, 2.3833466 48.9186859, 2.384376506250038 48.91765596875102))");
        Geometry b = this.read("MULTIPOLYGON (((2.3751067666731345 48.919143677778855, 2.3757935 48.9193726, 2.3812866 48.9193726, 2.3812866 48.9179993, 2.3809433 48.9169693, 2.3799133 48.916626, 2.3771667 48.916626, 2.3761368 48.9169693, 2.3754501 48.9190292, 2.3751067666731345 48.919143677778855)), ((2.3826108673454116 48.91893115612326, 2.3833466 48.9186859, 2.3840331750033394 48.91799930833141, 2.3830032 48.9183426, 2.3826108673454116 48.91893115612326)))");
        Geometry expected = this.read("POLYGON ((2.375 48.91833333333334, 2.375 48.92, 2.381666666666667 48.92, 2.381666666666667 48.91833333333334, 2.381666666666667 48.916666666666664, 2.38 48.916666666666664, 2.3766666666666665 48.916666666666664, 2.375 48.91833333333334))");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 600.0);
        this.checkEqual(expected, actual);
    }

    public void xtestBcollapseNullEdgeInRingIssue() {
        Geometry a = this.read("POLYGON ((2.2494507 48.8864136, 2.2484207 48.8867569, 2.2477341 48.8874435, 2.2470474 48.8874435, 2.2463608 48.8853836, 2.2453308 48.8850403, 2.2439575 48.8850403, 2.2429276 48.8853836, 2.2422409 48.8860703, 2.2360611 48.8970566, 2.2504807 48.8956833, 2.2494507 48.8864136))");
        Geometry b = this.read("POLYGON ((2.247734099999997 48.8874435, 2.2467041 48.8877869, 2.2453308 48.8877869, 2.2443008 48.8881302, 2.243957512499544 48.888473487500455, 2.2443008 48.8888168, 2.2453308 48.8891602, 2.2463608 48.8888168, 2.247734099999997 48.8874435))");
        Geometry expected = this.read("POLYGON EMPTY");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 200.0);
        this.checkEqual(expected, actual);
    }

    public void xtestLineUnion() {
        Geometry a = this.read("LINESTRING (0 0, 1 1)");
        Geometry b = this.read("LINESTRING (1 1, 2 2)");
        Geometry expected = this.read("LINESTRING (0 0, 1 1, 2 2)");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestLine2Union() {
        Geometry a = this.read("LINESTRING (0 0, 1 1, 0 1)");
        Geometry b = this.read("LINESTRING (1 1, 2 2, 3 3)");
        Geometry expected = this.read("MULTILINESTRING ((0 0, 1 1), (0 1, 1 1), (1 1, 2 2, 3 3))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestLine3Union() {
        Geometry a = this.read("MULTILINESTRING ((0 1, 1 1), (2 2, 2 0))");
        Geometry b = this.read("LINESTRING (0 0, 1 1, 2 2, 3 3)");
        Geometry expected = this.read("MULTILINESTRING ((0 0, 1 1), (0 1, 1 1), (1 1, 2 2), (2 0, 2 2), (2 2, 3 3))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestLine4Union() {
        Geometry a = this.read("LINESTRING (100 300, 200 300, 200 100, 100 100)");
        Geometry b = this.read("LINESTRING (300 300, 200 300, 200 300, 200 100, 300 100)");
        Geometry expected = this.read("MULTILINESTRING ((200 100, 100 100), (300 300, 200 300), (200 300, 200 100), (200 100, 300 100), (100 300, 200 300))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestLineFigure8Union() {
        Geometry a = this.read("LINESTRING (5 1, 2 2, 5 3, 2 4, 5 5)");
        Geometry b = this.read("LINESTRING (5 1, 8 2, 5 3, 8 4, 5 5)");
        Geometry expected = this.read("MULTILINESTRING ((5 3, 2 2, 5 1, 8 2, 5 3), (5 3, 2 4, 5 5, 8 4, 5 3))");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestLineRingUnion() {
        Geometry a = this.read("LINESTRING (1 1, 5 5, 9 1)");
        Geometry b = this.read("LINESTRING (1 1, 9 1)");
        Geometry expected = this.read("LINESTRING (1 1, 5 5, 9 1, 1 1)");
        Geometry actual = OverlayNGTestOne.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void xtestBCollapsedHoleEdgeLabelledExterior() {
        Geometry a = this.read("POLYGON ((309500 3477900, 309900 3477900, 309900 3477600, 309500 3477600, 309500 3477900), (309741.87561330193 3477680.6737848604, 309745.53718649445 3477677.607851833, 309779.0333599192 3477653.585555199, 309796.8051681937 3477642.143583868, 309741.87561330193 3477680.6737848604))");
        Geometry b = this.read("POLYGON ((309500 3477900, 309900 3477900, 309900 3477600, 309500 3477600, 309500 3477900), (309636.40806633036 3477777.2910157656, 309692.56085444096 3477721.966349552, 309745.53718649445 3477677.607851833, 309779.0333599192 3477653.585555199, 309792.0991800499 3477645.1734264474, 309779.03383125085 3477653.5853248164, 309745.53756275156 3477677.6076231804, 309692.5613257677 3477721.966119165, 309636.40806633036 3477777.2910157656))");
        Geometry expected = this.read("POLYGON ((309500 3477600, 309500 3477900, 309900 3477900, 309900 3477600, 309500 3477600), (309741.88 3477680.67, 309745.54 3477677.61, 309779.03 3477653.59, 309792.1 3477645.17, 309796.81 3477642.14, 309741.88 3477680.67))");
        Geometry actual = OverlayNGTestOne.intersection(a, b, 100.0);
        this.checkEqual(expected, actual);
    }

    public static Geometry union(Geometry a, Geometry b, double scaleFactor) {
        PrecisionModel pm = new PrecisionModel(scaleFactor);
        return OverlayNG.overlay((Geometry)a, (Geometry)b, (int)2, (PrecisionModel)pm);
    }

    public static Geometry intersection(Geometry a, Geometry b, double scaleFactor) {
        PrecisionModel pm = new PrecisionModel(scaleFactor);
        return OverlayNG.overlay((Geometry)a, (Geometry)b, (int)1, (PrecisionModel)pm);
    }
}

