/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.noding.snapround;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.noding.snapround.HotPixel;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class HotPixelTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(HotPixelTest.class);
    }

    public HotPixelTest(String name) {
        super(name);
    }

    public void testBelow() {
        this.checkIntersects(false, 1.0, 1.0, 100.0, 1.0, 0.98, 3.0, 0.5);
    }

    public void testAbove() {
        this.checkIntersects(false, 1.0, 1.0, 100.0, 1.0, 1.011, 3.0, 1.5);
    }

    public void testRightSideVerticalTouchAbove() {
        this.checkIntersects(false, 1.2, 1.2, 10.0, 1.25, 1.25, 1.25, 2.0);
    }

    public void testRightSideVerticalTouchBelow() {
        this.checkIntersects(false, 1.2, 1.2, 10.0, 1.25, 0.0, 1.25, 1.15);
    }

    public void testRightSideVerticalOverlap() {
        this.checkIntersects(false, 1.2, 1.2, 10.0, 1.25, 0.0, 1.25, 1.5);
    }

    public void testTopSideHorizontalTouchRight() {
        this.checkIntersects(false, 1.2, 1.2, 10.0, 1.25, 1.25, 2.0, 1.25);
    }

    public void testTopSideHorizontalTouchLeft() {
        this.checkIntersects(false, 1.2, 1.2, 10.0, 0.0, 1.25, 1.15, 1.25);
    }

    public void testTopSideHorizontalOverlap() {
        this.checkIntersects(false, 1.2, 1.2, 10.0, 0.0, 1.25, 1.9, 1.25);
    }

    public void testLeftSideVerticalTouchAbove() {
        this.checkIntersects(false, 1.2, 1.2, 10.0, 1.15, 1.25, 1.15, 2.0);
    }

    public void testLeftSideVerticalOverlap() {
        this.checkIntersects(true, 1.2, 1.2, 10.0, 1.15, 0.0, 1.15, 1.8);
    }

    public void testLeftSideVerticalTouchBelow() {
        this.checkIntersects(true, 1.2, 1.2, 10.0, 1.15, 0.0, 1.15, 1.15);
    }

    public void testLeftSideCrossRight() {
        this.checkIntersects(true, 1.2, 1.2, 10.0, 0.0, 1.19, 2.0, 1.21);
    }

    public void testLeftSideCrossTop() {
        this.checkIntersects(true, 1.2, 1.2, 10.0, 0.8, 0.8, 1.3, 1.39);
    }

    public void testLeftSideCrossBottom() {
        this.checkIntersects(true, 1.2, 1.2, 10.0, 1.0, 1.5, 1.3, 0.9);
    }

    public void testBottomSideHorizontalTouchRight() {
        this.checkIntersects(false, 1.2, 1.2, 10.0, 1.25, 1.15, 2.0, 1.15);
    }

    public void testBottomSideHorizontalTouchLeft() {
        this.checkIntersects(true, 1.2, 1.2, 10.0, 0.0, 1.15, 1.15, 1.15);
    }

    public void testBottomSideHorizontalOverlapLeft() {
        this.checkIntersects(true, 1.2, 1.2, 10.0, 0.0, 1.15, 1.2, 1.15);
    }

    public void testBottomSideHorizontalOverlap() {
        this.checkIntersects(true, 1.2, 1.2, 10.0, 0.0, 1.15, 1.9, 1.15);
    }

    public void testBottomSideHorizontalOverlapRight() {
        this.checkIntersects(true, 1.2, 1.2, 10.0, 1.2, 1.15, 1.4, 1.15);
    }

    public void testBottomSideCrossRight() {
        this.checkIntersects(true, 1.2, 1.2, 10.0, 1.1, 1.0, 1.4, 1.4);
    }

    public void testBottomSideCrossTop() {
        this.checkIntersects(true, 1.2, 1.2, 10.0, 1.1, 0.9, 1.3, 1.6);
    }

    public void testDiagonalDown() {
        this.checkIntersects(true, 1.2, 1.2, 10.0, 0.9, 1.5, 1.4, 1.0);
    }

    public void testDiagonalUp() {
        this.checkIntersects(true, 1.2, 1.2, 10.0, 0.9, 0.9, 1.5, 1.5);
    }

    public void testCornerULEndInside() {
        this.checkIntersects(true, 1.0, 1.0, 10.0, 0.7, 1.3, 0.98, 1.02);
    }

    public void testCornerLLEndInside() {
        this.checkIntersects(true, 1.0, 1.0, 10.0, 0.8, 0.8, 0.98, 0.98);
    }

    public void testCornerURStartInside() {
        this.checkIntersects(true, 1.0, 1.0, 10.0, 1.02, 1.02, 1.3, 1.3);
    }

    public void testCornerLRStartInside() {
        this.checkIntersects(true, 1.0, 1.0, 10.0, 1.02, 0.98, 1.3, 0.7);
    }

    public void testCornerLLTangent() {
        this.checkIntersects(true, 1.0, 1.0, 10.0, 0.9, 1.0, 1.0, 0.9);
    }

    public void testCornerLLTangentNoTouch() {
        this.checkIntersects(false, 1.0, 1.0, 10.0, 0.9, 0.9, 1.0, 0.9);
    }

    public void testCornerULTangent() {
        this.checkIntersects(false, 1.0, 1.0, 10.0, 0.9, 1.0, 1.0, 1.1);
    }

    public void testCornerURTangent() {
        this.checkIntersects(false, 1.0, 1.0, 10.0, 1.0, 1.1, 1.1, 1.0);
    }

    public void testCornerLRTangent() {
        this.checkIntersects(false, 1.0, 1.0, 10.0, 1.0, 0.9, 1.1, 1.0);
    }

    public void testCornerULTouchEnd() {
        this.checkIntersects(false, 1.0, 1.0, 10.0, 0.9, 1.1, 0.95, 1.05);
    }

    private void checkIntersects(boolean expected, double x, double y, double scale, double x1, double y1, double x2, double y2) {
        HotPixel hp = new HotPixel(new Coordinate(x, y), scale);
        Coordinate p1 = new Coordinate(x1, y1);
        Coordinate p2 = new Coordinate(x2, y2);
        boolean actual = hp.intersects(p1, p2);
        HotPixelTest.assertEquals((boolean)expected, (boolean)actual);
    }
}

