/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.io;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.io.WKBReader;
import com.hazelcast.shaded.org.locationtech.jts.io.WKBWriter;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class WKBWriterTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(WKBWriterTest.class);
    }

    public WKBWriterTest(String name) {
        super(name);
    }

    public void testSRID() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        Point p1 = gf.createPoint(new Coordinate(1.0, 2.0));
        p1.setSRID(1234);
        WKBWriter w = new WKBWriter();
        byte[] wkb = w.write((Geometry)p1);
        byte b = (byte)(wkb[1] & 0x20);
        WKBWriterTest.assertEquals((int)0, (int)b);
        WKBReader r = new WKBReader(gf);
        Point p2 = (Point)r.read(wkb);
        WKBWriterTest.assertTrue((boolean)p1.equalsExact((Geometry)p2));
        WKBWriterTest.assertEquals((int)0, (int)p2.getSRID());
        w = new WKBWriter(2, true);
        wkb = w.write((Geometry)p1);
        b = (byte)(wkb[1] & 0x20);
        WKBWriterTest.assertEquals((int)32, (int)b);
        int srid = (wkb[5] & 0xFF) << 24 | (wkb[6] & 0xFF) << 16 | (wkb[7] & 0xFF) << 8 | wkb[8] & 0xFF;
        WKBWriterTest.assertEquals((int)1234, (int)srid);
        r = new WKBReader(gf);
        p2 = (Point)r.read(wkb);
        WKBWriterTest.assertTrue((boolean)p1.equalsExact((Geometry)p2));
        WKBWriterTest.assertEquals((int)1234, (int)p2.getSRID());
    }

    public void testPointEmpty2D() {
        this.checkWKB("POINT EMPTY", 2, "0101000000000000000000F87F000000000000F87F");
    }

    public void testPointEmpty3D() {
        this.checkWKB("POINT EMPTY", 3, "0101000080000000000000F87F000000000000F87F000000000000F87F");
    }

    public void testPolygonEmpty2DSRID() {
        this.checkWKB("POLYGON EMPTY", 2, 2, 4326, "0103000020E610000000000000");
    }

    public void testPolygonEmpty2D() {
        this.checkWKB("POLYGON EMPTY", 2, "010300000000000000");
    }

    public void testPolygonEmpty3D() {
        this.checkWKB("POLYGON EMPTY", 3, "010300008000000000");
    }

    public void testMultiPolygonEmpty2D() {
        this.checkWKB("MULTIPOLYGON EMPTY", 2, "010600000000000000");
    }

    public void testMultiPolygonEmpty3D() {
        this.checkWKB("MULTIPOLYGON EMPTY", 3, "010600008000000000");
    }

    public void testMultiPolygonEmpty2DSRID() {
        this.checkWKB("MULTIPOLYGON EMPTY", 2, 2, 4326, "0106000020E610000000000000");
    }

    public void testMultiPolygon() {
        this.checkWKB("MULTIPOLYGON(((0 0,0 10,10 10,10 0,0 0),(1 1,1 9,9 9,9 1,1 1)),((-9 0,-9 10,-1 10,-1 0,-9 0)))", 2, 2, 4326, "0106000020E61000000200000001030000000200000005000000000000000000000000000000000000000000000000000000000000000000244000000000000024400000000000002440000000000000244000000000000000000000000000000000000000000000000005000000000000000000F03F000000000000F03F000000000000F03F0000000000002240000000000000224000000000000022400000000000002240000000000000F03F000000000000F03F000000000000F03F0103000000010000000500000000000000000022C0000000000000000000000000000022C00000000000002440000000000000F0BF0000000000002440000000000000F0BF000000000000000000000000000022C00000000000000000");
    }

    public void testGeometryCollection() {
        this.checkWKB("GEOMETRYCOLLECTION(POINT(0 1),POINT(0 1),POINT(2 3),LINESTRING(2 3,4 5),LINESTRING(0 1,2 3),LINESTRING(4 5,6 7),POLYGON((0 0,0 10,10 10,10 0,0 0),(1 1,1 9,9 9,9 1,1 1)),POLYGON((0 0,0 10,10 10,10 0,0 0),(1 1,1 9,9 9,9 1,1 1)),POLYGON((-9 0,-9 10,-1 10,-1 0,-9 0)))", 2, 2, 4326, "0107000020E61000000900000001010000000000000000000000000000000000F03F01010000000000000000000000000000000000F03F01010000000000000000000040000000000000084001020000000200000000000000000000400000000000000840000000000000104000000000000014400102000000020000000000000000000000000000000000F03F000000000000004000000000000008400102000000020000000000000000001040000000000000144000000000000018400000000000001C4001030000000200000005000000000000000000000000000000000000000000000000000000000000000000244000000000000024400000000000002440000000000000244000000000000000000000000000000000000000000000000005000000000000000000F03F000000000000F03F000000000000F03F0000000000002240000000000000224000000000000022400000000000002240000000000000F03F000000000000F03F000000000000F03F01030000000200000005000000000000000000000000000000000000000000000000000000000000000000244000000000000024400000000000002440000000000000244000000000000000000000000000000000000000000000000005000000000000000000F03F000000000000F03F000000000000F03F0000000000002240000000000000224000000000000022400000000000002240000000000000F03F000000000000F03F000000000000F03F0103000000010000000500000000000000000022C0000000000000000000000000000022C00000000000002440000000000000F0BF0000000000002440000000000000F0BF000000000000000000000000000022C00000000000000000");
    }

    void checkWKB(String wkt, int dimension, String expectedWKBHex) {
        this.checkWKB(wkt, dimension, 2, -1, expectedWKBHex);
    }

    void checkWKB(String wkt, int dimension, int byteOrder, int srid, String expectedWKBHex) {
        Geometry geom = this.read(wkt);
        boolean includeSRID = false;
        if (srid >= 0) {
            includeSRID = true;
            geom.setSRID(srid);
        }
        WKBWriter wkbWriter = new WKBWriter(dimension, byteOrder, includeSRID);
        byte[] wkb = wkbWriter.write(geom);
        String wkbHex = WKBWriter.toHex((byte[])wkb);
        WKBWriterTest.assertEquals((String)expectedWKBHex, (String)wkbHex);
    }
}

