/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiLineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class LineStringImplTest
extends GeometryTestCase {
    PrecisionModel precisionModel = new PrecisionModel(1000.0);
    GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);

    public static void main(String[] args) {
        TestRunner.run((Test)LineStringImplTest.suite());
    }

    public LineStringImplTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(LineStringImplTest.class);
    }

    public void testIsSimple() throws Exception {
        LineString l1 = (LineString)this.reader.read("LINESTRING (0 0, 10 10, 10 0, 0 10, 0 0)");
        LineStringImplTest.assertTrue((!l1.isSimple() ? 1 : 0) != 0);
        LineString l2 = (LineString)this.reader.read("LINESTRING (0 0, 10 10, 10 0, 0 10)");
        LineStringImplTest.assertTrue((!l2.isSimple() ? 1 : 0) != 0);
    }

    public void testIsCoordinate() throws Exception {
        LineString l = (LineString)this.reader.read("LINESTRING (0 0, 10 10, 10 0)");
        LineStringImplTest.assertTrue((boolean)l.isCoordinate(new Coordinate(0.0, 0.0)));
        LineStringImplTest.assertTrue((!l.isCoordinate(new Coordinate(5.0, 0.0)) ? 1 : 0) != 0);
    }

    public void testUnclosedLinearRing() {
        try {
            this.geometryFactory.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(2.0, 1.0)});
            LineStringImplTest.assertTrue((boolean)false);
        }
        catch (Exception e) {
            LineStringImplTest.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    public void testEquals1() throws Exception {
        LineString l1 = (LineString)this.reader.read("LINESTRING(1.111 2.222, 3.333 4.444)");
        LineString l2 = (LineString)this.reader.read("LINESTRING(1.111 2.222, 3.333 4.444)");
        LineStringImplTest.assertTrue((boolean)l1.equals((Geometry)l2));
    }

    public void testEquals2() throws Exception {
        LineString l1 = (LineString)this.reader.read("LINESTRING(1.111 2.222, 3.333 4.444)");
        LineString l2 = (LineString)this.reader.read("LINESTRING(3.333 4.444, 1.111 2.222)");
        LineStringImplTest.assertTrue((boolean)l1.equals((Geometry)l2));
    }

    public void testEquals3() throws Exception {
        LineString l2;
        LineString l1 = (LineString)this.reader.read("LINESTRING(1.111 2.222, 3.333 4.444)");
        LineStringImplTest.assertTrue((!l1.equals((Geometry)(l2 = (LineString)this.reader.read("LINESTRING(3.333 4.443, 1.111 2.222)"))) ? 1 : 0) != 0);
    }

    public void testEquals4() throws Exception {
        LineString l2;
        LineString l1 = (LineString)this.reader.read("LINESTRING(1.111 2.222, 3.333 4.444)");
        LineStringImplTest.assertTrue((!l1.equals((Geometry)(l2 = (LineString)this.reader.read("LINESTRING(3.333 4.4445, 1.111 2.222)"))) ? 1 : 0) != 0);
    }

    public void testEquals5() throws Exception {
        LineString l2;
        LineString l1 = (LineString)this.reader.read("LINESTRING(1.111 2.222, 3.333 4.444)");
        LineStringImplTest.assertTrue((!l1.equals((Geometry)(l2 = (LineString)this.reader.read("LINESTRING(3.333 4.4446, 1.111 2.222)"))) ? 1 : 0) != 0);
    }

    public void testEquals6() throws Exception {
        LineString l1 = (LineString)this.reader.read("LINESTRING(1.111 2.222, 3.333 4.444, 5.555 6.666)");
        LineString l2 = (LineString)this.reader.read("LINESTRING(1.111 2.222, 3.333 4.444, 5.555 6.666)");
        LineStringImplTest.assertTrue((boolean)l1.equals((Geometry)l2));
    }

    public void testEquals7() throws Exception {
        LineString l2;
        LineString l1 = (LineString)this.reader.read("LINESTRING(1.111 2.222, 5.555 6.666, 3.333 4.444)");
        LineStringImplTest.assertTrue((!l1.equals((Geometry)(l2 = (LineString)this.reader.read("LINESTRING(1.111 2.222, 3.333 4.444, 5.555 6.666)"))) ? 1 : 0) != 0);
    }

    public void testGetCoordinates() throws Exception {
        LineString l = (LineString)this.reader.read("LINESTRING(1.111 2.222, 5.555 6.666, 3.333 4.444)");
        Coordinate[] coordinates = l.getCoordinates();
        LineStringImplTest.assertEquals((Object)new Coordinate(5.555, 6.666), (Object)coordinates[1]);
    }

    public void testIsClosed() throws Exception {
        LineString l = (LineString)this.reader.read("LINESTRING EMPTY");
        LineStringImplTest.assertTrue((boolean)l.isEmpty());
        LineStringImplTest.assertTrue((!l.isClosed() ? 1 : 0) != 0);
        LinearRing r = this.geometryFactory.createLinearRing((CoordinateSequence)null);
        LineStringImplTest.assertTrue((boolean)r.isEmpty());
        LineStringImplTest.assertTrue((boolean)r.isClosed());
        MultiLineString m = this.geometryFactory.createMultiLineString(new LineString[]{l, r});
        LineStringImplTest.assertTrue((!m.isClosed() ? 1 : 0) != 0);
        MultiLineString m2 = this.geometryFactory.createMultiLineString(new LineString[]{r});
        LineStringImplTest.assertTrue((!m2.isClosed() ? 1 : 0) != 0);
    }

    public void testGetGeometryType() throws Exception {
        LineString l = (LineString)this.reader.read("LINESTRING EMPTY");
        LineStringImplTest.assertEquals((String)"LineString", (String)l.getGeometryType());
    }

    public void testEquals8() throws Exception {
        WKTReader reader = new WKTReader(new GeometryFactory(new PrecisionModel(1000.0), 0));
        MultiLineString l1 = (MultiLineString)reader.read("MULTILINESTRING((1732328800 519578384, 1732026179 519976285, 1731627364 519674014, 1731929984 519276112, 1732328800 519578384))");
        MultiLineString l2 = (MultiLineString)reader.read("MULTILINESTRING((1731627364 519674014, 1731929984 519276112, 1732328800 519578384, 1732026179 519976285, 1731627364 519674014))");
        LineStringImplTest.assertTrue((boolean)l1.equals((Geometry)l2));
    }

    public void testEquals9() throws Exception {
        WKTReader reader = new WKTReader(new GeometryFactory(new PrecisionModel(1.0), 0));
        MultiLineString l1 = (MultiLineString)reader.read("MULTILINESTRING((1732328800 519578384, 1732026179 519976285, 1731627364 519674014, 1731929984 519276112, 1732328800 519578384))");
        MultiLineString l2 = (MultiLineString)reader.read("MULTILINESTRING((1731627364 519674014, 1731929984 519276112, 1732328800 519578384, 1732026179 519976285, 1731627364 519674014))");
        LineStringImplTest.assertTrue((boolean)l1.equals((Geometry)l2));
    }

    public void testEquals10() throws Exception {
        WKTReader reader = new WKTReader(new GeometryFactory(new PrecisionModel(1.0), 0));
        Geometry l1 = reader.read("POLYGON((1732328800 519578384, 1732026179 519976285, 1731627364 519674014, 1731929984 519276112, 1732328800 519578384))");
        Geometry l2 = reader.read("POLYGON((1731627364 519674014, 1731929984 519276112, 1732328800 519578384, 1732026179 519976285, 1731627364 519674014))");
        l1.normalize();
        l2.normalize();
        LineStringImplTest.assertTrue((boolean)l1.equalsExact(l2));
    }

    public void testFiveZeros() {
        LineString ls = new GeometryFactory().createLineString(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 0.0), new Coordinate(0.0, 0.0), new Coordinate(0.0, 0.0), new Coordinate(0.0, 0.0)});
        LineStringImplTest.assertTrue((boolean)ls.isClosed());
    }

    public void testLinearRingConstructor() throws Exception {
        LinearRing ring = new GeometryFactory().createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(10.0, 10.0), new Coordinate(0.0, 0.0)});
        Geometry ringFromWKT = this.read("LINEARRING (0 0, 10 10, 0 0)");
        this.checkEqual((Geometry)ring, ringFromWKT);
    }
}

