/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.Distance;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;

public class NonRobustCGAlgorithms {
    public static boolean isPointInRing(Coordinate p, Coordinate[] ring) {
        int crossings = 0;
        int nPts = ring.length;
        for (int i = 1; i < nPts; ++i) {
            double xInt;
            int i1 = i - 1;
            Coordinate p1 = ring[i];
            Coordinate p2 = ring[i1];
            double x1 = p1.x - p.x;
            double y1 = p1.y - p.y;
            double x2 = p2.x - p.x;
            double y2 = p2.y - p.y;
            if (!(y1 > 0.0 && y2 <= 0.0) && (!(y2 > 0.0) || !(y1 <= 0.0)) || !(0.0 < (xInt = (x1 * y2 - x2 * y1) / (y2 - y1)))) continue;
            ++crossings;
        }
        return crossings % 2 == 1;
    }

    public static boolean isCCW(Coordinate[] ring) {
        int nPts = ring.length - 1;
        if (nPts < 4) {
            return false;
        }
        Coordinate hip = ring[0];
        int hii = 0;
        for (int i = 1; i <= nPts; ++i) {
            Coordinate p = ring[i];
            if (!(p.y > hip.y)) continue;
            hip = p;
            hii = i;
        }
        int iPrev = hii;
        while (ring[iPrev = (iPrev - 1) % nPts].equals((Object)hip) && iPrev != hii) {
        }
        int iNext = hii;
        while (ring[iNext = (iNext + 1) % nPts].equals((Object)hip) && iNext != hii) {
        }
        Coordinate prev = ring[iPrev];
        Coordinate next = ring[iNext];
        if (prev.equals((Object)hip) || next.equals((Object)hip) || prev.equals((Object)next)) {
            throw new IllegalArgumentException("degenerate ring (does not contain 3 different points)");
        }
        double next2x = next.x - hip.x;
        double prev2y = prev.y - hip.y;
        double next2y = next.y - hip.y;
        double prev2x = prev.x - hip.x;
        double disc = next2x * prev2y - next2y * prev2x;
        if (disc == 0.0) {
            return prev.x > next.x;
        }
        return disc > 0.0;
    }

    public static int orientationIndex(Coordinate p1, Coordinate p2, Coordinate q) {
        double dx1 = p2.x - p1.x;
        double dy2 = q.y - p2.y;
        double dx2 = q.x - p2.x;
        double dy1 = p2.y - p1.y;
        double det = dx1 * dy2 - dx2 * dy1;
        if (det > 0.0) {
            return 1;
        }
        if (det < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double distanceLineLine(Coordinate A2, Coordinate B2, Coordinate C2, Coordinate D) {
        if (A2.equals((Object)B2)) {
            return Distance.pointToSegment((Coordinate)A2, (Coordinate)C2, (Coordinate)D);
        }
        if (C2.equals((Object)D)) {
            return Distance.pointToSegment((Coordinate)D, (Coordinate)A2, (Coordinate)B2);
        }
        double r_top = (A2.y - C2.y) * (D.x - C2.x) - (A2.x - C2.x) * (D.y - C2.y);
        double r_bot = (B2.x - A2.x) * (D.y - C2.y) - (B2.y - A2.y) * (D.x - C2.x);
        double s_top = (A2.y - C2.y) * (B2.x - A2.x) - (A2.x - C2.x) * (B2.y - A2.y);
        double s_bot = (B2.x - A2.x) * (D.y - C2.y) - (B2.y - A2.y) * (D.x - C2.x);
        if (r_bot == 0.0 || s_bot == 0.0) {
            return Math.min(Distance.pointToSegment((Coordinate)A2, (Coordinate)C2, (Coordinate)D), Math.min(Distance.pointToSegment((Coordinate)B2, (Coordinate)C2, (Coordinate)D), Math.min(Distance.pointToSegment((Coordinate)C2, (Coordinate)A2, (Coordinate)B2), Distance.pointToSegment((Coordinate)D, (Coordinate)A2, (Coordinate)B2))));
        }
        double s = s_top / s_bot;
        double r = r_top / r_bot;
        if (r < 0.0 || r > 1.0 || s < 0.0 || s > 1.0) {
            return Math.min(Distance.pointToSegment((Coordinate)A2, (Coordinate)C2, (Coordinate)D), Math.min(Distance.pointToSegment((Coordinate)B2, (Coordinate)C2, (Coordinate)D), Math.min(Distance.pointToSegment((Coordinate)C2, (Coordinate)A2, (Coordinate)B2), Distance.pointToSegment((Coordinate)D, (Coordinate)A2, (Coordinate)B2))));
        }
        return 0.0;
    }
}

