/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.util;

import com.hazelcast.shaded.org.apache.commons.math3.stat.StatUtils;
import com.hazelcast.shaded.org.apache.commons.math3.util.DoubleArray;
import org.junit.Assert;
import org.junit.Test;

public abstract class DoubleArrayAbstractTest {
    protected DoubleArray da = null;
    protected DoubleArray ra = null;

    @Test
    public void testAdd1000() {
        for (int i = 0; i < 1000; ++i) {
            this.da.addElement((double)i);
        }
        Assert.assertEquals((String)"Number of elements should be equal to 1000 after adding 1000 values", (long)1000L, (long)this.da.getNumElements());
        Assert.assertEquals((String)"The element at the 56th index should be 56", (double)56.0, (double)this.da.getElement(56), (double)Double.MIN_VALUE);
    }

    @Test
    public void testGetValues() {
        double[] controlArray = new double[]{2.0, 4.0, 6.0};
        this.da.addElement(2.0);
        this.da.addElement(4.0);
        this.da.addElement(6.0);
        double[] testArray = this.da.getElements();
        for (int i = 0; i < this.da.getNumElements(); ++i) {
            Assert.assertEquals((String)("The testArray values should equal the controlArray values, index i: " + i + " does not match"), (double)testArray[i], (double)controlArray[i], (double)Double.MIN_VALUE);
        }
    }

    @Test
    public void testAddElementRolling() {
        this.ra.addElement(0.5);
        this.ra.addElement(1.0);
        this.ra.addElement(1.0);
        this.ra.addElement(1.0);
        this.ra.addElement(1.0);
        this.ra.addElement(1.0);
        this.ra.addElementRolling(2.0);
        Assert.assertEquals((String)"There should be 6 elements in the eda", (long)6L, (long)this.ra.getNumElements());
        Assert.assertEquals((String)"The max element should be 2.0", (double)2.0, (double)StatUtils.max((double[])this.ra.getElements()), (double)Double.MIN_VALUE);
        Assert.assertEquals((String)"The min element should be 1.0", (double)1.0, (double)StatUtils.min((double[])this.ra.getElements()), (double)Double.MIN_VALUE);
        for (int i = 0; i < 1024; ++i) {
            this.ra.addElementRolling((double)i);
        }
        Assert.assertEquals((String)"We just inserted 1024 rolling elements, num elements should still be 6", (long)6L, (long)this.ra.getNumElements());
    }

    @Test
    public void testMinMax() {
        this.da.addElement(2.0);
        this.da.addElement(22.0);
        this.da.addElement(-2.0);
        this.da.addElement(21.0);
        this.da.addElement(22.0);
        this.da.addElement(42.0);
        this.da.addElement(62.0);
        this.da.addElement(22.0);
        this.da.addElement(122.0);
        this.da.addElement(1212.0);
        Assert.assertEquals((String)"Min should be -2.0", (double)-2.0, (double)StatUtils.min((double[])this.da.getElements()), (double)Double.MIN_VALUE);
        Assert.assertEquals((String)"Max should be 1212.0", (double)1212.0, (double)StatUtils.max((double[])this.da.getElements()), (double)Double.MIN_VALUE);
    }
}

