/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.transform;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.transform.RealTransformer;
import com.hazelcast.shaded.org.apache.commons.math3.transform.TransformType;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public abstract class RealTransformerAbstractTest {
    private static final long SEED = 20110119L;

    abstract RealTransformer createRealTransformer();

    abstract int getInvalidDataSize(int var1);

    abstract int getNumberOfInvalidDataSizes();

    abstract int getNumberOfValidDataSizes();

    abstract double getRelativeTolerance(int var1);

    abstract int getValidDataSize(int var1);

    abstract UnivariateFunction getValidFunction();

    abstract double getValidLowerBound();

    abstract double getValidUpperBound();

    abstract double[] transform(double[] var1, TransformType var2);

    @Test
    public void testTransformRealInvalidDataSize() {
        TransformType[] type = TransformType.values();
        RealTransformer transformer = this.createRealTransformer();
        for (int i = 0; i < this.getNumberOfInvalidDataSizes(); ++i) {
            int n = this.getInvalidDataSize(i);
            for (int j = 0; j < type.length; ++j) {
                try {
                    transformer.transform(this.createRealData(n), type[j]);
                    Assert.fail((String)(type[j] + ", " + n));
                    continue;
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testTransformFunctionInvalidDataSize() {
        TransformType[] type = TransformType.values();
        RealTransformer transformer = this.createRealTransformer();
        UnivariateFunction f = this.getValidFunction();
        double a = this.getValidLowerBound();
        double b = this.getValidUpperBound();
        for (int i = 0; i < this.getNumberOfInvalidDataSizes(); ++i) {
            int n = this.getInvalidDataSize(i);
            for (int j = 0; j < type.length; ++j) {
                try {
                    transformer.transform(f, a, b, n, type[j]);
                    Assert.fail((String)(type[j] + ", " + n));
                    continue;
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testTransformFunctionNotStrictlyPositiveNumberOfSamples() {
        TransformType[] type = TransformType.values();
        RealTransformer transformer = this.createRealTransformer();
        UnivariateFunction f = this.getValidFunction();
        double a = this.getValidLowerBound();
        double b = this.getValidUpperBound();
        for (int i = 0; i < this.getNumberOfValidDataSizes(); ++i) {
            int n = this.getValidDataSize(i);
            for (int j = 0; j < type.length; ++j) {
                try {
                    transformer.transform(f, a, b, -n, type[j]);
                    Assert.fail((String)(type[j] + ", " + -n));
                    continue;
                }
                catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testTransformFunctionInvalidBounds() {
        TransformType[] type = TransformType.values();
        RealTransformer transformer = this.createRealTransformer();
        UnivariateFunction f = this.getValidFunction();
        double a = this.getValidLowerBound();
        double b = this.getValidUpperBound();
        for (int i = 0; i < this.getNumberOfValidDataSizes(); ++i) {
            int n = this.getValidDataSize(i);
            for (int j = 0; j < type.length; ++j) {
                try {
                    transformer.transform(f, b, a, n, type[j]);
                    Assert.fail((String)(type[j] + ", " + b + ", " + a));
                    continue;
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testTransformReal() {
        TransformType[] type = TransformType.values();
        for (int i = 0; i < this.getNumberOfValidDataSizes(); ++i) {
            int n = this.getValidDataSize(i);
            double tol = this.getRelativeTolerance(i);
            for (int j = 0; j < type.length; ++j) {
                this.doTestTransformReal(n, tol, type[j]);
            }
        }
    }

    @Test
    public void testTransformFunction() {
        TransformType[] type = TransformType.values();
        for (int i = 0; i < this.getNumberOfValidDataSizes(); ++i) {
            int n = this.getValidDataSize(i);
            double tol = this.getRelativeTolerance(i);
            for (int j = 0; j < type.length; ++j) {
                this.doTestTransformFunction(n, tol, type[j]);
            }
        }
    }

    double[] createRealData(int n) {
        Random random = new Random(20110119L);
        double[] data = new double[n];
        for (int i = 0; i < n; ++i) {
            data[i] = 2.0 * random.nextDouble() - 1.0;
        }
        return data;
    }

    private void doTestTransformReal(int n, double tol, TransformType type) {
        RealTransformer transformer = this.createRealTransformer();
        double[] x = this.createRealData(n);
        double[] expected = this.transform(x, type);
        double[] actual = transformer.transform(x, type);
        for (int i = 0; i < n; ++i) {
            String msg = String.format("%d, %d", n, i);
            double delta = tol * FastMath.abs((double)expected[i]);
            Assert.assertEquals((String)msg, (double)expected[i], (double)actual[i], (double)delta);
        }
    }

    private void doTestTransformFunction(int n, double tol, TransformType type) {
        RealTransformer transformer = this.createRealTransformer();
        UnivariateFunction f = this.getValidFunction();
        double a = this.getValidLowerBound();
        double b = this.getValidUpperBound();
        double[] x = this.createRealData(n);
        for (int i = 0; i < n; ++i) {
            double t = a + (double)i * (b - a) / (double)n;
            x[i] = f.value(t);
        }
        double[] expected = this.transform(x, type);
        double[] actual = transformer.transform(f, a, b, n, type);
        for (int i = 0; i < n; ++i) {
            String msg = String.format("%d, %d", n, i);
            double delta = tol * FastMath.abs((double)expected[i]);
            Assert.assertEquals((String)msg, (double)expected[i], (double)actual[i], (double)delta);
        }
    }
}

