/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.transform;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sin;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sinc;
import com.hazelcast.shaded.org.apache.commons.math3.complex.Complex;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.transform.DftNormalization;
import com.hazelcast.shaded.org.apache.commons.math3.transform.FastFourierTransformer;
import com.hazelcast.shaded.org.apache.commons.math3.transform.TransformType;
import com.hazelcast.shaded.org.apache.commons.math3.transform.TransformUtils;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class FastFourierTransformerTest {
    private static final long SEED = 20110111L;

    @Test
    public void testTransformComplexSizeNotAPowerOfTwo() {
        int n = 127;
        Complex[] x = FastFourierTransformerTest.createComplexData(127);
        DftNormalization[] norm = DftNormalization.values();
        TransformType[] type = TransformType.values();
        for (int i = 0; i < norm.length; ++i) {
            for (int j = 0; j < type.length; ++j) {
                FastFourierTransformer fft = new FastFourierTransformer(norm[i]);
                try {
                    fft.transform(x, type[j]);
                    Assert.fail((String)(norm[i] + ", " + type[j] + ": MathIllegalArgumentException was expected"));
                    continue;
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testTransformRealSizeNotAPowerOfTwo() {
        int n = 127;
        double[] x = FastFourierTransformerTest.createRealData(127);
        DftNormalization[] norm = DftNormalization.values();
        TransformType[] type = TransformType.values();
        for (int i = 0; i < norm.length; ++i) {
            for (int j = 0; j < type.length; ++j) {
                FastFourierTransformer fft = new FastFourierTransformer(norm[i]);
                try {
                    fft.transform(x, type[j]);
                    Assert.fail((String)(norm[i] + ", " + type[j] + ": MathIllegalArgumentException was expected"));
                    continue;
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testTransformFunctionSizeNotAPowerOfTwo() {
        int n = 127;
        Sin f = new Sin();
        DftNormalization[] norm = DftNormalization.values();
        TransformType[] type = TransformType.values();
        for (int i = 0; i < norm.length; ++i) {
            for (int j = 0; j < type.length; ++j) {
                FastFourierTransformer fft = new FastFourierTransformer(norm[i]);
                try {
                    fft.transform((UnivariateFunction)f, 0.0, Math.PI, 127, type[j]);
                    Assert.fail((String)(norm[i] + ", " + type[j] + ": MathIllegalArgumentException was expected"));
                    continue;
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testTransformFunctionNotStrictlyPositiveNumberOfSamples() {
        int n = -128;
        Sin f = new Sin();
        DftNormalization[] norm = DftNormalization.values();
        TransformType[] type = TransformType.values();
        for (int i = 0; i < norm.length; ++i) {
            for (int j = 0; j < type.length; ++j) {
                FastFourierTransformer fft = new FastFourierTransformer(norm[i]);
                try {
                    fft.transform((UnivariateFunction)f, 0.0, Math.PI, -128, type[j]);
                    fft.transform((UnivariateFunction)f, 0.0, Math.PI, -128, type[j]);
                    Assert.fail((String)(norm[i] + ", " + type[j] + ": NotStrictlyPositiveException was expected"));
                    continue;
                }
                catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testTransformFunctionInvalidBounds() {
        int n = 128;
        Sin f = new Sin();
        DftNormalization[] norm = DftNormalization.values();
        TransformType[] type = TransformType.values();
        for (int i = 0; i < norm.length; ++i) {
            for (int j = 0; j < type.length; ++j) {
                FastFourierTransformer fft = new FastFourierTransformer(norm[i]);
                try {
                    fft.transform((UnivariateFunction)f, Math.PI, 0.0, 128, type[j]);
                    Assert.fail((String)(norm[i] + ", " + type[j] + ": NumberIsTooLargeException was expected"));
                    continue;
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    // empty catch block
                }
            }
        }
    }

    private static Complex[] createComplexData(int n) {
        Random random = new Random(20110111L);
        Complex[] data = new Complex[n];
        for (int i = 0; i < n; ++i) {
            double re = 2.0 * random.nextDouble() - 1.0;
            double im = 2.0 * random.nextDouble() - 1.0;
            data[i] = new Complex(re, im);
        }
        return data;
    }

    private static double[] createRealData(int n) {
        Random random = new Random(20110111L);
        double[] data = new double[n];
        for (int i = 0; i < n; ++i) {
            data[i] = 2.0 * random.nextDouble() - 1.0;
        }
        return data;
    }

    private static Complex[] dft(Complex[] x, int sgn) {
        int i;
        int n = x.length;
        double[] cos = new double[n];
        double[] sin = new double[n];
        Complex[] y = new Complex[n];
        for (i = 0; i < n; ++i) {
            double arg = Math.PI * 2 * (double)i / (double)n;
            cos[i] = FastMath.cos((double)arg);
            sin[i] = FastMath.sin((double)arg);
        }
        for (i = 0; i < n; ++i) {
            double yr = 0.0;
            double yi = 0.0;
            for (int j = 0; j < n; ++j) {
                int index = i * j % n;
                double c = cos[index];
                double s = sin[index];
                double xr = x[j].getReal();
                double xi = x[j].getImaginary();
                yr += c * xr - (double)sgn * s * xi;
                yi += (double)sgn * s * xr + c * xi;
            }
            y[i] = new Complex(yr, yi);
        }
        return y;
    }

    private static void doTestTransformComplex(int n, double tol, DftNormalization normalization, TransformType type) {
        double s;
        Complex[] expected;
        FastFourierTransformer fft = new FastFourierTransformer(normalization);
        Complex[] x = FastFourierTransformerTest.createComplexData(n);
        if (type == TransformType.FORWARD) {
            expected = FastFourierTransformerTest.dft(x, -1);
            s = normalization == DftNormalization.STANDARD ? 1.0 : 1.0 / FastMath.sqrt((double)n);
        } else {
            expected = FastFourierTransformerTest.dft(x, 1);
            s = normalization == DftNormalization.STANDARD ? 1.0 / (double)n : 1.0 / FastMath.sqrt((double)n);
        }
        Complex[] actual = fft.transform(x, type);
        for (int i = 0; i < n; ++i) {
            String msg = String.format("%s, %s, %d, %d", normalization, type, n, i);
            double re = s * expected[i].getReal();
            Assert.assertEquals((String)msg, (double)re, (double)actual[i].getReal(), (double)(tol * FastMath.abs((double)re)));
            double im = s * expected[i].getImaginary();
            Assert.assertEquals((String)msg, (double)im, (double)actual[i].getImaginary(), (double)(tol * FastMath.abs((double)re)));
        }
    }

    private static void doTestTransformReal(int n, double tol, DftNormalization normalization, TransformType type) {
        double s;
        Complex[] expected;
        FastFourierTransformer fft = new FastFourierTransformer(normalization);
        double[] x = FastFourierTransformerTest.createRealData(n);
        Complex[] xc = new Complex[n];
        for (int i = 0; i < n; ++i) {
            xc[i] = new Complex(x[i], 0.0);
        }
        if (type == TransformType.FORWARD) {
            expected = FastFourierTransformerTest.dft(xc, -1);
            s = normalization == DftNormalization.STANDARD ? 1.0 : 1.0 / FastMath.sqrt((double)n);
        } else {
            expected = FastFourierTransformerTest.dft(xc, 1);
            s = normalization == DftNormalization.STANDARD ? 1.0 / (double)n : 1.0 / FastMath.sqrt((double)n);
        }
        Complex[] actual = fft.transform(x, type);
        for (int i = 0; i < n; ++i) {
            String msg = String.format("%s, %s, %d, %d", normalization, type, n, i);
            double re = s * expected[i].getReal();
            Assert.assertEquals((String)msg, (double)re, (double)actual[i].getReal(), (double)(tol * FastMath.abs((double)re)));
            double im = s * expected[i].getImaginary();
            Assert.assertEquals((String)msg, (double)im, (double)actual[i].getImaginary(), (double)(tol * FastMath.abs((double)re)));
        }
    }

    private static void doTestTransformFunction(UnivariateFunction f, double min, double max, int n, double tol, DftNormalization normalization, TransformType type) {
        double s;
        Complex[] expected;
        FastFourierTransformer fft = new FastFourierTransformer(normalization);
        Complex[] x = new Complex[n];
        for (int i = 0; i < n; ++i) {
            double t = min + (double)i * (max - min) / (double)n;
            x[i] = new Complex(f.value(t));
        }
        if (type == TransformType.FORWARD) {
            expected = FastFourierTransformerTest.dft(x, -1);
            s = normalization == DftNormalization.STANDARD ? 1.0 : 1.0 / FastMath.sqrt((double)n);
        } else {
            expected = FastFourierTransformerTest.dft(x, 1);
            s = normalization == DftNormalization.STANDARD ? 1.0 / (double)n : 1.0 / FastMath.sqrt((double)n);
        }
        Complex[] actual = fft.transform(f, min, max, n, type);
        for (int i = 0; i < n; ++i) {
            String msg = String.format("%d, %d", n, i);
            double re = s * expected[i].getReal();
            Assert.assertEquals((String)msg, (double)re, (double)actual[i].getReal(), (double)(tol * FastMath.abs((double)re)));
            double im = s * expected[i].getImaginary();
            Assert.assertEquals((String)msg, (double)im, (double)actual[i].getImaginary(), (double)(tol * FastMath.abs((double)re)));
        }
    }

    @Test
    public void testTransformComplex() {
        DftNormalization[] norm = DftNormalization.values();
        TransformType[] type = TransformType.values();
        for (int i = 0; i < norm.length; ++i) {
            for (int j = 0; j < type.length; ++j) {
                FastFourierTransformerTest.doTestTransformComplex(2, 1.0E-15, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformComplex(4, 1.0E-14, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformComplex(8, 1.0E-14, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformComplex(16, 1.0E-13, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformComplex(32, 1.0E-13, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformComplex(64, 1.0E-12, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformComplex(128, 1.0E-12, norm[i], type[j]);
            }
        }
    }

    @Test
    public void testStandardTransformReal() {
        DftNormalization[] norm = DftNormalization.values();
        TransformType[] type = TransformType.values();
        for (int i = 0; i < norm.length; ++i) {
            for (int j = 0; j < type.length; ++j) {
                FastFourierTransformerTest.doTestTransformReal(2, 1.0E-15, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformReal(4, 1.0E-14, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformReal(8, 1.0E-14, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformReal(16, 1.0E-13, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformReal(32, 1.0E-13, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformReal(64, 1.0E-13, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformReal(128, 1.0E-11, norm[i], type[j]);
            }
        }
    }

    @Test
    public void testStandardTransformFunction() {
        Sinc f = new Sinc();
        double min = -Math.PI;
        double max = Math.PI;
        DftNormalization[] norm = DftNormalization.values();
        TransformType[] type = TransformType.values();
        for (int i = 0; i < norm.length; ++i) {
            for (int j = 0; j < type.length; ++j) {
                FastFourierTransformerTest.doTestTransformFunction((UnivariateFunction)f, -Math.PI, Math.PI, 2, 1.0E-15, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformFunction((UnivariateFunction)f, -Math.PI, Math.PI, 4, 1.0E-14, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformFunction((UnivariateFunction)f, -Math.PI, Math.PI, 8, 1.0E-14, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformFunction((UnivariateFunction)f, -Math.PI, Math.PI, 16, 1.0E-13, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformFunction((UnivariateFunction)f, -Math.PI, Math.PI, 32, 1.0E-13, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformFunction((UnivariateFunction)f, -Math.PI, Math.PI, 64, 1.0E-12, norm[i], type[j]);
                FastFourierTransformerTest.doTestTransformFunction((UnivariateFunction)f, -Math.PI, Math.PI, 128, 1.0E-11, norm[i], type[j]);
            }
        }
    }

    @Test
    public void testAdHocData() {
        int i;
        int i2;
        FastFourierTransformer transformer = new FastFourierTransformer(DftNormalization.STANDARD);
        double tolerance = 1.0E-12;
        double[] x = new double[]{1.3, 2.4, 1.7, 4.1, 2.9, 1.7, 5.1, 2.7};
        Complex[] y = new Complex[]{new Complex(21.9, 0.0), new Complex(-2.09497474683058, 1.91507575950825), new Complex(-2.6, 2.7), new Complex(-1.10502525316942, -4.88492424049175), new Complex(0.1, 0.0), new Complex(-1.10502525316942, 4.88492424049175), new Complex(-2.6, -2.7), new Complex(-2.09497474683058, -1.91507575950825)};
        Complex[] result = transformer.transform(x, TransformType.FORWARD);
        for (i2 = 0; i2 < result.length; ++i2) {
            Assert.assertEquals((double)y[i2].getReal(), (double)result[i2].getReal(), (double)tolerance);
            Assert.assertEquals((double)y[i2].getImaginary(), (double)result[i2].getImaginary(), (double)tolerance);
        }
        result = transformer.transform(y, TransformType.INVERSE);
        for (i2 = 0; i2 < result.length; ++i2) {
            Assert.assertEquals((double)x[i2], (double)result[i2].getReal(), (double)tolerance);
            Assert.assertEquals((double)0.0, (double)result[i2].getImaginary(), (double)tolerance);
        }
        double[] x2 = new double[]{10.4, 21.6, 40.8, 13.6, 23.2, 32.8, 13.6, 19.2};
        TransformUtils.scaleArray((double[])x2, (double)(1.0 / FastMath.sqrt((double)x2.length)));
        Complex[] y2 = y;
        transformer = new FastFourierTransformer(DftNormalization.UNITARY);
        result = transformer.transform(y2, TransformType.FORWARD);
        for (i = 0; i < result.length; ++i) {
            Assert.assertEquals((double)x2[i], (double)result[i].getReal(), (double)tolerance);
            Assert.assertEquals((double)0.0, (double)result[i].getImaginary(), (double)tolerance);
        }
        result = transformer.transform(x2, TransformType.INVERSE);
        for (i = 0; i < result.length; ++i) {
            Assert.assertEquals((double)y2[i].getReal(), (double)result[i].getReal(), (double)tolerance);
            Assert.assertEquals((double)y2[i].getImaginary(), (double)result[i].getImaginary(), (double)tolerance);
        }
    }

    @Test
    public void testSinFunction() {
        int i;
        Sin f = new Sin();
        FastFourierTransformer transformer = new FastFourierTransformer(DftNormalization.STANDARD);
        int N = 256;
        double tolerance = 1.0E-12;
        double min = 0.0;
        double max = Math.PI * 2;
        Complex[] result = transformer.transform((UnivariateFunction)f, min, max, N, TransformType.FORWARD);
        Assert.assertEquals((double)0.0, (double)result[1].getReal(), (double)tolerance);
        Assert.assertEquals((double)(-(N >> 1)), (double)result[1].getImaginary(), (double)tolerance);
        Assert.assertEquals((double)0.0, (double)result[N - 1].getReal(), (double)tolerance);
        Assert.assertEquals((double)(N >> 1), (double)result[N - 1].getImaginary(), (double)tolerance);
        for (i = 0; i < N - 1; i += i == 0 ? 2 : 1) {
            Assert.assertEquals((double)0.0, (double)result[i].getReal(), (double)tolerance);
            Assert.assertEquals((double)0.0, (double)result[i].getImaginary(), (double)tolerance);
        }
        min = -Math.PI;
        max = Math.PI;
        result = transformer.transform((UnivariateFunction)f, min, max, N, TransformType.INVERSE);
        Assert.assertEquals((double)0.0, (double)result[1].getReal(), (double)tolerance);
        Assert.assertEquals((double)-0.5, (double)result[1].getImaginary(), (double)tolerance);
        Assert.assertEquals((double)0.0, (double)result[N - 1].getReal(), (double)tolerance);
        Assert.assertEquals((double)0.5, (double)result[N - 1].getImaginary(), (double)tolerance);
        for (i = 0; i < N - 1; i += i == 0 ? 2 : 1) {
            Assert.assertEquals((double)0.0, (double)result[i].getReal(), (double)tolerance);
            Assert.assertEquals((double)0.0, (double)result[i].getImaginary(), (double)tolerance);
        }
    }

    @Test
    public void test2DData() {
        FastFourierTransformer transformer = new FastFourierTransformer(DftNormalization.STANDARD);
        double tolerance = 1.0E-12;
        Complex[][] input = new Complex[][]{{new Complex(1.0, 0.0), new Complex(2.0, 0.0)}, {new Complex(3.0, 1.0), new Complex(4.0, 2.0)}};
        Complex[][] goodOutput = new Complex[][]{{new Complex(5.0, 1.5), new Complex(-1.0, -0.5)}, {new Complex(-2.0, -1.5), new Complex(0.0, 0.5)}};
        for (int i = 0; i < goodOutput.length; ++i) {
            TransformUtils.scaleArray((Complex[])goodOutput[i], (double)(FastMath.sqrt((double)goodOutput[i].length) * FastMath.sqrt((double)goodOutput.length)));
        }
        Complex[][] output = (Complex[][])transformer.mdfft((Object)input, TransformType.FORWARD);
        Complex[][] output2 = (Complex[][])transformer.mdfft((Object)output, TransformType.INVERSE);
        Assert.assertEquals((long)input.length, (long)output.length);
        Assert.assertEquals((long)input.length, (long)output2.length);
        Assert.assertEquals((long)input[0].length, (long)output[0].length);
        Assert.assertEquals((long)input[0].length, (long)output2[0].length);
        Assert.assertEquals((long)input[1].length, (long)output[1].length);
        Assert.assertEquals((long)input[1].length, (long)output2[1].length);
        for (int i = 0; i < input.length; ++i) {
            for (int j = 0; j < input[0].length; ++j) {
                Assert.assertEquals((double)input[i][j].getImaginary(), (double)output2[i][j].getImaginary(), (double)tolerance);
                Assert.assertEquals((double)input[i][j].getReal(), (double)output2[i][j].getReal(), (double)tolerance);
                Assert.assertEquals((double)goodOutput[i][j].getImaginary(), (double)output[i][j].getImaginary(), (double)tolerance);
                Assert.assertEquals((double)goodOutput[i][j].getReal(), (double)output[i][j].getReal(), (double)tolerance);
            }
        }
    }

    @Test
    public void test2DDataUnitary() {
        FastFourierTransformer transformer = new FastFourierTransformer(DftNormalization.UNITARY);
        double tolerance = 1.0E-12;
        Complex[][] input = new Complex[][]{{new Complex(1.0, 0.0), new Complex(2.0, 0.0)}, {new Complex(3.0, 1.0), new Complex(4.0, 2.0)}};
        Complex[][] goodOutput = new Complex[][]{{new Complex(5.0, 1.5), new Complex(-1.0, -0.5)}, {new Complex(-2.0, -1.5), new Complex(0.0, 0.5)}};
        Complex[][] output = (Complex[][])transformer.mdfft((Object)input, TransformType.FORWARD);
        Complex[][] output2 = (Complex[][])transformer.mdfft((Object)output, TransformType.INVERSE);
        Assert.assertEquals((long)input.length, (long)output.length);
        Assert.assertEquals((long)input.length, (long)output2.length);
        Assert.assertEquals((long)input[0].length, (long)output[0].length);
        Assert.assertEquals((long)input[0].length, (long)output2[0].length);
        Assert.assertEquals((long)input[1].length, (long)output[1].length);
        Assert.assertEquals((long)input[1].length, (long)output2[1].length);
        for (int i = 0; i < input.length; ++i) {
            for (int j = 0; j < input[0].length; ++j) {
                Assert.assertEquals((double)input[i][j].getImaginary(), (double)output2[i][j].getImaginary(), (double)tolerance);
                Assert.assertEquals((double)input[i][j].getReal(), (double)output2[i][j].getReal(), (double)tolerance);
                Assert.assertEquals((double)goodOutput[i][j].getImaginary(), (double)output[i][j].getImaginary(), (double)tolerance);
                Assert.assertEquals((double)goodOutput[i][j].getReal(), (double)output[i][j].getReal(), (double)tolerance);
            }
        }
    }
}

