/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.MultivariateSummaryStatistics;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.Mean;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class MultivariateSummaryStatisticsTest {
    protected MultivariateSummaryStatistics createMultivariateSummaryStatistics(int k, boolean isCovarianceBiasCorrected) {
        return new MultivariateSummaryStatistics(k, isCovarianceBiasCorrected);
    }

    @Test
    public void testSetterInjection() {
        MultivariateSummaryStatistics u = this.createMultivariateSummaryStatistics(2, true);
        u.setMeanImpl(new StorelessUnivariateStatistic[]{new sumMean(), new sumMean()});
        u.addValue(new double[]{1.0, 2.0});
        u.addValue(new double[]{3.0, 4.0});
        Assert.assertEquals((double)4.0, (double)u.getMean()[0], (double)1.0E-14);
        Assert.assertEquals((double)6.0, (double)u.getMean()[1], (double)1.0E-14);
        u.clear();
        u.addValue(new double[]{1.0, 2.0});
        u.addValue(new double[]{3.0, 4.0});
        Assert.assertEquals((double)4.0, (double)u.getMean()[0], (double)1.0E-14);
        Assert.assertEquals((double)6.0, (double)u.getMean()[1], (double)1.0E-14);
        u.clear();
        u.setMeanImpl(new StorelessUnivariateStatistic[]{new Mean(), new Mean()});
        u.addValue(new double[]{1.0, 2.0});
        u.addValue(new double[]{3.0, 4.0});
        Assert.assertEquals((double)2.0, (double)u.getMean()[0], (double)1.0E-14);
        Assert.assertEquals((double)3.0, (double)u.getMean()[1], (double)1.0E-14);
        Assert.assertEquals((long)2L, (long)u.getDimension());
    }

    @Test
    public void testSetterIllegalState() {
        MultivariateSummaryStatistics u = this.createMultivariateSummaryStatistics(2, true);
        u.addValue(new double[]{1.0, 2.0});
        u.addValue(new double[]{3.0, 4.0});
        try {
            u.setMeanImpl(new StorelessUnivariateStatistic[]{new sumMean(), new sumMean()});
            Assert.fail((String)"Expecting IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testToString() {
        MultivariateSummaryStatistics stats = this.createMultivariateSummaryStatistics(2, true);
        stats.addValue(new double[]{1.0, 3.0});
        stats.addValue(new double[]{2.0, 2.0});
        stats.addValue(new double[]{3.0, 1.0});
        Locale d = Locale.getDefault();
        Locale.setDefault(Locale.US);
        String suffix = System.getProperty("line.separator");
        Assert.assertEquals((Object)("MultivariateSummaryStatistics:" + suffix + "n: 3" + suffix + "min: 1.0, 1.0" + suffix + "max: 3.0, 3.0" + suffix + "mean: 2.0, 2.0" + suffix + "geometric mean: 1.817..., 1.817..." + suffix + "sum of squares: 14.0, 14.0" + suffix + "sum of logarithms: 1.791..., 1.791..." + suffix + "standard deviation: 1.0, 1.0" + suffix + "covariance: Array2DRowRealMatrix{{1.0,-1.0},{-1.0,1.0}}" + suffix), (Object)stats.toString().replaceAll("([0-9]+\\.[0-9][0-9][0-9])[0-9]+", "$1..."));
        Locale.setDefault(d);
    }

    @Test
    public void testShuffledStatistics() {
        MultivariateSummaryStatistics reference = this.createMultivariateSummaryStatistics(2, true);
        MultivariateSummaryStatistics shuffled = this.createMultivariateSummaryStatistics(2, true);
        StorelessUnivariateStatistic[] tmp = shuffled.getGeoMeanImpl();
        shuffled.setGeoMeanImpl(shuffled.getMeanImpl());
        shuffled.setMeanImpl(shuffled.getMaxImpl());
        shuffled.setMaxImpl(shuffled.getMinImpl());
        shuffled.setMinImpl(shuffled.getSumImpl());
        shuffled.setSumImpl(shuffled.getSumsqImpl());
        shuffled.setSumsqImpl(shuffled.getSumLogImpl());
        shuffled.setSumLogImpl(tmp);
        for (int i = 100; i > 0; --i) {
            reference.addValue(new double[]{i, i});
            shuffled.addValue(new double[]{i, i});
        }
        TestUtils.assertEquals(reference.getMean(), shuffled.getGeometricMean(), 1.0E-10);
        TestUtils.assertEquals(reference.getMax(), shuffled.getMean(), 1.0E-10);
        TestUtils.assertEquals(reference.getMin(), shuffled.getMax(), 1.0E-10);
        TestUtils.assertEquals(reference.getSum(), shuffled.getMin(), 1.0E-10);
        TestUtils.assertEquals(reference.getSumSq(), shuffled.getSum(), 1.0E-10);
        TestUtils.assertEquals(reference.getSumLog(), shuffled.getSumSq(), 1.0E-10);
        TestUtils.assertEquals(reference.getGeometricMean(), shuffled.getSumLog(), 1.0E-10);
    }

    @Test
    public void testDimension() {
        try {
            this.createMultivariateSummaryStatistics(2, true).addValue(new double[3]);
            Assert.fail((String)"Expecting DimensionMismatchException");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testStats() {
        MultivariateSummaryStatistics u = this.createMultivariateSummaryStatistics(2, true);
        Assert.assertEquals((long)0L, (long)u.getN());
        u.addValue(new double[]{1.0, 2.0});
        u.addValue(new double[]{2.0, 3.0});
        u.addValue(new double[]{2.0, 3.0});
        u.addValue(new double[]{3.0, 4.0});
        Assert.assertEquals((long)4L, (long)u.getN());
        Assert.assertEquals((double)8.0, (double)u.getSum()[0], (double)1.0E-10);
        Assert.assertEquals((double)12.0, (double)u.getSum()[1], (double)1.0E-10);
        Assert.assertEquals((double)18.0, (double)u.getSumSq()[0], (double)1.0E-10);
        Assert.assertEquals((double)38.0, (double)u.getSumSq()[1], (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)u.getMin()[0], (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)u.getMin()[1], (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)u.getMax()[0], (double)1.0E-10);
        Assert.assertEquals((double)4.0, (double)u.getMax()[1], (double)1.0E-10);
        Assert.assertEquals((double)2.4849066497880004, (double)u.getSumLog()[0], (double)1.0E-10);
        Assert.assertEquals((double)4.276666119016055, (double)u.getSumLog()[1], (double)1.0E-10);
        Assert.assertEquals((double)1.8612097182041991, (double)u.getGeometricMean()[0], (double)1.0E-10);
        Assert.assertEquals((double)2.9129506302439405, (double)u.getGeometricMean()[1], (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)u.getMean()[0], (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)u.getMean()[1], (double)1.0E-10);
        Assert.assertEquals((double)FastMath.sqrt((double)0.6666666666666666), (double)u.getStandardDeviation()[0], (double)1.0E-10);
        Assert.assertEquals((double)FastMath.sqrt((double)0.6666666666666666), (double)u.getStandardDeviation()[1], (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)u.getCovariance().getEntry(0, 0), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)u.getCovariance().getEntry(0, 1), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)u.getCovariance().getEntry(1, 0), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)u.getCovariance().getEntry(1, 1), (double)1.0E-10);
        u.clear();
        Assert.assertEquals((long)0L, (long)u.getN());
    }

    @Test
    public void testN0andN1Conditions() {
        MultivariateSummaryStatistics u = this.createMultivariateSummaryStatistics(1, true);
        Assert.assertTrue((boolean)Double.isNaN(u.getMean()[0]));
        Assert.assertTrue((boolean)Double.isNaN(u.getStandardDeviation()[0]));
        u.addValue(new double[]{1.0});
        Assert.assertEquals((double)1.0, (double)u.getMean()[0], (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)u.getGeometricMean()[0], (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)u.getStandardDeviation()[0], (double)1.0E-10);
        u.addValue(new double[]{2.0});
        Assert.assertTrue((u.getStandardDeviation()[0] > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNaNContracts() {
        MultivariateSummaryStatistics u = this.createMultivariateSummaryStatistics(1, true);
        Assert.assertTrue((boolean)Double.isNaN(u.getMean()[0]));
        Assert.assertTrue((boolean)Double.isNaN(u.getMin()[0]));
        Assert.assertTrue((boolean)Double.isNaN(u.getStandardDeviation()[0]));
        Assert.assertTrue((boolean)Double.isNaN(u.getGeometricMean()[0]));
        u.addValue(new double[]{1.0});
        Assert.assertFalse((boolean)Double.isNaN(u.getMean()[0]));
        Assert.assertFalse((boolean)Double.isNaN(u.getMin()[0]));
        Assert.assertFalse((boolean)Double.isNaN(u.getStandardDeviation()[0]));
        Assert.assertFalse((boolean)Double.isNaN(u.getGeometricMean()[0]));
    }

    @Test
    public void testSerialization() {
        MultivariateSummaryStatistics u = this.createMultivariateSummaryStatistics(2, true);
        TestUtils.checkSerializedEquality(u);
        MultivariateSummaryStatistics s = (MultivariateSummaryStatistics)TestUtils.serializeAndRecover(u);
        Assert.assertEquals((Object)u, (Object)s);
        u.addValue(new double[]{2.0, 1.0});
        u.addValue(new double[]{1.0, 1.0});
        u.addValue(new double[]{3.0, 1.0});
        u.addValue(new double[]{4.0, 1.0});
        u.addValue(new double[]{5.0, 1.0});
        TestUtils.checkSerializedEquality(u);
        s = (MultivariateSummaryStatistics)TestUtils.serializeAndRecover(u);
        Assert.assertEquals((Object)u, (Object)s);
    }

    @Test
    public void testEqualsAndHashCode() {
        MultivariateSummaryStatistics u = this.createMultivariateSummaryStatistics(2, true);
        MultivariateSummaryStatistics t = null;
        int emptyHash = u.hashCode();
        Assert.assertTrue((boolean)u.equals((Object)u));
        Assert.assertFalse((boolean)u.equals(t));
        Assert.assertFalse((boolean)u.equals((Object)0.0));
        t = this.createMultivariateSummaryStatistics(2, true);
        Assert.assertTrue((boolean)t.equals((Object)u));
        Assert.assertTrue((boolean)u.equals((Object)t));
        Assert.assertEquals((long)emptyHash, (long)t.hashCode());
        u.addValue(new double[]{2.0, 1.0});
        u.addValue(new double[]{1.0, 1.0});
        u.addValue(new double[]{3.0, 1.0});
        u.addValue(new double[]{4.0, 1.0});
        u.addValue(new double[]{5.0, 1.0});
        Assert.assertFalse((boolean)t.equals((Object)u));
        Assert.assertFalse((boolean)u.equals((Object)t));
        Assert.assertTrue((u.hashCode() != t.hashCode() ? 1 : 0) != 0);
        t.addValue(new double[]{2.0, 1.0});
        t.addValue(new double[]{1.0, 1.0});
        t.addValue(new double[]{3.0, 1.0});
        t.addValue(new double[]{4.0, 1.0});
        t.addValue(new double[]{5.0, 1.0});
        Assert.assertTrue((boolean)t.equals((Object)u));
        Assert.assertTrue((boolean)u.equals((Object)t));
        Assert.assertEquals((long)u.hashCode(), (long)t.hashCode());
        u.clear();
        t.clear();
        Assert.assertTrue((boolean)t.equals((Object)u));
        Assert.assertTrue((boolean)u.equals((Object)t));
        Assert.assertEquals((long)emptyHash, (long)t.hashCode());
        Assert.assertEquals((long)emptyHash, (long)u.hashCode());
    }

    static class sumMean
    implements StorelessUnivariateStatistic {
        private double sum = 0.0;
        private long n = 0L;

        sumMean() {
        }

        public double evaluate(double[] values, int begin, int length) {
            return 0.0;
        }

        public double evaluate(double[] values) {
            return 0.0;
        }

        public void clear() {
            this.sum = 0.0;
            this.n = 0L;
        }

        public long getN() {
            return this.n;
        }

        public double getResult() {
            return this.sum;
        }

        public void increment(double d) {
            this.sum += d;
            ++this.n;
        }

        public void incrementAll(double[] values, int start, int length) {
        }

        public void incrementAll(double[] values) {
        }

        public StorelessUnivariateStatistic copy() {
            return new sumMean();
        }
    }
}

