/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.stat.Frequency;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class FrequencyTest {
    private static final long ONE_LONG = 1L;
    private static final long TWO_LONG = 2L;
    private static final long THREE_LONG = 3L;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final double TOLERANCE = 1.0E-14;
    private static final char CHAR_A = 'a';
    private Frequency f = null;

    @Before
    public void setUp() {
        this.f = new Frequency();
    }

    @Test
    public void testCounts() {
        Assert.assertEquals((String)"total count", (long)0L, (long)this.f.getSumFreq());
        this.f.addValue(1L);
        this.f.addValue(2L);
        this.f.addValue(1);
        this.f.addValue(1);
        Assert.assertEquals((String)"one frequency count", (long)3L, (long)this.f.getCount(1));
        Assert.assertEquals((String)"two frequency count", (long)1L, (long)this.f.getCount(2));
        Assert.assertEquals((String)"three frequency count", (long)0L, (long)this.f.getCount(3));
        Assert.assertEquals((String)"total count", (long)4L, (long)this.f.getSumFreq());
        Assert.assertEquals((String)"zero cumulative frequency", (long)0L, (long)this.f.getCumFreq(0));
        Assert.assertEquals((String)"one cumulative frequency", (long)3L, (long)this.f.getCumFreq(1));
        Assert.assertEquals((String)"two cumulative frequency", (long)4L, (long)this.f.getCumFreq(2));
        Assert.assertEquals((String)"Integer argument cum freq", (long)4L, (long)this.f.getCumFreq((Comparable)Integer.valueOf(2)));
        Assert.assertEquals((String)"five cumulative frequency", (long)4L, (long)this.f.getCumFreq(5));
        Assert.assertEquals((String)"foo cumulative frequency", (long)0L, (long)this.f.getCumFreq((Comparable)((Object)"foo")));
        this.f.clear();
        Assert.assertEquals((String)"total count", (long)0L, (long)this.f.getSumFreq());
        this.f.addValue((Comparable)((Object)"one"));
        this.f.addValue((Comparable)((Object)"One"));
        this.f.addValue((Comparable)((Object)"oNe"));
        this.f.addValue((Comparable)((Object)"Z"));
        Assert.assertEquals((String)"one cumulative frequency", (long)1L, (long)this.f.getCount((Comparable)((Object)"one")));
        Assert.assertEquals((String)"Z cumulative pct", (double)0.5, (double)this.f.getCumPct((Comparable)((Object)"Z")), (double)1.0E-14);
        Assert.assertEquals((String)"z cumulative pct", (double)1.0, (double)this.f.getCumPct((Comparable)((Object)"z")), (double)1.0E-14);
        Assert.assertEquals((String)"Ot cumulative pct", (double)0.25, (double)this.f.getCumPct((Comparable)((Object)"Ot")), (double)1.0E-14);
        this.f.clear();
        this.f = null;
        Frequency f = new Frequency();
        f.addValue(1);
        f.addValue((Comparable)Integer.valueOf(1));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue(2);
        f.addValue((Comparable)Integer.valueOf(-1));
        Assert.assertEquals((String)"1 count", (long)3L, (long)f.getCount(1));
        Assert.assertEquals((String)"1 count", (long)3L, (long)f.getCount((Comparable)Integer.valueOf(1)));
        Assert.assertEquals((String)"0 cum pct", (double)0.2, (double)f.getCumPct(0), (double)1.0E-14);
        Assert.assertEquals((String)"1 pct", (double)0.6, (double)f.getPct((Comparable)Integer.valueOf(1)), (double)1.0E-14);
        Assert.assertEquals((String)"-2 cum pct", (double)0.0, (double)f.getCumPct(-2), (double)1.0E-14);
        Assert.assertEquals((String)"10 cum pct", (double)1.0, (double)f.getCumPct(10), (double)1.0E-14);
        f = null;
        f = new Frequency(String.CASE_INSENSITIVE_ORDER);
        f.addValue((Comparable)((Object)"one"));
        f.addValue((Comparable)((Object)"One"));
        f.addValue((Comparable)((Object)"oNe"));
        f.addValue((Comparable)((Object)"Z"));
        Assert.assertEquals((String)"one count", (long)3L, (long)f.getCount((Comparable)((Object)"one")));
        Assert.assertEquals((String)"Z cumulative pct -- case insensitive", (double)1.0, (double)f.getCumPct((Comparable)((Object)"Z")), (double)1.0E-14);
        Assert.assertEquals((String)"z cumulative pct -- case insensitive", (double)1.0, (double)f.getCumPct((Comparable)((Object)"z")), (double)1.0E-14);
        f = null;
        f = new Frequency();
        Assert.assertEquals((long)0L, (long)f.getCount('a'));
        Assert.assertEquals((long)0L, (long)f.getCumFreq('b'));
        TestUtils.assertEquals(Double.NaN, f.getPct('a'), 0.0);
        TestUtils.assertEquals(Double.NaN, f.getCumPct('b'), 0.0);
        f.addValue('a');
        f.addValue('b');
        f.addValue('c');
        f.addValue('d');
        Assert.assertEquals((long)1L, (long)f.getCount('a'));
        Assert.assertEquals((long)2L, (long)f.getCumFreq('b'));
        Assert.assertEquals((double)0.25, (double)f.getPct('a'), (double)0.0);
        Assert.assertEquals((double)0.5, (double)f.getCumPct('b'), (double)0.0);
        Assert.assertEquals((double)1.0, (double)f.getCumPct('e'), (double)0.0);
    }

    @Test
    public void testPcts() {
        this.f.addValue(1L);
        this.f.addValue(2L);
        this.f.addValue(1);
        this.f.addValue(2);
        this.f.addValue(3L);
        this.f.addValue(3L);
        this.f.addValue(3);
        this.f.addValue(3);
        Assert.assertEquals((String)"one pct", (double)0.25, (double)this.f.getPct(1), (double)1.0E-14);
        Assert.assertEquals((String)"two pct", (double)0.25, (double)this.f.getPct((Comparable)Long.valueOf(2L)), (double)1.0E-14);
        Assert.assertEquals((String)"three pct", (double)0.5, (double)this.f.getPct(3L), (double)1.0E-14);
        Assert.assertEquals((String)"five pct", (double)0.0, (double)this.f.getPct(5), (double)1.0E-14);
        Assert.assertEquals((String)"foo pct", (double)0.0, (double)this.f.getPct((Comparable)((Object)"foo")), (double)1.0E-14);
        Assert.assertEquals((String)"one cum pct", (double)0.25, (double)this.f.getCumPct(1), (double)1.0E-14);
        Assert.assertEquals((String)"two cum pct", (double)0.5, (double)this.f.getCumPct((Comparable)Long.valueOf(2L)), (double)1.0E-14);
        Assert.assertEquals((String)"Integer argument", (double)0.5, (double)this.f.getCumPct((Comparable)Integer.valueOf(2)), (double)1.0E-14);
        Assert.assertEquals((String)"three cum pct", (double)1.0, (double)this.f.getCumPct(3L), (double)1.0E-14);
        Assert.assertEquals((String)"five cum pct", (double)1.0, (double)this.f.getCumPct(5), (double)1.0E-14);
        Assert.assertEquals((String)"zero cum pct", (double)0.0, (double)this.f.getCumPct(0), (double)1.0E-14);
        Assert.assertEquals((String)"foo cum pct", (double)0.0, (double)this.f.getCumPct((Comparable)((Object)"foo")), (double)1.0E-14);
    }

    @Test
    public void testAdd() {
        char aChar = 'a';
        char bChar = 'b';
        String aString = "a";
        this.f.addValue(aChar);
        this.f.addValue(bChar);
        try {
            this.f.addValue((Comparable)((Object)aString));
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.f.addValue(2);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"a pct", (double)0.5, (double)this.f.getPct(aChar), (double)1.0E-14);
        Assert.assertEquals((String)"b cum pct", (double)1.0, (double)this.f.getCumPct(bChar), (double)1.0E-14);
        Assert.assertEquals((String)"a string pct", (double)0.0, (double)this.f.getPct((Comparable)((Object)aString)), (double)1.0E-14);
        Assert.assertEquals((String)"a string cum pct", (double)0.0, (double)this.f.getCumPct((Comparable)((Object)aString)), (double)1.0E-14);
        this.f = new Frequency();
        this.f.addValue((Comparable)((Object)"One"));
        try {
            this.f.addValue((Comparable)new Integer("One"));
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyTable() {
        Assert.assertEquals((String)"freq sum, empty table", (long)0L, (long)this.f.getSumFreq());
        Assert.assertEquals((String)"count, empty table", (long)0L, (long)this.f.getCount(0));
        Assert.assertEquals((String)"count, empty table", (long)0L, (long)this.f.getCount((Comparable)Integer.valueOf(0)));
        Assert.assertEquals((String)"cum freq, empty table", (long)0L, (long)this.f.getCumFreq(0));
        Assert.assertEquals((String)"cum freq, empty table", (long)0L, (long)this.f.getCumFreq((Comparable)((Object)"x")));
        Assert.assertTrue((String)"pct, empty table", (boolean)Double.isNaN(this.f.getPct(0)));
        Assert.assertTrue((String)"pct, empty table", (boolean)Double.isNaN(this.f.getPct((Comparable)Integer.valueOf(0))));
        Assert.assertTrue((String)"cum pct, empty table", (boolean)Double.isNaN(this.f.getCumPct(0)));
        Assert.assertTrue((String)"cum pct, empty table", (boolean)Double.isNaN(this.f.getCumPct((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void testNonComparableCumPct() {
        this.f.addValue((Comparable)((Object)"a"));
        Assert.assertEquals((String)"cum freq, single entry", (double)1.0, (double)this.f.getCumPct((Comparable)((Object)"a")), (double)1.0E-14);
        Assert.assertEquals((String)"cum freq, single entry non comparable", (double)0.0, (double)this.f.getCumPct(100), (double)1.0E-14);
    }

    @Test
    public void testNonComparablePct() {
        this.f.addValue((Comparable)((Object)"a"));
        Assert.assertEquals((String)"cum freq, single entry", (double)1.0, (double)this.f.getPct((Comparable)((Object)"a")), (double)1.0E-14);
        Assert.assertEquals((String)"cum freq, single entry non comparable", (double)0.0, (double)this.f.getPct(100), (double)1.0E-14);
    }

    @Test
    public void testToString() throws Exception {
        this.f.addValue(1L);
        this.f.addValue(2L);
        this.f.addValue(1);
        this.f.addValue(2);
        String s = this.f.toString();
        Assert.assertNotNull((Object)s);
        BufferedReader reader = new BufferedReader(new StringReader(s));
        String line = reader.readLine();
        Assert.assertNotNull((Object)line);
        line = reader.readLine();
        Assert.assertNotNull((Object)line);
        line = reader.readLine();
        Assert.assertNotNull((Object)line);
        line = reader.readLine();
        Assert.assertNull((Object)line);
    }

    @Test
    public void testIntegerValues() {
        Integer obj1 = null;
        obj1 = 1;
        Integer int1 = 1;
        this.f.addValue((Comparable)obj1);
        this.f.addValue((Comparable)int1);
        this.f.addValue(2);
        this.f.addValue((Comparable)Long.valueOf(2L));
        Assert.assertEquals((String)"Integer 1 count", (long)2L, (long)this.f.getCount(1));
        Assert.assertEquals((String)"Integer 1 count", (long)2L, (long)this.f.getCount((Comparable)Integer.valueOf(1)));
        Assert.assertEquals((String)"Integer 1 count", (long)2L, (long)this.f.getCount((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((String)"Integer 1 cumPct", (double)0.5, (double)this.f.getCumPct(1), (double)1.0E-14);
        Assert.assertEquals((String)"Integer 1 cumPct", (double)0.5, (double)this.f.getCumPct((Comparable)Long.valueOf(1L)), (double)1.0E-14);
        Assert.assertEquals((String)"Integer 1 cumPct", (double)0.5, (double)this.f.getCumPct((Comparable)Integer.valueOf(1)), (double)1.0E-14);
        this.f.incrementValue(1, -2L);
        this.f.incrementValue(3, 5L);
        Assert.assertEquals((String)"Integer 1 count", (long)0L, (long)this.f.getCount(1));
        Assert.assertEquals((String)"Integer 3 count", (long)5L, (long)this.f.getCount(3));
        Iterator it = this.f.valuesIterator();
        while (it.hasNext()) {
            Assert.assertTrue((boolean)(it.next() instanceof Long));
        }
    }

    @Test
    public void testSerial() {
        this.f.addValue(1L);
        this.f.addValue(2L);
        this.f.addValue(1);
        this.f.addValue(2);
        Assert.assertEquals((Object)this.f, (Object)TestUtils.serializeAndRecover(this.f));
    }

    @Test
    public void testGetUniqueCount() {
        Assert.assertEquals((long)0L, (long)this.f.getUniqueCount());
        this.f.addValue(1L);
        Assert.assertEquals((long)1L, (long)this.f.getUniqueCount());
        this.f.addValue(1L);
        Assert.assertEquals((long)1L, (long)this.f.getUniqueCount());
        this.f.addValue(2);
        Assert.assertEquals((long)2L, (long)this.f.getUniqueCount());
    }

    @Test
    public void testIncrement() {
        Assert.assertEquals((long)0L, (long)this.f.getUniqueCount());
        this.f.incrementValue(1L, 1L);
        Assert.assertEquals((long)1L, (long)this.f.getCount(1L));
        this.f.incrementValue(1L, 4L);
        Assert.assertEquals((long)5L, (long)this.f.getCount(1L));
        this.f.incrementValue(1L, -5L);
        Assert.assertEquals((long)0L, (long)this.f.getCount(1L));
        try {
            this.f.incrementValue('a', 1L);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.f = new Frequency();
        this.f.incrementValue('a', 2L);
        Assert.assertEquals((long)2L, (long)this.f.getCount('a'));
        try {
            this.f.incrementValue(1, 1L);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.f.incrementValue('a', 3L);
        Assert.assertEquals((long)5L, (long)this.f.getCount('a'));
    }

    @Test
    public void testMerge() {
        Assert.assertEquals((long)0L, (long)this.f.getUniqueCount());
        this.f.addValue(1L);
        this.f.addValue(2L);
        this.f.addValue(1);
        this.f.addValue(2);
        Assert.assertEquals((long)2L, (long)this.f.getUniqueCount());
        Assert.assertEquals((long)2L, (long)this.f.getCount(1));
        Assert.assertEquals((long)2L, (long)this.f.getCount(2));
        Frequency g = new Frequency();
        g.addValue(1L);
        g.addValue(3L);
        g.addValue(3);
        Assert.assertEquals((long)2L, (long)g.getUniqueCount());
        Assert.assertEquals((long)1L, (long)g.getCount(1));
        Assert.assertEquals((long)2L, (long)g.getCount(3));
        this.f.merge(g);
        Assert.assertEquals((long)3L, (long)this.f.getUniqueCount());
        Assert.assertEquals((long)3L, (long)this.f.getCount(1));
        Assert.assertEquals((long)2L, (long)this.f.getCount(2));
        Assert.assertEquals((long)2L, (long)this.f.getCount(3));
    }

    @Test
    public void testMergeCollection() {
        Assert.assertEquals((long)0L, (long)this.f.getUniqueCount());
        this.f.addValue(1L);
        Assert.assertEquals((long)1L, (long)this.f.getUniqueCount());
        Assert.assertEquals((long)1L, (long)this.f.getCount(1));
        Assert.assertEquals((long)0L, (long)this.f.getCount(2));
        Frequency g = new Frequency();
        g.addValue(2L);
        Frequency h = new Frequency();
        h.addValue(3L);
        ArrayList<Frequency> coll = new ArrayList<Frequency>();
        coll.add(g);
        coll.add(h);
        this.f.merge(coll);
        Assert.assertEquals((long)3L, (long)this.f.getUniqueCount());
        Assert.assertEquals((long)1L, (long)this.f.getCount(1));
        Assert.assertEquals((long)1L, (long)this.f.getCount(2));
        Assert.assertEquals((long)1L, (long)this.f.getCount(3));
    }

    @Test
    public void testMode() {
        List mode = this.f.getMode();
        Assert.assertEquals((long)0L, (long)mode.size());
        this.f.addValue((Comparable)((Object)"3"));
        mode = this.f.getMode();
        Assert.assertEquals((long)1L, (long)mode.size());
        Assert.assertEquals((Object)"3", mode.get(0));
        this.f.addValue((Comparable)((Object)"2"));
        mode = this.f.getMode();
        Assert.assertEquals((long)2L, (long)mode.size());
        Assert.assertEquals((Object)"2", mode.get(0));
        Assert.assertEquals((Object)"3", mode.get(1));
        this.f.addValue((Comparable)((Object)"2"));
        mode = this.f.getMode();
        Assert.assertEquals((long)1L, (long)mode.size());
        Assert.assertEquals((Object)"2", mode.get(0));
        Assert.assertFalse((boolean)mode.contains("1"));
        Assert.assertTrue((boolean)mode.contains("2"));
        try {
            this.f.addValue((Comparable)Double.valueOf(Double.NaN));
            Assert.fail((String)"Expected MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testModeDoubleNan() {
        this.f.addValue((Comparable)Double.valueOf(Double.NaN));
        this.f.addValue((Comparable)Double.valueOf(Double.NaN));
        this.f.addValue((Comparable)Double.valueOf(Double.NaN));
        this.f.addValue((Comparable)Double.valueOf(Double.NEGATIVE_INFINITY));
        this.f.addValue((Comparable)Double.valueOf(Double.POSITIVE_INFINITY));
        this.f.addValue((Comparable)Double.valueOf(Double.NEGATIVE_INFINITY));
        this.f.addValue((Comparable)Double.valueOf(Double.POSITIVE_INFINITY));
        this.f.addValue((Comparable)Double.valueOf(Double.NEGATIVE_INFINITY));
        this.f.addValue((Comparable)Double.valueOf(Double.POSITIVE_INFINITY));
        List mode = this.f.getMode();
        Assert.assertEquals((long)3L, (long)mode.size());
        Assert.assertEquals((Object)Double.NEGATIVE_INFINITY, mode.get(0));
        Assert.assertEquals((Object)Double.POSITIVE_INFINITY, mode.get(1));
        Assert.assertEquals((Object)Double.NaN, mode.get(2));
        try {
            this.f.addValue((Comparable)Float.valueOf(Float.NaN));
            Assert.fail((String)"Expected MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testModeFloatNan() {
        this.f.addValue((Comparable)Float.valueOf(Float.NaN));
        this.f.addValue((Comparable)Float.valueOf(Float.NaN));
        this.f.addValue((Comparable)Float.valueOf(Float.NaN));
        this.f.addValue((Comparable)Float.valueOf(Float.NEGATIVE_INFINITY));
        this.f.addValue((Comparable)Float.valueOf(Float.POSITIVE_INFINITY));
        this.f.addValue((Comparable)Float.valueOf(Float.NEGATIVE_INFINITY));
        this.f.addValue((Comparable)Float.valueOf(Float.POSITIVE_INFINITY));
        this.f.addValue((Comparable)Float.valueOf(Float.NEGATIVE_INFINITY));
        this.f.addValue((Comparable)Float.valueOf(Float.POSITIVE_INFINITY));
        List mode = this.f.getMode();
        Assert.assertEquals((long)3L, (long)mode.size());
        Assert.assertEquals((Object)Float.valueOf(Float.NEGATIVE_INFINITY), mode.get(0));
        Assert.assertEquals((Object)Float.valueOf(Float.POSITIVE_INFINITY), mode.get(1));
        Assert.assertEquals((Object)Float.valueOf(Float.NaN), mode.get(2));
        try {
            this.f.addValue((Comparable)Double.valueOf(Double.NaN));
            Assert.fail((String)"Expected MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }
}

