/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optimization.direct;

import com.hazelcast.shaded.org.apache.commons.math3.Retry;
import com.hazelcast.shaded.org.apache.commons.math3.RetryRunner;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.GoalType;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.InitialGuess;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.OptimizationData;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.PointValuePair;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.SimpleBounds;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.direct.CMAESOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.random.MersenneTwister;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@Deprecated
@RunWith(value=RetryRunner.class)
public class CMAESOptimizerTest {
    static final int DIM = 13;
    static final int LAMBDA = 4 + (int)(3.0 * FastMath.log((double)13.0));

    @Test(expected=NumberIsTooLargeException.class)
    public void testInitOutofbounds1() {
        double[] startPoint = CMAESOptimizerTest.point(13, 3.0);
        double[] insigma = CMAESOptimizerTest.point(13, 0.3);
        double[][] boundaries = CMAESOptimizerTest.boundaries(13, -1.0, 2.0);
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 1.0), 0.0);
        this.doTest(new Rosen(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testInitOutofbounds2() {
        double[] startPoint = CMAESOptimizerTest.point(13, -2.0);
        double[] insigma = CMAESOptimizerTest.point(13, 0.3);
        double[][] boundaries = CMAESOptimizerTest.boundaries(13, -1.0, 2.0);
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 1.0), 0.0);
        this.doTest(new Rosen(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testBoundariesDimensionMismatch() {
        double[] startPoint = CMAESOptimizerTest.point(13, 0.5);
        double[] insigma = CMAESOptimizerTest.point(13, 0.3);
        double[][] boundaries = CMAESOptimizerTest.boundaries(14, -1.0, 2.0);
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 1.0), 0.0);
        this.doTest(new Rosen(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
    }

    @Test(expected=NotPositiveException.class)
    public void testInputSigmaNegative() {
        double[] startPoint = CMAESOptimizerTest.point(13, 0.5);
        double[] insigma = CMAESOptimizerTest.point(13, -0.5);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 1.0), 0.0);
        this.doTest(new Rosen(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
    }

    @Test(expected=OutOfRangeException.class)
    public void testInputSigmaOutOfRange() {
        double[] startPoint = CMAESOptimizerTest.point(13, 0.5);
        double[] insigma = CMAESOptimizerTest.point(13, 1.1);
        double[][] boundaries = CMAESOptimizerTest.boundaries(13, -0.5, 0.5);
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 1.0), 0.0);
        this.doTest(new Rosen(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testInputSigmaDimensionMismatch() {
        double[] startPoint = CMAESOptimizerTest.point(13, 0.5);
        double[] insigma = CMAESOptimizerTest.point(14, 0.5);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 1.0), 0.0);
        this.doTest(new Rosen(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
    }

    @Test
    @Retry(value=3)
    public void testRosen() {
        double[] startPoint = CMAESOptimizerTest.point(13, 0.1);
        double[] insigma = CMAESOptimizerTest.point(13, 0.1);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 1.0), 0.0);
        this.doTest(new Rosen(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
        this.doTest(new Rosen(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, false, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
    }

    @Test
    @Retry(value=3)
    public void testMaximize() {
        double[] startPoint = CMAESOptimizerTest.point(13, 1.0);
        double[] insigma = CMAESOptimizerTest.point(13, 0.1);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 0.0), 1.0);
        this.doTest(new MinusElli(), startPoint, insigma, boundaries, GoalType.MAXIMIZE, LAMBDA, true, 0, 0.9999999999999, 2.0E-10, 5.0E-6, 100000, expected);
        this.doTest(new MinusElli(), startPoint, insigma, boundaries, GoalType.MAXIMIZE, LAMBDA, false, 0, 0.9999999999999, 2.0E-10, 5.0E-6, 100000, expected);
        boundaries = CMAESOptimizerTest.boundaries(13, -0.3, 0.3);
        startPoint = CMAESOptimizerTest.point(13, 0.1);
        this.doTest(new MinusElli(), startPoint, insigma, boundaries, GoalType.MAXIMIZE, LAMBDA, true, 0, 0.9999999999999, 2.0E-10, 5.0E-6, 100000, expected);
    }

    @Test
    public void testEllipse() {
        double[] startPoint = CMAESOptimizerTest.point(13, 1.0);
        double[] insigma = CMAESOptimizerTest.point(13, 0.1);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 0.0), 0.0);
        this.doTest(new Elli(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
        this.doTest(new Elli(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, false, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
    }

    @Test
    public void testElliRotated() {
        double[] startPoint = CMAESOptimizerTest.point(13, 1.0);
        double[] insigma = CMAESOptimizerTest.point(13, 0.1);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 0.0), 0.0);
        this.doTest(new ElliRotated(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
        this.doTest(new ElliRotated(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, false, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
    }

    @Test
    public void testCigar() {
        double[] startPoint = CMAESOptimizerTest.point(13, 1.0);
        double[] insigma = CMAESOptimizerTest.point(13, 0.1);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 0.0), 0.0);
        this.doTest(new Cigar(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 200000, expected);
        this.doTest(new Cigar(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, false, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
    }

    @Test
    public void testCigarWithBoundaries() {
        double[] startPoint = CMAESOptimizerTest.point(13, 1.0);
        double[] insigma = CMAESOptimizerTest.point(13, 0.1);
        double[][] boundaries = CMAESOptimizerTest.boundaries(13, -1.0E100, Double.POSITIVE_INFINITY);
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 0.0), 0.0);
        this.doTest(new Cigar(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 200000, expected);
        this.doTest(new Cigar(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, false, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
    }

    @Test
    public void testTwoAxes() {
        double[] startPoint = CMAESOptimizerTest.point(13, 1.0);
        double[] insigma = CMAESOptimizerTest.point(13, 0.1);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 0.0), 0.0);
        this.doTest(new TwoAxes(), startPoint, insigma, boundaries, GoalType.MINIMIZE, 2 * LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 200000, expected);
        this.doTest(new TwoAxes(), startPoint, insigma, boundaries, GoalType.MINIMIZE, 2 * LAMBDA, false, 0, 1.0E-13, 1.0E-8, 0.001, 200000, expected);
    }

    @Test
    public void testCigTab() {
        double[] startPoint = CMAESOptimizerTest.point(13, 1.0);
        double[] insigma = CMAESOptimizerTest.point(13, 0.3);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 0.0), 0.0);
        this.doTest(new CigTab(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, true, 0, 1.0E-13, 1.0E-13, 5.0E-5, 100000, expected);
        this.doTest(new CigTab(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, false, 0, 1.0E-13, 1.0E-13, 5.0E-5, 100000, expected);
    }

    @Test
    public void testSphere() {
        double[] startPoint = CMAESOptimizerTest.point(13, 1.0);
        double[] insigma = CMAESOptimizerTest.point(13, 0.1);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 0.0), 0.0);
        this.doTest(new Sphere(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
        this.doTest(new Sphere(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, false, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
    }

    @Test
    public void testTablet() {
        double[] startPoint = CMAESOptimizerTest.point(13, 1.0);
        double[] insigma = CMAESOptimizerTest.point(13, 0.1);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 0.0), 0.0);
        this.doTest(new Tablet(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
        this.doTest(new Tablet(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, false, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
    }

    @Test
    public void testDiffPow() {
        double[] startPoint = CMAESOptimizerTest.point(13, 1.0);
        double[] insigma = CMAESOptimizerTest.point(13, 0.1);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 0.0), 0.0);
        this.doTest(new DiffPow(), startPoint, insigma, boundaries, GoalType.MINIMIZE, 10, true, 0, 1.0E-13, 1.0E-8, 0.1, 100000, expected);
        this.doTest(new DiffPow(), startPoint, insigma, boundaries, GoalType.MINIMIZE, 10, false, 0, 1.0E-13, 1.0E-8, 0.2, 100000, expected);
    }

    @Test
    public void testSsDiffPow() {
        double[] startPoint = CMAESOptimizerTest.point(13, 1.0);
        double[] insigma = CMAESOptimizerTest.point(13, 0.1);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 0.0), 0.0);
        this.doTest(new SsDiffPow(), startPoint, insigma, boundaries, GoalType.MINIMIZE, 10, true, 0, 1.0E-13, 1.0E-4, 0.1, 200000, expected);
        this.doTest(new SsDiffPow(), startPoint, insigma, boundaries, GoalType.MINIMIZE, 10, false, 0, 1.0E-13, 1.0E-4, 0.1, 200000, expected);
    }

    @Test
    public void testAckley() {
        double[] startPoint = CMAESOptimizerTest.point(13, 1.0);
        double[] insigma = CMAESOptimizerTest.point(13, 1.0);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 0.0), 0.0);
        this.doTest(new Ackley(), startPoint, insigma, boundaries, GoalType.MINIMIZE, 2 * LAMBDA, true, 0, 1.0E-13, 1.0E-9, 1.0E-5, 100000, expected);
        this.doTest(new Ackley(), startPoint, insigma, boundaries, GoalType.MINIMIZE, 2 * LAMBDA, false, 0, 1.0E-13, 1.0E-9, 1.0E-5, 100000, expected);
    }

    @Test
    public void testRastrigin() {
        double[] startPoint = CMAESOptimizerTest.point(13, 0.1);
        double[] insigma = CMAESOptimizerTest.point(13, 0.1);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 0.0), 0.0);
        this.doTest(new Rastrigin(), startPoint, insigma, boundaries, GoalType.MINIMIZE, (int)(200.0 * FastMath.sqrt((double)13.0)), true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 200000, expected);
        this.doTest(new Rastrigin(), startPoint, insigma, boundaries, GoalType.MINIMIZE, (int)(200.0 * FastMath.sqrt((double)13.0)), false, 0, 1.0E-13, 1.0E-13, 1.0E-6, 200000, expected);
    }

    @Test
    public void testConstrainedRosen() {
        double[] startPoint = CMAESOptimizerTest.point(13, 0.1);
        double[] insigma = CMAESOptimizerTest.point(13, 0.1);
        double[][] boundaries = CMAESOptimizerTest.boundaries(13, -1.0, 2.0);
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 1.0), 0.0);
        this.doTest(new Rosen(), startPoint, insigma, boundaries, GoalType.MINIMIZE, 2 * LAMBDA, true, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
        this.doTest(new Rosen(), startPoint, insigma, boundaries, GoalType.MINIMIZE, 2 * LAMBDA, false, 0, 1.0E-13, 1.0E-13, 1.0E-6, 100000, expected);
    }

    @Test
    public void testDiagonalRosen() {
        double[] startPoint = CMAESOptimizerTest.point(13, 0.1);
        double[] insigma = CMAESOptimizerTest.point(13, 0.1);
        double[][] boundaries = null;
        PointValuePair expected = new PointValuePair(CMAESOptimizerTest.point(13, 1.0), 0.0);
        this.doTest(new Rosen(), startPoint, insigma, boundaries, GoalType.MINIMIZE, LAMBDA, false, 1, 1.0E-13, 1.0E-10, 1.0E-4, 1000000, expected);
    }

    @Test
    public void testMath864() {
        CMAESOptimizer optimizer = new CMAESOptimizer();
        MultivariateFunction fitnessFunction = new MultivariateFunction(){

            public double value(double[] parameters) {
                double target = 1.0;
                double error = 1.0 - parameters[0];
                return error * error;
            }
        };
        double[] start = new double[]{0.0};
        double[] lower = new double[]{-1000000.0};
        double[] upper = new double[]{1.5};
        double[] result = optimizer.optimize(10000, fitnessFunction, GoalType.MINIMIZE, start, lower, upper).getPoint();
        Assert.assertTrue((String)("Out of bounds (" + result[0] + " > " + upper[0] + ")"), (result[0] <= upper[0] ? 1 : 0) != 0);
    }

    @Test
    public void testFitAccuracyDependsOnBoundary() {
        CMAESOptimizer optimizer = new CMAESOptimizer();
        MultivariateFunction fitnessFunction = new MultivariateFunction(){

            public double value(double[] parameters) {
                double target = 11.1;
                double error = 11.1 - parameters[0];
                return error * error;
            }
        };
        double[] start = new double[]{1.0};
        PointValuePair result = optimizer.optimize(100000, fitnessFunction, GoalType.MINIMIZE, start);
        double resNoBound = result.getPoint()[0];
        double[] lower = new double[]{-20.0};
        double[] upper = new double[]{5.0E16};
        result = optimizer.optimize(100000, fitnessFunction, GoalType.MINIMIZE, start, lower, upper);
        double resNearLo = result.getPoint()[0];
        lower[0] = -5.0E16;
        upper[0] = 20.0;
        result = optimizer.optimize(100000, fitnessFunction, GoalType.MINIMIZE, start, lower, upper);
        double resNearHi = result.getPoint()[0];
        Assert.assertEquals((double)resNoBound, (double)resNearLo, (double)0.001);
        Assert.assertEquals((double)resNoBound, (double)resNearHi, (double)0.001);
    }

    private void doTest(MultivariateFunction func, double[] startPoint, double[] inSigma, double[][] boundaries, GoalType goal, int lambda, boolean isActive, int diagonalOnly, double stopValue, double fTol, double pointTol, int maxEvaluations, PointValuePair expected) {
        int dim = startPoint.length;
        CMAESOptimizer optim = new CMAESOptimizer(30000, stopValue, isActive, diagonalOnly, 0, (RandomGenerator)new MersenneTwister(), false, null);
        double[] lB = boundaries == null ? null : boundaries[0];
        double[] uB = boundaries == null ? null : boundaries[1];
        PointValuePair result = boundaries == null ? optim.optimize(maxEvaluations, func, goal, new OptimizationData[]{new InitialGuess(startPoint), new CMAESOptimizer.Sigma(inSigma), new CMAESOptimizer.PopulationSize(lambda)}) : optim.optimize(maxEvaluations, func, goal, new OptimizationData[]{new InitialGuess(startPoint), new SimpleBounds(lB, uB), new CMAESOptimizer.Sigma(inSigma), new CMAESOptimizer.PopulationSize(lambda)});
        Assert.assertEquals((double)((Double)expected.getValue()), (double)((Double)result.getValue()), (double)fTol);
        for (int i = 0; i < dim; ++i) {
            Assert.assertEquals((double)expected.getPoint()[i], (double)result.getPoint()[i], (double)pointTol);
        }
    }

    private static double[] point(int n, double value) {
        double[] ds = new double[n];
        Arrays.fill(ds, value);
        return ds;
    }

    private static double[][] boundaries(int dim, double lower, double upper) {
        int i;
        double[][] boundaries = new double[2][dim];
        for (i = 0; i < dim; ++i) {
            boundaries[0][i] = lower;
        }
        for (i = 0; i < dim; ++i) {
            boundaries[1][i] = upper;
        }
        return boundaries;
    }

    private static class Basis {
        double[][] basis;
        Random rand = new Random(2L);

        private Basis() {
        }

        double[] Rotate(double[] x) {
            this.GenBasis(x.length);
            double[] y = new double[x.length];
            for (int i = 0; i < x.length; ++i) {
                y[i] = 0.0;
                for (int j = 0; j < x.length; ++j) {
                    int n = i;
                    y[n] = y[n] + this.basis[i][j] * x[j];
                }
            }
            return y;
        }

        void GenBasis(int DIM) {
            if (this.basis != null && this.basis.length == DIM) {
                return;
            }
            this.basis = new double[DIM][DIM];
            for (int i = 0; i < DIM; ++i) {
                int k;
                double sp;
                int j;
                for (j = 0; j < DIM; ++j) {
                    this.basis[i][j] = this.rand.nextGaussian();
                }
                for (j = i - 1; j >= 0; --j) {
                    sp = 0.0;
                    for (k = 0; k < DIM; ++k) {
                        sp += this.basis[i][k] * this.basis[j][k];
                    }
                    for (k = 0; k < DIM; ++k) {
                        double[] dArray = this.basis[i];
                        int n = k;
                        dArray[n] = dArray[n] - sp * this.basis[j][k];
                    }
                }
                sp = 0.0;
                for (k = 0; k < DIM; ++k) {
                    sp += this.basis[i][k] * this.basis[i][k];
                }
                k = 0;
                while (k < DIM) {
                    double[] dArray = this.basis[i];
                    int n = k++;
                    dArray[n] = dArray[n] / FastMath.sqrt((double)sp);
                }
            }
        }
    }

    private static class Rastrigin
    implements MultivariateFunction {
        private double axisratio;
        private double amplitude;

        Rastrigin() {
            this(1.0, 10.0);
        }

        Rastrigin(double axisratio, double amplitude) {
            this.axisratio = axisratio;
            this.amplitude = amplitude;
        }

        public double value(double[] x) {
            double f = 0.0;
            for (int i = 0; i < x.length; ++i) {
                double fac = FastMath.pow((double)this.axisratio, (double)(((double)i - 1.0) / ((double)x.length - 1.0)));
                if (i == 0 && x[i] < 0.0) {
                    fac *= 1.0;
                }
                f += fac * fac * x[i] * x[i] + this.amplitude * (1.0 - FastMath.cos((double)(Math.PI * 2 * fac * x[i])));
            }
            return f;
        }
    }

    private static class Ackley
    implements MultivariateFunction {
        private double axisratio;

        Ackley(double axra) {
            this.axisratio = axra;
        }

        public Ackley() {
            this(1.0);
        }

        public double value(double[] x) {
            double f = 0.0;
            double res2 = 0.0;
            double fac = 0.0;
            for (int i = 0; i < x.length; ++i) {
                fac = FastMath.pow((double)this.axisratio, (double)(((double)i - 1.0) / ((double)x.length - 1.0)));
                f += fac * fac * x[i] * x[i];
                res2 += FastMath.cos((double)(Math.PI * 2 * fac * x[i]));
            }
            f = 20.0 - 20.0 * FastMath.exp((double)(-0.2 * FastMath.sqrt((double)(f / (double)x.length)))) + FastMath.exp((double)1.0) - FastMath.exp((double)(res2 / (double)x.length));
            return f;
        }
    }

    private static class Rosen
    implements MultivariateFunction {
        private Rosen() {
        }

        public double value(double[] x) {
            double f = 0.0;
            for (int i = 0; i < x.length - 1; ++i) {
                f += 100.0 * (x[i] * x[i] - x[i + 1]) * (x[i] * x[i] - x[i + 1]) + (x[i] - 1.0) * (x[i] - 1.0);
            }
            return f;
        }
    }

    private static class SsDiffPow
    implements MultivariateFunction {
        private SsDiffPow() {
        }

        public double value(double[] x) {
            double f = FastMath.pow((double)new DiffPow().value(x), (double)0.25);
            return f;
        }
    }

    private static class DiffPow
    implements MultivariateFunction {
        private DiffPow() {
        }

        public double value(double[] x) {
            double f = 0.0;
            for (int i = 0; i < x.length; ++i) {
                f += FastMath.pow((double)FastMath.abs((double)x[i]), (double)(2.0 + 10.0 * (double)i / ((double)x.length - 1.0)));
            }
            return f;
        }
    }

    private static class MinusElli
    implements MultivariateFunction {
        private MinusElli() {
        }

        public double value(double[] x) {
            return 1.0 - new Elli().value(x);
        }
    }

    private static class Elli
    implements MultivariateFunction {
        private double factor;

        Elli() {
            this(1000.0);
        }

        Elli(double axisratio) {
            this.factor = axisratio * axisratio;
        }

        public double value(double[] x) {
            double f = 0.0;
            for (int i = 0; i < x.length; ++i) {
                f += FastMath.pow((double)this.factor, (double)((double)i / ((double)x.length - 1.0))) * x[i] * x[i];
            }
            return f;
        }
    }

    private static class ElliRotated
    implements MultivariateFunction {
        private Basis B = new Basis();
        private double factor;

        ElliRotated() {
            this(1000.0);
        }

        ElliRotated(double axisratio) {
            this.factor = axisratio * axisratio;
        }

        public double value(double[] x) {
            double f = 0.0;
            x = this.B.Rotate(x);
            for (int i = 0; i < x.length; ++i) {
                f += FastMath.pow((double)this.factor, (double)((double)i / ((double)x.length - 1.0))) * x[i] * x[i];
            }
            return f;
        }
    }

    private static class TwoAxes
    implements MultivariateFunction {
        private double factor;

        TwoAxes() {
            this(1000000.0);
        }

        TwoAxes(double axisratio) {
            this.factor = axisratio * axisratio;
        }

        public double value(double[] x) {
            double f = 0.0;
            for (int i = 0; i < x.length; ++i) {
                f += (i < x.length / 2 ? this.factor : 1.0) * x[i] * x[i];
            }
            return f;
        }
    }

    private static class CigTab
    implements MultivariateFunction {
        private double factor;

        CigTab() {
            this(10000.0);
        }

        CigTab(double axisratio) {
            this.factor = axisratio;
        }

        public double value(double[] x) {
            int end = x.length - 1;
            double f = x[0] * x[0] / this.factor + this.factor * x[end] * x[end];
            for (int i = 1; i < end; ++i) {
                f += x[i] * x[i];
            }
            return f;
        }
    }

    private static class Tablet
    implements MultivariateFunction {
        private double factor;

        Tablet() {
            this(1000.0);
        }

        Tablet(double axisratio) {
            this.factor = axisratio * axisratio;
        }

        public double value(double[] x) {
            double f = this.factor * x[0] * x[0];
            for (int i = 1; i < x.length; ++i) {
                f += x[i] * x[i];
            }
            return f;
        }
    }

    private static class Cigar
    implements MultivariateFunction {
        private double factor;

        Cigar() {
            this(1000.0);
        }

        Cigar(double axisratio) {
            this.factor = axisratio * axisratio;
        }

        public double value(double[] x) {
            double f = x[0] * x[0];
            for (int i = 1; i < x.length; ++i) {
                f += this.factor * x[i] * x[i];
            }
            return f;
        }
    }

    private static class Sphere
    implements MultivariateFunction {
        private Sphere() {
        }

        public double value(double[] x) {
            double f = 0.0;
            for (int i = 0; i < x.length; ++i) {
                f += x[i] * x[i];
            }
            return f;
        }
    }
}

