/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optim;

import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.optim.PointValuePair;
import com.hazelcast.shaded.org.apache.commons.math3.optim.SimpleValueChecker;
import org.junit.Assert;
import org.junit.Test;

public class SimpleValueCheckerTest {
    @Test(expected=NotStrictlyPositiveException.class)
    public void testIterationCheckPrecondition() {
        new SimpleValueChecker(0.1, 0.01, 0);
    }

    @Test
    public void testIterationCheck() {
        int max = 10;
        SimpleValueChecker checker = new SimpleValueChecker(0.1, 0.01, 10);
        Assert.assertTrue((boolean)checker.converged(10, null, null));
        Assert.assertTrue((boolean)checker.converged(11, null, null));
    }

    @Test
    public void testIterationCheckDisabled() {
        SimpleValueChecker checker = new SimpleValueChecker(1.0E-8, 1.0E-8);
        PointValuePair a = new PointValuePair(new double[]{1.0}, 1.0);
        PointValuePair b = new PointValuePair(new double[]{10.0}, 10.0);
        Assert.assertFalse((boolean)checker.converged(-1, a, b));
        Assert.assertFalse((boolean)checker.converged(0, a, b));
        Assert.assertFalse((boolean)checker.converged(1000000, a, b));
        Assert.assertTrue((boolean)checker.converged(-1, a, a));
        Assert.assertTrue((boolean)checker.converged(-1, b, b));
    }
}

