/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.sampling;

import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.GraggBulirschStoerIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.FixedStepHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepNormalizer;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepNormalizerBounds;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepNormalizerMode;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class StepNormalizerOutputTestBase
implements FirstOrderDifferentialEquations,
FixedStepHandler {
    private List<Double> output;

    protected abstract double getStart();

    protected abstract double getEnd();

    protected abstract double[] getExpInc();

    protected abstract double[] getExpIncRev();

    protected abstract double[] getExpMul();

    protected abstract double[] getExpMulRev();

    protected abstract int[][] getO();

    private double[] getArray(double[] a, int offsetL, int offsetR) {
        double[] copy = new double[a.length - offsetR - offsetL];
        System.arraycopy(a, offsetL, copy, 0, copy.length);
        return copy;
    }

    @Test
    public void testIncNeither() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpInc(), this.getO()[0][0], this.getO()[0][1]);
        this.doTest(StepNormalizerMode.INCREMENT, StepNormalizerBounds.NEITHER, exp, false);
    }

    @Test
    public void testIncNeitherRev() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpIncRev(), this.getO()[1][0], this.getO()[1][1]);
        this.doTest(StepNormalizerMode.INCREMENT, StepNormalizerBounds.NEITHER, exp, true);
    }

    @Test
    public void testIncFirst() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpInc(), this.getO()[2][0], this.getO()[2][1]);
        this.doTest(StepNormalizerMode.INCREMENT, StepNormalizerBounds.FIRST, exp, false);
    }

    @Test
    public void testIncFirstRev() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpIncRev(), this.getO()[3][0], this.getO()[3][1]);
        this.doTest(StepNormalizerMode.INCREMENT, StepNormalizerBounds.FIRST, exp, true);
    }

    @Test
    public void testIncLast() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpInc(), this.getO()[4][0], this.getO()[4][1]);
        this.doTest(StepNormalizerMode.INCREMENT, StepNormalizerBounds.LAST, exp, false);
    }

    @Test
    public void testIncLastRev() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpIncRev(), this.getO()[5][0], this.getO()[5][1]);
        this.doTest(StepNormalizerMode.INCREMENT, StepNormalizerBounds.LAST, exp, true);
    }

    @Test
    public void testIncBoth() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpInc(), this.getO()[6][0], this.getO()[6][1]);
        this.doTest(StepNormalizerMode.INCREMENT, StepNormalizerBounds.BOTH, exp, false);
    }

    @Test
    public void testIncBothRev() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpIncRev(), this.getO()[7][0], this.getO()[7][1]);
        this.doTest(StepNormalizerMode.INCREMENT, StepNormalizerBounds.BOTH, exp, true);
    }

    @Test
    public void testMulNeither() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpMul(), this.getO()[8][0], this.getO()[8][1]);
        this.doTest(StepNormalizerMode.MULTIPLES, StepNormalizerBounds.NEITHER, exp, false);
    }

    @Test
    public void testMulNeitherRev() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpMulRev(), this.getO()[9][0], this.getO()[9][1]);
        this.doTest(StepNormalizerMode.MULTIPLES, StepNormalizerBounds.NEITHER, exp, true);
    }

    @Test
    public void testMulFirst() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpMul(), this.getO()[10][0], this.getO()[10][1]);
        this.doTest(StepNormalizerMode.MULTIPLES, StepNormalizerBounds.FIRST, exp, false);
    }

    @Test
    public void testMulFirstRev() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpMulRev(), this.getO()[11][0], this.getO()[11][1]);
        this.doTest(StepNormalizerMode.MULTIPLES, StepNormalizerBounds.FIRST, exp, true);
    }

    @Test
    public void testMulLast() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpMul(), this.getO()[12][0], this.getO()[12][1]);
        this.doTest(StepNormalizerMode.MULTIPLES, StepNormalizerBounds.LAST, exp, false);
    }

    @Test
    public void testMulLastRev() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpMulRev(), this.getO()[13][0], this.getO()[13][1]);
        this.doTest(StepNormalizerMode.MULTIPLES, StepNormalizerBounds.LAST, exp, true);
    }

    @Test
    public void testMulBoth() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpMul(), this.getO()[14][0], this.getO()[14][1]);
        this.doTest(StepNormalizerMode.MULTIPLES, StepNormalizerBounds.BOTH, exp, false);
    }

    @Test
    public void testMulBothRev() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] exp = this.getArray(this.getExpMulRev(), this.getO()[15][0], this.getO()[15][1]);
        this.doTest(StepNormalizerMode.MULTIPLES, StepNormalizerBounds.BOTH, exp, true);
    }

    private void doTest(StepNormalizerMode mode, StepNormalizerBounds bounds, double[] expected, boolean reverse) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        GraggBulirschStoerIntegrator integ = new GraggBulirschStoerIntegrator(1.0E-8, 1.0, 1.0E-5, 1.0E-5);
        integ.addStepHandler((StepHandler)new StepNormalizer(0.5, (FixedStepHandler)this, mode, bounds));
        double[] y = new double[]{0.0};
        double start = reverse ? this.getEnd() : this.getStart();
        double end = reverse ? this.getStart() : this.getEnd();
        this.output = new ArrayList<Double>();
        integ.integrate((FirstOrderDifferentialEquations)this, start, y, end, y);
        double[] actual = new double[this.output.size()];
        for (int i = 0; i < actual.length; ++i) {
            actual[i] = this.output.get(i);
        }
        Assert.assertArrayEquals((double[])expected, (double[])actual, (double)1.0E-5);
    }

    public int getDimension() {
        return 1;
    }

    public void computeDerivatives(double t, double[] y, double[] yDot) {
        yDot[0] = y[0];
    }

    public void init(double t0, double[] y0, double t) {
    }

    public void handleStep(double t, double[] y, double[] yDot, boolean isLast) {
        this.output.add(t);
    }
}

