/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.sampling;

import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.ContinuousOutputModel;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem1;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem3;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.AdamsBashforthIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepInterpolatorTestUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class NordsieckStepInterpolatorTest {
    @Test
    public void derivativesConsistency() throws NumberIsTooSmallException, DimensionMismatchException, MaxCountExceededException, NoBracketingException {
        TestProblem3 pb = new TestProblem3();
        AdamsBashforthIntegrator integ = new AdamsBashforthIntegrator(4, 0.0, 1.0, 1.0E-10, 1.0E-10);
        StepInterpolatorTestUtils.checkDerivativesConsistency((FirstOrderIntegrator)integ, pb, 0.05, 2.8E-9);
    }

    @Test
    public void serialization() throws IOException, ClassNotFoundException, NumberIsTooSmallException, DimensionMismatchException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        AdamsBashforthIntegrator integ = new AdamsBashforthIntegrator(4, 0.0, 1.0, 1.0E-10, 1.0E-10);
        integ.addStepHandler((StepHandler)new ContinuousOutputModel());
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        for (StepHandler handler : integ.getStepHandlers()) {
            oos.writeObject(handler);
        }
        Assert.assertTrue((bos.size() > 47000 ? 1 : 0) != 0);
        Assert.assertTrue((bos.size() < 48000 ? 1 : 0) != 0);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        ContinuousOutputModel cm = (ContinuousOutputModel)ois.readObject();
        Random random = new Random(347588535632L);
        double maxError = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double r = random.nextDouble();
            double time = r * pb.getInitialTime() + (1.0 - r) * pb.getFinalTime();
            cm.setInterpolatedTime(time);
            double[] interpolatedY = cm.getInterpolatedState();
            double[] theoreticalY = pb.computeTheoreticalState(time);
            double dx = interpolatedY[0] - theoreticalY[0];
            double dy = interpolatedY[1] - theoreticalY[1];
            double error = dx * dx + dy * dy;
            if (!(error > maxError)) continue;
            maxError = error;
        }
        Assert.assertTrue((maxError < 1.0E-6 ? 1 : 0) != 0);
    }
}

