/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.events;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.BracketingNthOrderBrentSolver;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.events.EventFilter;
import com.hazelcast.shaded.org.apache.commons.math3.ode.events.EventHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.events.FilterType;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.DormandPrince853Integrator;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well19937a;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class EventFilterTest {
    @Test
    public void testHistoryIncreasingForward() {
        this.testHistory(FilterType.TRIGGER_ONLY_INCREASING_EVENTS, 1.5707963267948966, 95.81857593448869, Math.PI, -1.0);
        this.testHistory(FilterType.TRIGGER_ONLY_INCREASING_EVENTS, 0.0, 95.81857593448869, Math.PI, -1.0);
        this.testHistory(FilterType.TRIGGER_ONLY_INCREASING_EVENTS, 4.71238898038469, 95.81857593448869, Math.PI, 1.0);
    }

    @Test
    public void testHistoryIncreasingBackward() {
        this.testHistory(FilterType.TRIGGER_ONLY_INCREASING_EVENTS, 1.5707963267948966, -95.81857593448869, Math.PI, -1.0);
        this.testHistory(FilterType.TRIGGER_ONLY_INCREASING_EVENTS, 0.0, -95.81857593448869, Math.PI, 1.0);
        this.testHistory(FilterType.TRIGGER_ONLY_INCREASING_EVENTS, 4.71238898038469, -95.81857593448869, Math.PI, -1.0);
    }

    @Test
    public void testHistoryDecreasingForward() {
        this.testHistory(FilterType.TRIGGER_ONLY_DECREASING_EVENTS, 1.5707963267948966, 95.81857593448869, 0.0, 1.0);
        this.testHistory(FilterType.TRIGGER_ONLY_DECREASING_EVENTS, 0.0, 95.81857593448869, 0.0, 1.0);
        this.testHistory(FilterType.TRIGGER_ONLY_DECREASING_EVENTS, 4.71238898038469, 95.81857593448869, 0.0, 1.0);
    }

    @Test
    public void testHistoryDecreasingBackward() {
        this.testHistory(FilterType.TRIGGER_ONLY_DECREASING_EVENTS, 1.5707963267948966, -95.81857593448869, 0.0, -1.0);
        this.testHistory(FilterType.TRIGGER_ONLY_DECREASING_EVENTS, 0.0, -95.81857593448869, 0.0, -1.0);
        this.testHistory(FilterType.TRIGGER_ONLY_DECREASING_EVENTS, 4.71238898038469, -95.81857593448869, 0.0, 1.0);
    }

    public void testHistory(FilterType type, double t0, double t1, double refSwitch, double signEven) {
        Event onlyIncreasing = new Event(false, true);
        EventFilter eventFilter = new EventFilter((EventHandler)onlyIncreasing, type);
        eventFilter.init(t0, new double[]{1.0, 0.0}, t1);
        double h = FastMath.copySign((double)0.05, (double)(t1 - t0));
        double n = (int)FastMath.floor((double)((t1 - t0) / h));
        int i = 0;
        while ((double)i < n) {
            double t = t0 + (double)i * h;
            eventFilter.g(t, new double[]{FastMath.sin((double)t), FastMath.cos((double)t)});
            ++i;
        }
        Well19937a rng = new Well19937a(-5699516355654480685L);
        for (int i2 = 0; i2 < 5000; ++i2) {
            double t = t0 + (t1 - t0) * rng.nextDouble();
            double g = eventFilter.g(t, new double[]{FastMath.sin((double)t), FastMath.cos((double)t)});
            int turn = (int)FastMath.floor((double)((t - refSwitch) / (Math.PI * 2)));
            if (turn % 2 == 0) {
                Assert.assertEquals((double)(signEven * FastMath.sin((double)t)), (double)g, (double)1.0E-10);
                continue;
            }
            Assert.assertEquals((double)(-signEven * FastMath.sin((double)t)), (double)g, (double)1.0E-10);
        }
    }

    @Test
    public void testIncreasingOnly() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double e = 1.0E-15;
        DormandPrince853Integrator integrator = new DormandPrince853Integrator(0.001, 100.0, 1.0E-7, 1.0E-7);
        Event allEvents = new Event(true, true);
        integrator.addEventHandler((EventHandler)allEvents, 0.1, e, 1000, (UnivariateSolver)new BracketingNthOrderBrentSolver(1.0E-7, 5));
        Event onlyIncreasing = new Event(false, true);
        integrator.addEventHandler((EventHandler)new EventFilter((EventHandler)onlyIncreasing, FilterType.TRIGGER_ONLY_INCREASING_EVENTS), 0.1, e, 100, (UnivariateSolver)new BracketingNthOrderBrentSolver(1.0E-7, 5));
        double t0 = 1.5707963267948966;
        double tEnd = 17.27875959474386;
        double[] y = new double[]{0.0, 1.0};
        Assert.assertEquals((double)tEnd, (double)integrator.integrate((FirstOrderDifferentialEquations)new SineCosine(), t0, y, tEnd, y), (double)1.0E-7);
        Assert.assertEquals((long)5L, (long)allEvents.getEventCount());
        Assert.assertEquals((long)2L, (long)onlyIncreasing.getEventCount());
    }

    @Test
    public void testDecreasingOnly() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double e = 1.0E-15;
        DormandPrince853Integrator integrator = new DormandPrince853Integrator(0.001, 100.0, 1.0E-7, 1.0E-7);
        Event allEvents = new Event(true, true);
        integrator.addEventHandler((EventHandler)allEvents, 0.1, e, 1000, (UnivariateSolver)new BracketingNthOrderBrentSolver(1.0E-7, 5));
        Event onlyDecreasing = new Event(true, false);
        integrator.addEventHandler((EventHandler)new EventFilter((EventHandler)onlyDecreasing, FilterType.TRIGGER_ONLY_DECREASING_EVENTS), 0.1, e, 1000, (UnivariateSolver)new BracketingNthOrderBrentSolver(1.0E-7, 5));
        double t0 = 1.5707963267948966;
        double tEnd = 17.27875959474386;
        double[] y = new double[]{0.0, 1.0};
        Assert.assertEquals((double)tEnd, (double)integrator.integrate((FirstOrderDifferentialEquations)new SineCosine(), t0, y, tEnd, y), (double)1.0E-7);
        Assert.assertEquals((long)5L, (long)allEvents.getEventCount());
        Assert.assertEquals((long)3L, (long)onlyDecreasing.getEventCount());
    }

    @Test
    public void testTwoOppositeFilters() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double e = 1.0E-15;
        DormandPrince853Integrator integrator = new DormandPrince853Integrator(0.001, 100.0, 1.0E-7, 1.0E-7);
        Event allEvents = new Event(true, true);
        integrator.addEventHandler((EventHandler)allEvents, 0.1, e, 1000, (UnivariateSolver)new BracketingNthOrderBrentSolver(1.0E-7, 5));
        Event onlyIncreasing = new Event(false, true);
        integrator.addEventHandler((EventHandler)new EventFilter((EventHandler)onlyIncreasing, FilterType.TRIGGER_ONLY_INCREASING_EVENTS), 0.1, e, 1000, (UnivariateSolver)new BracketingNthOrderBrentSolver(1.0E-7, 5));
        Event onlyDecreasing = new Event(true, false);
        integrator.addEventHandler((EventHandler)new EventFilter((EventHandler)onlyDecreasing, FilterType.TRIGGER_ONLY_DECREASING_EVENTS), 0.1, e, 1000, (UnivariateSolver)new BracketingNthOrderBrentSolver(1.0E-7, 5));
        double t0 = 1.5707963267948966;
        double tEnd = 17.27875959474386;
        double[] y = new double[]{0.0, 1.0};
        Assert.assertEquals((double)tEnd, (double)integrator.integrate((FirstOrderDifferentialEquations)new SineCosine(), t0, y, tEnd, y), (double)1.0E-7);
        Assert.assertEquals((long)5L, (long)allEvents.getEventCount());
        Assert.assertEquals((long)2L, (long)onlyIncreasing.getEventCount());
        Assert.assertEquals((long)3L, (long)onlyDecreasing.getEventCount());
    }

    protected static class Event
    implements EventHandler {
        private final boolean expectDecreasing;
        private final boolean expectIncreasing;
        private int eventCount;

        public Event(boolean expectDecreasing, boolean expectIncreasing) {
            this.expectDecreasing = expectDecreasing;
            this.expectIncreasing = expectIncreasing;
        }

        public int getEventCount() {
            return this.eventCount;
        }

        public void init(double t0, double[] y0, double t) {
            this.eventCount = 0;
        }

        public double g(double t, double[] y) {
            return y[0];
        }

        public EventHandler.Action eventOccurred(double t, double[] y, boolean increasing) {
            if (increasing) {
                Assert.assertTrue((boolean)this.expectIncreasing);
            } else {
                Assert.assertTrue((boolean)this.expectDecreasing);
            }
            ++this.eventCount;
            return EventHandler.Action.RESET_STATE;
        }

        public void resetState(double t, double[] y) {
        }
    }

    private static class SineCosine
    implements FirstOrderDifferentialEquations {
        private SineCosine() {
        }

        public int getDimension() {
            return 2;
        }

        public void computeDerivatives(double t, double[] y, double[] yDot) {
            yDot[0] = y[1];
            yDot[1] = -y[0];
        }
    }
}

