/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode;

import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblemAbstract;
import com.hazelcast.shaded.org.apache.commons.math3.ode.events.EventHandler;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;

public class TestProblem4
extends TestProblemAbstract {
    private double a = 1.2;
    private double[] y;

    public TestProblem4() {
        double[] y0 = new double[]{FastMath.sin((double)this.a), FastMath.cos((double)this.a)};
        this.setInitialConditions(0.0, y0);
        this.setFinalConditions(15.0);
        double[] errorScale = new double[]{1.0, 0.0};
        this.setErrorScale(errorScale);
        this.y = new double[y0.length];
    }

    public EventHandler[] getEventsHandlers() {
        return new EventHandler[]{new Bounce(), new Stop()};
    }

    public double[] getTheoreticalEventsTimes() {
        return new double[]{Math.PI - this.a, Math.PI * 2 - this.a, Math.PI * 3 - this.a, Math.PI * 4 - this.a, 12.0};
    }

    public void doComputeDerivatives(double t, double[] y, double[] yDot) {
        yDot[0] = y[1];
        yDot[1] = -y[0];
    }

    public double[] computeTheoreticalState(double t) {
        double sin = FastMath.sin((double)(t + this.a));
        double cos = FastMath.cos((double)(t + this.a));
        this.y[0] = FastMath.abs((double)sin);
        this.y[1] = sin >= 0.0 ? cos : -cos;
        return this.y;
    }

    private static class Stop
    implements EventHandler {
        public void init(double t0, double[] y0, double t) {
        }

        public double g(double t, double[] y) {
            return t - 12.0;
        }

        public EventHandler.Action eventOccurred(double t, double[] y, boolean increasing) {
            return EventHandler.Action.STOP;
        }

        public void resetState(double t, double[] y) {
        }
    }

    private static class Bounce
    implements EventHandler {
        private int sign = 1;

        public void init(double t0, double[] y0, double t) {
        }

        public double g(double t, double[] y) {
            return (double)this.sign * y[0];
        }

        public EventHandler.Action eventOccurred(double t, double[] y, boolean increasing) {
            this.sign = -this.sign;
            return EventHandler.Action.RESET_STATE;
        }

        public void resetState(double t, double[] y) {
            y[0] = -y[0];
            y[1] = -y[1];
        }
    }
}

