/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.DecompositionSolver;
import com.hazelcast.shaded.org.apache.commons.math3.linear.LUDecomposition;
import com.hazelcast.shaded.org.apache.commons.math3.linear.MatrixUtils;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVectorAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.linear.SingularMatrixException;
import org.junit.Assert;
import org.junit.Test;

public class LUSolverTest {
    private double[][] testData = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 3.0}, {1.0, 0.0, 8.0}};
    private double[][] luData = new double[][]{{2.0, 3.0, 3.0}, {0.0, 5.0, 7.0}, {6.0, 9.0, 8.0}};
    private double[][] singular = new double[][]{{2.0, 3.0}, {2.0, 3.0}};
    private double[][] bigSingular = new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 5.0, 3.0, 4.0}, {7.0, 3.0, 256.0, 1930.0}, {3.0, 7.0, 6.0, 8.0}};

    @Test
    public void testThreshold() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 3.0}, {4.000001, 9.0, 9.0}});
        Assert.assertFalse((boolean)new LUDecomposition(matrix, 1.0E-5).getSolver().isNonSingular());
        Assert.assertTrue((boolean)new LUDecomposition(matrix, 1.0E-10).getSolver().isNonSingular());
    }

    @Test
    public void testSingular() {
        DecompositionSolver solver = new LUDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData)).getSolver();
        Assert.assertTrue((boolean)solver.isNonSingular());
        solver = new LUDecomposition(MatrixUtils.createRealMatrix((double[][])this.singular)).getSolver();
        Assert.assertFalse((boolean)solver.isNonSingular());
        solver = new LUDecomposition(MatrixUtils.createRealMatrix((double[][])this.bigSingular)).getSolver();
        Assert.assertFalse((boolean)solver.isNonSingular());
    }

    @Test
    public void testSolveDimensionErrors() {
        DecompositionSolver solver = new LUDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData)).getSolver();
        RealMatrix b = MatrixUtils.createRealMatrix((double[][])new double[2][2]);
        try {
            solver.solve(b);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            solver.solve(b.getColumnVector(0));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            solver.solve((RealVector)new RealVectorAbstractTest.RealVectorTestImpl(b.getColumn(0)));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSolveSingularityErrors() {
        DecompositionSolver solver = new LUDecomposition(MatrixUtils.createRealMatrix((double[][])this.singular)).getSolver();
        RealMatrix b = MatrixUtils.createRealMatrix((double[][])new double[2][2]);
        try {
            solver.solve(b);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
        try {
            solver.solve(b.getColumnVector(0));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
        try {
            solver.solve((RealVector)new RealVectorAbstractTest.RealVectorTestImpl(b.getColumn(0)));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testSolve() {
        int i;
        DecompositionSolver solver = new LUDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData)).getSolver();
        RealMatrix b = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 0.0}, {2.0, -5.0}, {3.0, 1.0}});
        RealMatrix xRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{19.0, -71.0}, {-6.0, 22.0}, {-2.0, 9.0}});
        Assert.assertEquals((double)0.0, (double)solver.solve(b).subtract(xRef).getNorm(), (double)1.0E-13);
        for (i = 0; i < b.getColumnDimension(); ++i) {
            Assert.assertEquals((double)0.0, (double)solver.solve(b.getColumnVector(i)).subtract(xRef.getColumnVector(i)).getNorm(), (double)1.0E-13);
        }
        for (i = 0; i < b.getColumnDimension(); ++i) {
            RealVectorAbstractTest.RealVectorTestImpl v = new RealVectorAbstractTest.RealVectorTestImpl(b.getColumn(i));
            Assert.assertEquals((double)0.0, (double)solver.solve((RealVector)v).subtract(xRef.getColumnVector(i)).getNorm(), (double)1.0E-13);
        }
    }

    @Test
    public void testDeterminant() {
        Assert.assertEquals((double)-1.0, (double)this.getDeterminant(MatrixUtils.createRealMatrix((double[][])this.testData)), (double)1.0E-15);
        Assert.assertEquals((double)-10.0, (double)this.getDeterminant(MatrixUtils.createRealMatrix((double[][])this.luData)), (double)1.0E-14);
        Assert.assertEquals((double)0.0, (double)this.getDeterminant(MatrixUtils.createRealMatrix((double[][])this.singular)), (double)1.0E-17);
        Assert.assertEquals((double)0.0, (double)this.getDeterminant(MatrixUtils.createRealMatrix((double[][])this.bigSingular)), (double)1.0E-10);
    }

    private double getDeterminant(RealMatrix m) {
        return new LUDecomposition(m).getDeterminant();
    }
}

