/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.linear.CholeskyDecomposition;
import com.hazelcast.shaded.org.apache.commons.math3.linear.MatrixUtils;
import com.hazelcast.shaded.org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.NonSquareMatrixException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.NonSymmetricMatrixException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import org.junit.Assert;
import org.junit.Test;

public class CholeskyDecompositionTest {
    private double[][] testData = new double[][]{{1.0, 2.0, 4.0, 7.0, 11.0}, {2.0, 13.0, 23.0, 38.0, 58.0}, {4.0, 23.0, 77.0, 122.0, 182.0}, {7.0, 38.0, 122.0, 294.0, 430.0}, {11.0, 58.0, 182.0, 430.0, 855.0}};

    @Test
    public void testDimensions() {
        CholeskyDecomposition llt = new CholeskyDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData));
        Assert.assertEquals((long)this.testData.length, (long)llt.getL().getRowDimension());
        Assert.assertEquals((long)this.testData.length, (long)llt.getL().getColumnDimension());
        Assert.assertEquals((long)this.testData.length, (long)llt.getLT().getRowDimension());
        Assert.assertEquals((long)this.testData.length, (long)llt.getLT().getColumnDimension());
    }

    @Test(expected=NonSquareMatrixException.class)
    public void testNonSquare() {
        new CholeskyDecomposition(MatrixUtils.createRealMatrix((double[][])new double[3][2]));
    }

    @Test(expected=NonSymmetricMatrixException.class)
    public void testNotSymmetricMatrixException() {
        double[][] changed = (double[][])this.testData.clone();
        double[] dArray = changed[0];
        int n = changed[0].length - 1;
        dArray[n] = dArray[n] + 1.0E-5;
        new CholeskyDecomposition(MatrixUtils.createRealMatrix((double[][])changed));
    }

    @Test(expected=NonPositiveDefiniteMatrixException.class)
    public void testNotPositiveDefinite() {
        new CholeskyDecomposition(MatrixUtils.createRealMatrix((double[][])new double[][]{{14.0, 11.0, 13.0, 15.0, 24.0}, {11.0, 34.0, 13.0, 8.0, 25.0}, {13.0, 13.0, 14.0, 15.0, 21.0}, {15.0, 8.0, 15.0, 18.0, 23.0}, {24.0, 25.0, 21.0, 23.0, 45.0}}));
    }

    @Test(expected=NonPositiveDefiniteMatrixException.class)
    public void testMath274() {
        new CholeskyDecomposition(MatrixUtils.createRealMatrix((double[][])new double[][]{{0.40434286, -0.09376327, 0.3032898, 0.04909388}, {-0.09376327, 0.10400408, 0.07137959, 0.04762857}, {0.3032898, 0.07137959, 0.30458776, 0.04882449}, {0.04909388, 0.04762857, 0.04882449, 0.07543265}}));
    }

    @Test
    public void testAEqualLLT() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])this.testData);
        CholeskyDecomposition llt = new CholeskyDecomposition(matrix);
        RealMatrix l = llt.getL();
        RealMatrix lt = llt.getLT();
        double norm = l.multiply(lt).subtract(matrix).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)1.0E-15);
    }

    @Test
    public void testLLowerTriangular() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])this.testData);
        RealMatrix l = new CholeskyDecomposition(matrix).getL();
        for (int i = 0; i < l.getRowDimension(); ++i) {
            for (int j = i + 1; j < l.getColumnDimension(); ++j) {
                Assert.assertEquals((double)0.0, (double)l.getEntry(i, j), (double)0.0);
            }
        }
    }

    @Test
    public void testLTTransposed() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])this.testData);
        CholeskyDecomposition llt = new CholeskyDecomposition(matrix);
        RealMatrix l = llt.getL();
        RealMatrix lt = llt.getLT();
        double norm = l.subtract(lt.transpose()).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)1.0E-15);
    }

    @Test
    public void testMatricesValues() {
        RealMatrix lRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 3.0, 0.0, 0.0, 0.0}, {4.0, 5.0, 6.0, 0.0, 0.0}, {7.0, 8.0, 9.0, 10.0, 0.0}, {11.0, 12.0, 13.0, 14.0, 15.0}});
        CholeskyDecomposition llt = new CholeskyDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData));
        RealMatrix l = llt.getL();
        Assert.assertEquals((double)0.0, (double)l.subtract(lRef).getNorm(), (double)1.0E-13);
        RealMatrix lt = llt.getLT();
        Assert.assertEquals((double)0.0, (double)lt.subtract(lRef.transpose()).getNorm(), (double)1.0E-13);
        Assert.assertTrue((l == llt.getL() ? 1 : 0) != 0);
        Assert.assertTrue((lt == llt.getLT() ? 1 : 0) != 0);
    }
}

