/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathParseException;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.Vector;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Vector3DFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public abstract class Vector3DFormatAbstractTest {
    Vector3DFormat vector3DFormat = Vector3DFormat.getInstance((Locale)this.getLocale());
    Vector3DFormat vector3DFormatSquare = null;

    protected abstract Locale getLocale();

    protected abstract char getDecimalCharacter();

    protected Vector3DFormatAbstractTest() {
        NumberFormat nf = NumberFormat.getInstance(this.getLocale());
        nf.setMaximumFractionDigits(2);
        this.vector3DFormatSquare = new Vector3DFormat("[", "]", " : ", nf);
    }

    @Test
    public void testSimpleNoDecimals() {
        Vector3D c = new Vector3D(1.0, 1.0, 1.0);
        String expected = "{1; 1; 1}";
        String actual = this.vector3DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleWithDecimals() {
        Vector3D c = new Vector3D(1.23, 1.43, 1.63);
        String expected = "{1" + this.getDecimalCharacter() + "23; 1" + this.getDecimalCharacter() + "43; 1" + this.getDecimalCharacter() + "63}";
        String actual = this.vector3DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleWithDecimalsTrunc() {
        Vector3D c = new Vector3D(1.232323232323, 1.434343434343, 1.633333333333);
        String expected = "{1" + this.getDecimalCharacter() + "2323232323; 1" + this.getDecimalCharacter() + "4343434343; 1" + this.getDecimalCharacter() + "6333333333}";
        String actual = this.vector3DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeX() {
        Vector3D c = new Vector3D(-1.232323232323, 1.43, 1.63);
        String expected = "{-1" + this.getDecimalCharacter() + "2323232323; 1" + this.getDecimalCharacter() + "43; 1" + this.getDecimalCharacter() + "63}";
        String actual = this.vector3DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeY() {
        Vector3D c = new Vector3D(1.23, -1.434343434343, 1.63);
        String expected = "{1" + this.getDecimalCharacter() + "23; -1" + this.getDecimalCharacter() + "4343434343; 1" + this.getDecimalCharacter() + "63}";
        String actual = this.vector3DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeZ() {
        Vector3D c = new Vector3D(1.23, 1.43, -1.633333333333);
        String expected = "{1" + this.getDecimalCharacter() + "23; 1" + this.getDecimalCharacter() + "43; -1" + this.getDecimalCharacter() + "6333333333}";
        String actual = this.vector3DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNonDefaultSetting() {
        Vector3D c = new Vector3D(1.0, 1.0, 1.0);
        String expected = "[1 : 1 : 1]";
        String actual = this.vector3DFormatSquare.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDefaultFormatVector3D() {
        Locale defaultLocal = Locale.getDefault();
        Locale.setDefault(this.getLocale());
        Vector3D c = new Vector3D(232.22222222222, -342.3333333333, 432.44444444444);
        String expected = "{232" + this.getDecimalCharacter() + "2222222222; -342" + this.getDecimalCharacter() + "3333333333; 432" + this.getDecimalCharacter() + "4444444444}";
        String actual = new Vector3DFormat().format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
        Locale.setDefault(defaultLocal);
    }

    @Test
    public void testNan() {
        Vector3D c = Vector3D.NaN;
        String expected = "{(NaN); (NaN); (NaN)}";
        String actual = this.vector3DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testPositiveInfinity() {
        Vector3D c = Vector3D.POSITIVE_INFINITY;
        String expected = "{(Infinity); (Infinity); (Infinity)}";
        String actual = this.vector3DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void tesNegativeInfinity() {
        Vector3D c = Vector3D.NEGATIVE_INFINITY;
        String expected = "{(-Infinity); (-Infinity); (-Infinity)}";
        String actual = this.vector3DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseSimpleNoDecimals() throws MathParseException {
        String source = "{1; 1; 1}";
        Vector3D expected = new Vector3D(1.0, 1.0, 1.0);
        Vector3D actual = this.vector3DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseIgnoredWhitespace() {
        Vector3D expected = new Vector3D(1.0, 1.0, 1.0);
        ParsePosition pos1 = new ParsePosition(0);
        String source1 = "{1;1;1}";
        Assert.assertEquals((Object)expected, (Object)this.vector3DFormat.parse(source1, pos1));
        Assert.assertEquals((long)source1.length(), (long)pos1.getIndex());
        ParsePosition pos2 = new ParsePosition(0);
        String source2 = " { 1 ; 1 ; 1 } ";
        Assert.assertEquals((Object)expected, (Object)this.vector3DFormat.parse(source2, pos2));
        Assert.assertEquals((long)(source2.length() - 1), (long)pos2.getIndex());
    }

    @Test
    public void testParseSimpleWithDecimals() throws MathParseException {
        String source = "{1" + this.getDecimalCharacter() + "23; 1" + this.getDecimalCharacter() + "43; 1" + this.getDecimalCharacter() + "63}";
        Vector3D expected = new Vector3D(1.23, 1.43, 1.63);
        Vector3D actual = this.vector3DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseSimpleWithDecimalsTrunc() throws MathParseException {
        String source = "{1" + this.getDecimalCharacter() + "2323; 1" + this.getDecimalCharacter() + "4343; 1" + this.getDecimalCharacter() + "6333}";
        Vector3D expected = new Vector3D(1.2323, 1.4343, 1.6333);
        Vector3D actual = this.vector3DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeX() throws MathParseException {
        String source = "{-1" + this.getDecimalCharacter() + "2323; 1" + this.getDecimalCharacter() + "4343; 1" + this.getDecimalCharacter() + "6333}";
        Vector3D expected = new Vector3D(-1.2323, 1.4343, 1.6333);
        Vector3D actual = this.vector3DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeY() throws MathParseException {
        String source = "{1" + this.getDecimalCharacter() + "2323; -1" + this.getDecimalCharacter() + "4343; 1" + this.getDecimalCharacter() + "6333}";
        Vector3D expected = new Vector3D(1.2323, -1.4343, 1.6333);
        Vector3D actual = this.vector3DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeZ() throws MathParseException {
        String source = "{1" + this.getDecimalCharacter() + "2323; 1" + this.getDecimalCharacter() + "4343; -1" + this.getDecimalCharacter() + "6333}";
        Vector3D expected = new Vector3D(1.2323, 1.4343, -1.6333);
        Vector3D actual = this.vector3DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeAll() throws MathParseException {
        String source = "{-1" + this.getDecimalCharacter() + "2323; -1" + this.getDecimalCharacter() + "4343; -1" + this.getDecimalCharacter() + "6333}";
        Vector3D expected = new Vector3D(-1.2323, -1.4343, -1.6333);
        Vector3D actual = this.vector3DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseZeroX() throws MathParseException {
        String source = "{0" + this.getDecimalCharacter() + "0; -1" + this.getDecimalCharacter() + "4343; 1" + this.getDecimalCharacter() + "6333}";
        Vector3D expected = new Vector3D(0.0, -1.4343, 1.6333);
        Vector3D actual = this.vector3DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNonDefaultSetting() throws MathParseException {
        String source = "[1" + this.getDecimalCharacter() + "2323 : 1" + this.getDecimalCharacter() + "4343 : 1" + this.getDecimalCharacter() + "6333]";
        Vector3D expected = new Vector3D(1.2323, 1.4343, 1.6333);
        Vector3D actual = this.vector3DFormatSquare.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNan() throws MathParseException {
        String source = "{(NaN); (NaN); (NaN)}";
        Vector3D actual = this.vector3DFormat.parse(source);
        Assert.assertEquals((Object)Vector3D.NaN, (Object)actual);
    }

    @Test
    public void testParsePositiveInfinity() throws MathParseException {
        String source = "{(Infinity); (Infinity); (Infinity)}";
        Vector3D actual = this.vector3DFormat.parse(source);
        Assert.assertEquals((Object)Vector3D.POSITIVE_INFINITY, (Object)actual);
    }

    @Test
    public void testParseNegativeInfinity() throws MathParseException {
        String source = "{(-Infinity); (-Infinity); (-Infinity)}";
        Vector3D actual = this.vector3DFormat.parse(source);
        Assert.assertEquals((Object)Vector3D.NEGATIVE_INFINITY, (Object)actual);
    }

    @Test
    public void testConstructorSingleFormat() {
        NumberFormat nf = NumberFormat.getInstance();
        Vector3DFormat cf = new Vector3DFormat(nf);
        Assert.assertNotNull((Object)cf);
        Assert.assertEquals((Object)nf, (Object)cf.getFormat());
    }

    @Test
    public void testForgottenPrefix() {
        ParsePosition pos = new ParsePosition(0);
        Assert.assertNull((Object)new Vector3DFormat().parse("1; 1; 1}", pos));
        Assert.assertEquals((long)0L, (long)pos.getErrorIndex());
    }

    @Test
    public void testForgottenSeparator() {
        ParsePosition pos = new ParsePosition(0);
        Assert.assertNull((Object)new Vector3DFormat().parse("{1; 1 1}", pos));
        Assert.assertEquals((long)6L, (long)pos.getErrorIndex());
    }

    @Test
    public void testForgottenSuffix() {
        ParsePosition pos = new ParsePosition(0);
        Assert.assertNull((Object)new Vector3DFormat().parse("{1; 1; 1 ", pos));
        Assert.assertEquals((long)8L, (long)pos.getErrorIndex());
    }
}

