/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.genetics;

import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.Chromosome;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.ChromosomePair;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.DummyBinaryChromosome;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.UniformCrossover;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class UniformCrossoverTest {
    private static final int LEN = 10000;
    private static final List<Integer> p1 = new ArrayList<Integer>(10000);
    private static final List<Integer> p2 = new ArrayList<Integer>(10000);

    @BeforeClass
    public static void setUpBeforeClass() {
        for (int i = 0; i < 10000; ++i) {
            p1.add(0);
            p2.add(1);
        }
    }

    @Test(expected=OutOfRangeException.class)
    public void testRatioTooLow() {
        new UniformCrossover(-0.5);
    }

    @Test(expected=OutOfRangeException.class)
    public void testRatioTooHigh() {
        new UniformCrossover(1.5);
    }

    @Test
    public void testCrossover() {
        this.performCrossover(0.5);
        this.performCrossover(0.7);
        this.performCrossover(0.2);
    }

    private void performCrossover(double ratio) {
        DummyBinaryChromosome p1c = new DummyBinaryChromosome(p1);
        DummyBinaryChromosome p2c = new DummyBinaryChromosome(p2);
        UniformCrossover cp = new UniformCrossover(ratio);
        for (int i = 0; i < 20; ++i) {
            int val;
            ChromosomePair pair = cp.crossover((Chromosome)p1c, (Chromosome)p2c);
            List c1 = ((DummyBinaryChromosome)pair.getFirst()).getRepresentation();
            List c2 = ((DummyBinaryChromosome)pair.getSecond()).getRepresentation();
            int from1 = 0;
            int from2 = 0;
            Iterator i$ = c1.iterator();
            while (i$.hasNext()) {
                val = (Integer)i$.next();
                if (val == 0) {
                    ++from1;
                    continue;
                }
                ++from2;
            }
            Assert.assertEquals((double)(1.0 - ratio), (double)((double)from1 / 10000.0), (double)0.1);
            Assert.assertEquals((double)ratio, (double)((double)from2 / 10000.0), (double)0.1);
            from1 = 0;
            from2 = 0;
            i$ = c2.iterator();
            while (i$.hasNext()) {
                val = (Integer)i$.next();
                if (val == 0) {
                    ++from1;
                    continue;
                }
                ++from2;
            }
            Assert.assertEquals((double)ratio, (double)((double)from1 / 10000.0), (double)0.1);
            Assert.assertEquals((double)(1.0 - ratio), (double)((double)from2 / 10000.0), (double)0.1);
        }
    }

    @Test(expected=DimensionMismatchException.class)
    public void testCrossoverDimensionMismatchException() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 0, 1, 0, 1, 1};
        Integer[] p2 = new Integer[]{0, 1, 1, 0, 1};
        DummyBinaryChromosome p1c = new DummyBinaryChromosome(p1);
        DummyBinaryChromosome p2c = new DummyBinaryChromosome(p2);
        UniformCrossover cp = new UniformCrossover(0.5);
        cp.crossover((Chromosome)p1c, (Chromosome)p2c);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testCrossoverInvalidFixedLengthChromosomeFirst() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 0, 1, 0, 1, 1};
        DummyBinaryChromosome p1c = new DummyBinaryChromosome(p1);
        Chromosome p2c = new Chromosome(){

            public double fitness() {
                return 0.0;
            }
        };
        UniformCrossover cp = new UniformCrossover(0.5);
        cp.crossover((Chromosome)p1c, p2c);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testCrossoverInvalidFixedLengthChromosomeSecond() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 0, 1, 0, 1, 1};
        DummyBinaryChromosome p2c = new DummyBinaryChromosome(p1);
        Chromosome p1c = new Chromosome(){

            public double fitness() {
                return 0.0;
            }
        };
        UniformCrossover cp = new UniformCrossover(0.5);
        cp.crossover(p1c, (Chromosome)p2c);
    }
}

