/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.fitting;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.ConvergenceException;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.PolynomialCurveFitter;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.WeightedObservedPoints;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.Collection;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class PolynomialCurveFitterTest {
    @Test
    public void testFit() {
        UniformRealDistribution rng = new UniformRealDistribution(-100.0, 100.0);
        rng.reseedRandomGenerator(64925784252L);
        double[] coeff = new double[]{12.9, -3.4, 2.1};
        PolynomialFunction f = new PolynomialFunction(coeff);
        WeightedObservedPoints obs = new WeightedObservedPoints();
        for (int i = 0; i < 100; ++i) {
            double x = rng.sample();
            obs.add(x, f.value(x));
        }
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)0).withStartPoint(new double[]{-1.0E-20, 3.0E15, -5.0E25});
        double[] best = fitter.fit((Collection)obs.toList());
        TestUtils.assertEquals("best != coeff", coeff, best, 1.0E-12);
    }

    @Test
    public void testNoError() {
        Random randomizer = new Random(64925784252L);
        for (int degree = 1; degree < 10; ++degree) {
            PolynomialFunction p = this.buildRandomPolynomial(degree, randomizer);
            PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)degree);
            WeightedObservedPoints obs = new WeightedObservedPoints();
            for (int i = 0; i <= degree; ++i) {
                obs.add(1.0, (double)i, p.value((double)i));
            }
            PolynomialFunction fitted = new PolynomialFunction(fitter.fit((Collection)obs.toList()));
            for (double x = -1.0; x < 1.0; x += 0.01) {
                double error = FastMath.abs((double)(p.value(x) - fitted.value(x))) / (1.0 + FastMath.abs((double)p.value(x)));
                Assert.assertEquals((double)0.0, (double)error, (double)1.0E-6);
            }
        }
    }

    @Test
    public void testSmallError() {
        Random randomizer = new Random(53882150042L);
        double maxError = 0.0;
        for (int degree = 0; degree < 10; ++degree) {
            PolynomialFunction p = this.buildRandomPolynomial(degree, randomizer);
            PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)degree);
            WeightedObservedPoints obs = new WeightedObservedPoints();
            for (double x = -1.0; x < 1.0; x += 0.01) {
                obs.add(1.0, x, p.value(x) + 0.1 * randomizer.nextGaussian());
            }
            PolynomialFunction fitted = new PolynomialFunction(fitter.fit((Collection)obs.toList()));
            for (double x = -1.0; x < 1.0; x += 0.01) {
                double error = FastMath.abs((double)(p.value(x) - fitted.value(x))) / (1.0 + FastMath.abs((double)p.value(x)));
                maxError = FastMath.max((double)maxError, (double)error);
                Assert.assertTrue((FastMath.abs((double)error) < 0.1 ? 1 : 0) != 0);
            }
        }
        Assert.assertTrue((maxError > 0.01 ? 1 : 0) != 0);
    }

    @Test
    public void testRedundantSolvable() {
        this.checkUnsolvableProblem(true);
    }

    @Test
    public void testLargeSample() {
        Random randomizer = new Random(6147774190404187803L);
        double maxError = 0.0;
        for (int degree = 0; degree < 10; ++degree) {
            double x;
            PolynomialFunction p = this.buildRandomPolynomial(degree, randomizer);
            PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)degree);
            WeightedObservedPoints obs = new WeightedObservedPoints();
            for (int i = 0; i < 40000; ++i) {
                x = -1.0 + (double)i / 20000.0;
                obs.add(1.0, x, p.value(x) + 0.1 * randomizer.nextGaussian());
            }
            PolynomialFunction fitted = new PolynomialFunction(fitter.fit((Collection)obs.toList()));
            for (x = -1.0; x < 1.0; x += 0.01) {
                double error = FastMath.abs((double)(p.value(x) - fitted.value(x))) / (1.0 + FastMath.abs((double)p.value(x)));
                maxError = FastMath.max((double)maxError, (double)error);
                Assert.assertTrue((FastMath.abs((double)error) < 0.01 ? 1 : 0) != 0);
            }
        }
        Assert.assertTrue((maxError > 0.001 ? 1 : 0) != 0);
    }

    private void checkUnsolvableProblem(boolean solvable) {
        Random randomizer = new Random(1248788532L);
        for (int degree = 0; degree < 10; ++degree) {
            PolynomialFunction p = this.buildRandomPolynomial(degree, randomizer);
            PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)degree);
            WeightedObservedPoints obs = new WeightedObservedPoints();
            for (double x = -1.0; x < 1.0; x += 0.01) {
                obs.add(1.0, 0.0, p.value(0.0));
            }
            try {
                fitter.fit((Collection)obs.toList());
                Assert.assertTrue((solvable || degree == 0 ? 1 : 0) != 0);
                continue;
            }
            catch (ConvergenceException e) {
                Assert.assertTrue((!solvable && degree > 0 ? 1 : 0) != 0);
            }
        }
    }

    private PolynomialFunction buildRandomPolynomial(int degree, Random randomizer) {
        double[] coefficients = new double[degree + 1];
        for (int i = 0; i <= degree; ++i) {
            coefficients[i] = randomizer.nextGaussian();
        }
        return new PolynomialFunction(coefficients);
    }
}

