/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.exception.util;

import com.hazelcast.shaded.org.apache.commons.math3.exception.util.LocalizedFormats;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import org.junit.Assert;
import org.junit.Test;

public class LocalizedFormatsTest {
    @Test
    public void testMessageNumber() {
        Assert.assertEquals((long)328L, (long)LocalizedFormats.values().length);
    }

    @Test
    public void testAllKeysPresentInPropertiesFiles() {
        String path = LocalizedFormats.class.getName().replaceAll("\\.", "/");
        for (String language : new String[]{"fr"}) {
            ResourceBundle bundle = ResourceBundle.getBundle("assets/" + path, new Locale(language));
            for (LocalizedFormats message : LocalizedFormats.values()) {
                String messageKey = message.toString();
                boolean keyPresent = false;
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    keyPresent |= messageKey.equals(keys.nextElement());
                }
                Assert.assertTrue((String)("missing key \"" + message.name() + "\" for language " + language), (boolean)keyPresent);
            }
            Assert.assertEquals((Object)language, (Object)bundle.getLocale().getLanguage());
        }
    }

    @Test
    public void testAllPropertiesCorrespondToKeys() {
        String path = LocalizedFormats.class.getName().replaceAll("\\.", "/");
        for (String language : new String[]{"fr"}) {
            ResourceBundle bundle = ResourceBundle.getBundle("assets/" + path, new Locale(language));
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String propertyKey = keys.nextElement();
                try {
                    Assert.assertNotNull((Object)LocalizedFormats.valueOf((String)propertyKey));
                }
                catch (IllegalArgumentException iae) {
                    Assert.fail((String)("unknown key \"" + propertyKey + "\" in language " + language));
                }
            }
            Assert.assertEquals((Object)language, (Object)bundle.getLocale().getLanguage());
        }
    }

    @Test
    public void testNoMissingFrenchTranslation() {
        for (LocalizedFormats message : LocalizedFormats.values()) {
            String translated = message.getLocalizedString(Locale.FRENCH);
            Assert.assertFalse((String)message.name(), (boolean)translated.toLowerCase().contains("missing translation"));
        }
    }

    @Test
    public void testNoOpEnglishTranslation() {
        for (LocalizedFormats message : LocalizedFormats.values()) {
            String translated = message.getLocalizedString(Locale.ENGLISH);
            Assert.assertEquals((Object)message.getSourceString(), (Object)translated);
        }
    }

    @Test
    public void testVariablePartsConsistency() {
        for (String language : new String[]{"fr"}) {
            Locale locale = new Locale(language);
            for (LocalizedFormats message : LocalizedFormats.values()) {
                MessageFormat source = new MessageFormat(message.getSourceString());
                MessageFormat translated = new MessageFormat(message.getLocalizedString(locale));
                Assert.assertEquals((String)(message.name() + " (" + language + ")"), (long)source.getFormatsByArgumentIndex().length, (long)translated.getFormatsByArgumentIndex().length);
            }
        }
    }
}

