/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.BinomialDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.IntegerDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.IntegerDistributionAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class BinomialDistributionTest
extends IntegerDistributionAbstractTest {
    public BinomialDistributionTest() {
        this.setTolerance(1.0E-12);
    }

    public IntegerDistribution makeDistribution() {
        return new BinomialDistribution(10, 0.7);
    }

    public int[] makeDensityTestPoints() {
        return new int[]{-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.0, 5.9049E-6, 1.37781E-4, 0.0014467005, 0.009001692, 0.036756909, 0.1029193452, 0.200120949, 0.266827932, 0.2334744405, 0.121060821, 0.0282475249, 0.0};
    }

    public int[] makeCumulativeTestPoints() {
        return this.makeDensityTestPoints();
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.0, 5.9049E-6, 1.436859E-4, 0.0015903864, 0.0105920784, 0.0473489874, 0.1502683326, 0.3503892816, 0.6172172136, 0.8506916541, 0.9717524751, 1.0, 1.0};
    }

    public double[] makeInverseCumulativeTestPoints() {
        return new double[]{0.0, 0.001, 0.01, 0.025, 0.05, 0.1, 0.999, 0.99, 0.975, 0.95, 0.9, 1.0};
    }

    public int[] makeInverseCumulativeTestValues() {
        return new int[]{0, 2, 3, 4, 5, 5, 10, 10, 10, 9, 9, 10};
    }

    @Test
    public void testDegenerate0() {
        BinomialDistribution dist = new BinomialDistribution(5, 0.0);
        this.setDistribution((IntegerDistribution)dist);
        this.setCumulativeTestPoints(new int[]{-1, 0, 1, 5, 10});
        this.setCumulativeTestValues(new double[]{0.0, 1.0, 1.0, 1.0, 1.0});
        this.setDensityTestPoints(new int[]{-1, 0, 1, 10, 11});
        this.setDensityTestValues(new double[]{0.0, 1.0, 0.0, 0.0, 0.0});
        this.setInverseCumulativeTestPoints(new double[]{0.1, 0.5});
        this.setInverseCumulativeTestValues(new int[]{0, 0});
        this.verifyDensities();
        this.verifyCumulativeProbabilities();
        this.verifyInverseCumulativeProbabilities();
        Assert.assertEquals((long)dist.getSupportLowerBound(), (long)0L);
        Assert.assertEquals((long)dist.getSupportUpperBound(), (long)0L);
    }

    @Test
    public void testDegenerate1() {
        BinomialDistribution dist = new BinomialDistribution(5, 1.0);
        this.setDistribution((IntegerDistribution)dist);
        this.setCumulativeTestPoints(new int[]{-1, 0, 1, 2, 5, 10});
        this.setCumulativeTestValues(new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0});
        this.setDensityTestPoints(new int[]{-1, 0, 1, 2, 5, 10});
        this.setDensityTestValues(new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 0.0});
        this.setInverseCumulativeTestPoints(new double[]{0.1, 0.5});
        this.setInverseCumulativeTestValues(new int[]{5, 5});
        this.verifyDensities();
        this.verifyCumulativeProbabilities();
        this.verifyInverseCumulativeProbabilities();
        Assert.assertEquals((long)dist.getSupportLowerBound(), (long)5L);
        Assert.assertEquals((long)dist.getSupportUpperBound(), (long)5L);
    }

    @Test
    public void testDegenerate2() {
        BinomialDistribution dist = new BinomialDistribution(0, 0.01);
        this.setDistribution((IntegerDistribution)dist);
        this.setCumulativeTestPoints(new int[]{-1, 0, 1, 2, 5, 10});
        this.setCumulativeTestValues(new double[]{0.0, 1.0, 1.0, 1.0, 1.0, 1.0});
        this.setDensityTestPoints(new int[]{-1, 0, 1, 2, 5, 10});
        this.setDensityTestValues(new double[]{0.0, 1.0, 0.0, 0.0, 0.0, 0.0});
        this.setInverseCumulativeTestPoints(new double[]{0.1, 0.5});
        this.setInverseCumulativeTestValues(new int[]{0, 0});
        this.verifyDensities();
        this.verifyCumulativeProbabilities();
        this.verifyInverseCumulativeProbabilities();
        Assert.assertEquals((long)dist.getSupportLowerBound(), (long)0L);
        Assert.assertEquals((long)dist.getSupportUpperBound(), (long)0L);
    }

    @Test
    public void testMoments() {
        double tol = 1.0E-9;
        BinomialDistribution dist = new BinomialDistribution(10, 0.5);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)5.0, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)2.5, (double)1.0E-9);
        dist = new BinomialDistribution(30, 0.3);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)9.0, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)6.3, (double)1.0E-9);
    }

    @Test
    public void testMath718() {
        for (int trials = 500000; trials < 20000000; trials += 100000) {
            BinomialDistribution dist = new BinomialDistribution(trials, 0.5);
            int p = dist.inverseCumulativeProbability(0.5);
            Assert.assertEquals((long)(trials / 2), (long)p);
        }
    }
}

