/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.integration.RombergIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.AbstractRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import org.junit.Assert;
import org.junit.Test;

public class AbstractRealDistributionTest {
    @Test
    public void testContinuous() {
        double x0 = 0.0;
        double x1 = 1.0;
        double x2 = 2.0;
        double x3 = 3.0;
        double p12 = 0.5;
        AbstractRealDistribution distribution = new AbstractRealDistribution(null){
            private static final long serialVersionUID = 1L;

            public double cumulativeProbability(double x) {
                if (x < 0.0 || x > 3.0) {
                    throw new OutOfRangeException((Number)x, (Number)0.0, (Number)3.0);
                }
                if (x <= 1.0) {
                    return 0.5 * (x - 0.0) / 1.0;
                }
                if (x <= 2.0) {
                    return 0.5;
                }
                if (x <= 3.0) {
                    return 0.5 + 0.5 * (x - 2.0) / 1.0;
                }
                return 0.0;
            }

            public double density(double x) {
                if (x < 0.0 || x > 3.0) {
                    throw new OutOfRangeException((Number)x, (Number)0.0, (Number)3.0);
                }
                if (x <= 1.0) {
                    return 0.5;
                }
                if (x <= 2.0) {
                    return 0.0;
                }
                if (x <= 3.0) {
                    return 0.5;
                }
                return 0.0;
            }

            public double getNumericalMean() {
                return 1.5;
            }

            public double getNumericalVariance() {
                double meanX = this.getNumericalMean();
                double meanX2 = 3.3333333333333335;
                return meanX2 - meanX * meanX;
            }

            public double getSupportLowerBound() {
                return 0.0;
            }

            public double getSupportUpperBound() {
                return 3.0;
            }

            public boolean isSupportConnected() {
                return false;
            }

            public boolean isSupportLowerBoundInclusive() {
                return true;
            }

            public boolean isSupportUpperBoundInclusive() {
                return true;
            }

            public double probability(double x) {
                throw new UnsupportedOperationException();
            }
        };
        double expected = 1.0;
        double actual = distribution.inverseCumulativeProbability(0.5);
        Assert.assertEquals((String)"", (double)1.0, (double)actual, (double)distribution.getSolverAbsoluteAccuracy());
    }

    @Test
    public void testDiscontinuous() {
        double x0 = 0.0;
        double x1 = 0.25;
        double x2 = 0.5;
        double x3 = 0.75;
        double x4 = 1.0;
        double p12 = 0.3333333333333333;
        double p23 = 0.6666666666666666;
        AbstractRealDistribution distribution = new AbstractRealDistribution(null){
            private static final long serialVersionUID = 1L;

            public double cumulativeProbability(double x) {
                if (x < 0.0 || x > 1.0) {
                    throw new OutOfRangeException((Number)x, (Number)0.0, (Number)1.0);
                }
                if (x <= 0.25) {
                    return 0.3333333333333333 * (x - 0.0) / 0.25;
                }
                if (x <= 0.5) {
                    return 0.3333333333333333;
                }
                if (x <= 0.75) {
                    return 0.6666666666666666;
                }
                return 0.33333333333333337 * (x - 0.75) / 0.25 + 0.6666666666666666;
            }

            public double density(double x) {
                if (x < 0.0 || x > 1.0) {
                    throw new OutOfRangeException((Number)x, (Number)0.0, (Number)1.0);
                }
                if (x <= 0.25) {
                    return 1.3333333333333333;
                }
                if (x <= 0.5) {
                    return 0.0;
                }
                if (x <= 0.75) {
                    return 0.0;
                }
                return 1.3333333333333335;
            }

            public double getNumericalMean() {
                UnivariateFunction f = new UnivariateFunction(){

                    public double value(double x) {
                        return x * this.density(x);
                    }
                };
                RombergIntegrator integrator = new RombergIntegrator();
                return integrator.integrate(Integer.MAX_VALUE, f, 0.0, 1.0);
            }

            public double getNumericalVariance() {
                double meanX = this.getNumericalMean();
                UnivariateFunction f = new UnivariateFunction(){

                    public double value(double x) {
                        return x * x * this.density(x);
                    }
                };
                RombergIntegrator integrator = new RombergIntegrator();
                double meanX2 = integrator.integrate(Integer.MAX_VALUE, f, 0.0, 1.0);
                return meanX2 - meanX * meanX;
            }

            public double getSupportLowerBound() {
                return 0.0;
            }

            public double getSupportUpperBound() {
                return 1.0;
            }

            public boolean isSupportConnected() {
                return false;
            }

            public boolean isSupportLowerBoundInclusive() {
                return true;
            }

            public boolean isSupportUpperBoundInclusive() {
                return true;
            }

            public double probability(double x) {
                throw new UnsupportedOperationException();
            }
        };
        double expected = 0.5;
        double actual = distribution.inverseCumulativeProbability(0.6666666666666666);
        Assert.assertEquals((String)"", (double)0.5, (double)actual, (double)distribution.getSolverAbsoluteAccuracy());
    }
}

