/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.complex;

import com.hazelcast.shaded.org.apache.commons.math3.complex.Complex;
import com.hazelcast.shaded.org.apache.commons.math3.complex.ComplexFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public abstract class ComplexFormatAbstractTest {
    ComplexFormat complexFormat = ComplexFormat.getInstance((Locale)this.getLocale());
    ComplexFormat complexFormatJ = ComplexFormat.getInstance((String)"j", (Locale)this.getLocale());

    protected abstract Locale getLocale();

    protected abstract char getDecimalCharacter();

    protected ComplexFormatAbstractTest() {
    }

    @Test
    public void testSimpleNoDecimals() {
        Complex c = new Complex(1.0, 2.0);
        String expected = "1 + 2i";
        String actual = this.complexFormat.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTrimOneImaginary() {
        ComplexFormat fmt = ComplexFormat.getInstance((Locale)this.getLocale());
        fmt.getImaginaryFormat().setMaximumFractionDigits(1);
        Complex c = new Complex(1.0, 1.04);
        String expected = "1 + i";
        String actual = fmt.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
        c = new Complex(1.0, 1.09);
        expected = "1 + 1" + this.getDecimalCharacter() + "1i";
        actual = fmt.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
        c = new Complex(1.0, -1.09);
        expected = "1 - 1" + this.getDecimalCharacter() + "1i";
        actual = fmt.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
        c = new Complex(1.0, -1.04);
        expected = "1 - i";
        actual = fmt.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleWithDecimals() {
        Complex c = new Complex(1.23, 1.43);
        String expected = "1" + this.getDecimalCharacter() + "23 + 1" + this.getDecimalCharacter() + "43i";
        String actual = this.complexFormat.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleWithDecimalsTrunc() {
        Complex c = new Complex(1.232323232323, 1.434343434343);
        String expected = "1" + this.getDecimalCharacter() + "2323232323 + 1" + this.getDecimalCharacter() + "4343434343i";
        String actual = this.complexFormat.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeReal() {
        Complex c = new Complex(-1.232323232323, 1.43);
        String expected = "-1" + this.getDecimalCharacter() + "2323232323 + 1" + this.getDecimalCharacter() + "43i";
        String actual = this.complexFormat.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeImaginary() {
        Complex c = new Complex(1.23, -1.434343434343);
        String expected = "1" + this.getDecimalCharacter() + "23 - 1" + this.getDecimalCharacter() + "4343434343i";
        String actual = this.complexFormat.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeBoth() {
        Complex c = new Complex(-1.232323232323, -1.434343434343);
        String expected = "-1" + this.getDecimalCharacter() + "2323232323 - 1" + this.getDecimalCharacter() + "4343434343i";
        String actual = this.complexFormat.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testZeroReal() {
        Complex c = new Complex(0.0, -1.434343434343);
        String expected = "0 - 1" + this.getDecimalCharacter() + "4343434343i";
        String actual = this.complexFormat.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testZeroImaginary() {
        Complex c = new Complex(30.23333333333, 0.0);
        String expected = "30" + this.getDecimalCharacter() + "2333333333";
        String actual = this.complexFormat.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDifferentImaginaryChar() {
        Complex c = new Complex(1.0, 1.0);
        String expected = "1 + j";
        String actual = this.complexFormatJ.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDefaultFormatComplex() {
        Locale defaultLocal = Locale.getDefault();
        Locale.setDefault(this.getLocale());
        Complex c = new Complex(232.22222222222, -342.3333333333);
        String expected = "232" + this.getDecimalCharacter() + "2222222222 - 342" + this.getDecimalCharacter() + "3333333333i";
        String actual = new ComplexFormat().format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
        Locale.setDefault(defaultLocal);
    }

    @Test
    public void testNan() {
        Complex c = new Complex(Double.NaN, Double.NaN);
        String expected = "(NaN) + (NaN)i";
        String actual = this.complexFormat.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testPositiveInfinity() {
        Complex c = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        String expected = "(Infinity) + (Infinity)i";
        String actual = this.complexFormat.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeInfinity() {
        Complex c = new Complex(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        String expected = "(-Infinity) - (Infinity)i";
        String actual = this.complexFormat.format(c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseSimpleNoDecimals() {
        String source = "1 + 1i";
        Complex expected = new Complex(1.0, 1.0);
        Complex actual = this.complexFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseSimpleWithDecimals() {
        String source = "1" + this.getDecimalCharacter() + "23 + 1" + this.getDecimalCharacter() + "43i";
        Complex expected = new Complex(1.23, 1.43);
        Complex actual = this.complexFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseSimpleWithDecimalsTrunc() {
        String source = "1" + this.getDecimalCharacter() + "232323232323 + 1" + this.getDecimalCharacter() + "434343434343i";
        Complex expected = new Complex(1.232323232323, 1.434343434343);
        Complex actual = this.complexFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeReal() {
        String source = "-1" + this.getDecimalCharacter() + "232323232323 + 1" + this.getDecimalCharacter() + "4343i";
        Complex expected = new Complex(-1.232323232323, 1.4343);
        Complex actual = this.complexFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeImaginary() {
        String source = "1" + this.getDecimalCharacter() + "2323 - 1" + this.getDecimalCharacter() + "434343434343i";
        Complex expected = new Complex(1.2323, -1.434343434343);
        Complex actual = this.complexFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeBoth() {
        String source = "-1" + this.getDecimalCharacter() + "232323232323 - 1" + this.getDecimalCharacter() + "434343434343i";
        Complex expected = new Complex(-1.232323232323, -1.434343434343);
        Complex actual = this.complexFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseZeroReal() {
        String source = "0" + this.getDecimalCharacter() + "0 - 1" + this.getDecimalCharacter() + "4343i";
        Complex expected = new Complex(0.0, -1.4343);
        Complex actual = this.complexFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseZeroImaginary() {
        String source = "-1" + this.getDecimalCharacter() + "2323";
        Complex expected = new Complex(-1.2323, 0.0);
        Complex actual = this.complexFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseDifferentImaginaryChar() {
        String source = "-1" + this.getDecimalCharacter() + "2323 - 1" + this.getDecimalCharacter() + "4343j";
        Complex expected = new Complex(-1.2323, -1.4343);
        Complex actual = this.complexFormatJ.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNan() {
        String source = "(NaN) + (NaN)i";
        Complex expected = new Complex(Double.NaN, Double.NaN);
        Complex actual = this.complexFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParsePositiveInfinity() {
        String source = "(Infinity) + (Infinity)i";
        Complex expected = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Complex actual = this.complexFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testPaseNegativeInfinity() {
        String source = "(-Infinity) - (Infinity)i";
        Complex expected = new Complex(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Complex actual = this.complexFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConstructorSingleFormat() {
        NumberFormat nf = NumberFormat.getInstance();
        ComplexFormat cf = new ComplexFormat(nf);
        Assert.assertNotNull((Object)cf);
        Assert.assertEquals((Object)nf, (Object)cf.getRealFormat());
    }

    @Test
    public void testGetImaginaryFormat() {
        NumberFormat nf = NumberFormat.getInstance();
        ComplexFormat cf = new ComplexFormat(nf);
        Assert.assertSame((Object)nf, (Object)cf.getImaginaryFormat());
    }

    @Test
    public void testGetRealFormat() {
        NumberFormat nf = NumberFormat.getInstance();
        ComplexFormat cf = new ComplexFormat(nf);
        Assert.assertSame((Object)nf, (Object)cf.getRealFormat());
    }

    @Test
    public void testFormatNumber() {
        ComplexFormat cf = ComplexFormat.getInstance((Locale)this.getLocale());
        Double pi = Math.PI;
        String text = cf.format(pi);
        Assert.assertEquals((Object)("3" + this.getDecimalCharacter() + "1415926536"), (Object)text);
    }

    @Test
    public void testForgottenImaginaryCharacter() {
        ParsePosition pos = new ParsePosition(0);
        Assert.assertNull((Object)new ComplexFormat().parse("1 + 1", pos));
        Assert.assertEquals((long)5L, (long)pos.getErrorIndex());
    }
}

