/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NonMonotonicSequenceException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.junit.Assert;
import org.junit.Test;

public class LinearInterpolatorTest {
    protected double knotTolerance = 1.0E-12;
    protected double coefficientTolerance = 1.0E-6;
    protected double interpolationTolerance = 1.0E-12;

    @Test
    public void testInterpolateLinearDegenerateTwoSegment() {
        double[] x = new double[]{0.0, 0.5, 1.0};
        double[] y = new double[]{0.0, 0.5, 1.0};
        LinearInterpolator i = new LinearInterpolator();
        UnivariateFunction f = i.interpolate(x, y);
        this.verifyInterpolation(f, x, y);
        PolynomialFunction[] polynomials = ((PolynomialSplineFunction)f).getPolynomials();
        double[] target = new double[]{y[0], 1.0};
        TestUtils.assertEquals(polynomials[0].getCoefficients(), target, this.coefficientTolerance);
        target = new double[]{y[1], 1.0};
        TestUtils.assertEquals(polynomials[1].getCoefficients(), target, this.coefficientTolerance);
        Assert.assertEquals((double)0.0, (double)f.value(0.0), (double)this.interpolationTolerance);
        Assert.assertEquals((double)0.4, (double)f.value(0.4), (double)this.interpolationTolerance);
        Assert.assertEquals((double)1.0, (double)f.value(1.0), (double)this.interpolationTolerance);
    }

    @Test
    public void testInterpolateLinearDegenerateThreeSegment() {
        double[] x = new double[]{0.0, 0.5, 1.0, 1.5};
        double[] y = new double[]{0.0, 0.5, 1.0, 1.5};
        LinearInterpolator i = new LinearInterpolator();
        UnivariateFunction f = i.interpolate(x, y);
        this.verifyInterpolation(f, x, y);
        PolynomialFunction[] polynomials = ((PolynomialSplineFunction)f).getPolynomials();
        double[] target = new double[]{y[0], 1.0};
        TestUtils.assertEquals(polynomials[0].getCoefficients(), target, this.coefficientTolerance);
        target = new double[]{y[1], 1.0};
        TestUtils.assertEquals(polynomials[1].getCoefficients(), target, this.coefficientTolerance);
        target = new double[]{y[2], 1.0};
        TestUtils.assertEquals(polynomials[2].getCoefficients(), target, this.coefficientTolerance);
        Assert.assertEquals((double)0.0, (double)f.value(0.0), (double)this.interpolationTolerance);
        Assert.assertEquals((double)1.4, (double)f.value(1.4), (double)this.interpolationTolerance);
        Assert.assertEquals((double)1.5, (double)f.value(1.5), (double)this.interpolationTolerance);
    }

    @Test
    public void testInterpolateLinear() {
        double[] x = new double[]{0.0, 0.5, 1.0};
        double[] y = new double[]{0.0, 0.5, 0.0};
        LinearInterpolator i = new LinearInterpolator();
        UnivariateFunction f = i.interpolate(x, y);
        this.verifyInterpolation(f, x, y);
        PolynomialFunction[] polynomials = ((PolynomialSplineFunction)f).getPolynomials();
        double[] target = new double[]{y[0], 1.0};
        TestUtils.assertEquals(polynomials[0].getCoefficients(), target, this.coefficientTolerance);
        target = new double[]{y[1], -1.0};
        TestUtils.assertEquals(polynomials[1].getCoefficients(), target, this.coefficientTolerance);
    }

    @Test
    public void testIllegalArguments() {
        double[] yval;
        double[] xval2;
        LinearInterpolator i = new LinearInterpolator();
        try {
            xval2 = new double[]{0.0, 1.0};
            yval = new double[]{0.0, 1.0, 2.0};
            i.interpolate(xval2, yval);
            Assert.fail((String)"Failed to detect data set array with different sizes.");
        }
        catch (DimensionMismatchException xval2) {
            // empty catch block
        }
        try {
            xval2 = new double[]{0.0, 1.0, 0.5};
            yval = new double[]{0.0, 1.0, 2.0};
            i.interpolate(xval2, yval);
            Assert.fail((String)"Failed to detect unsorted arguments.");
        }
        catch (NonMonotonicSequenceException xval3) {
            // empty catch block
        }
        try {
            xval2 = new double[]{0.0};
            yval = new double[]{0.0};
            i.interpolate(xval2, yval);
            Assert.fail((String)"Failed to detect unsorted arguments.");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    protected void verifyInterpolation(UnivariateFunction f, double[] x, double[] y) {
        for (int i = 0; i < x.length; ++i) {
            Assert.assertEquals((double)f.value(x[i]), (double)y[i], (double)this.knotTolerance);
        }
    }
}

