/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3;

import com.hazelcast.shaded.org.apache.commons.math3.Retry;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryRunner
extends BlockJUnit4ClassRunner {
    public RetryRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    public Statement methodInvoker(final FrameworkMethod method, Object test) {
        final Statement singleTryStatement = super.methodInvoker(method, test);
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable failureReason = null;
                Retry retry = (Retry)method.getAnnotation(Retry.class);
                if (retry != null) {
                    int numRetries = retry.value();
                    for (int i = 0; i < numRetries; ++i) {
                        try {
                            singleTryStatement.evaluate();
                            return;
                        }
                        catch (Throwable t) {
                            failureReason = t;
                            continue;
                        }
                    }
                    throw failureReason;
                }
                singleTryStatement.evaluate();
            }
        };
    }
}

