/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.type;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.impl.compact.DeserializedGenericRecord;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.IMapSqlConnector;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.test.HazelcastSerialClassRunner;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
public class CompactNestedFieldsTest
extends SqlTestSupport {
    @BeforeClass
    public static void beforeClass() {
        Config config = new Config();
        config.getJetConfig().setEnabled(true);
        CompactNestedFieldsTest.initializeWithClient((int)3, (Config)config, null);
    }

    static void setupCompactTypesForNestedQuery(HazelcastInstance instance) {
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType("Office").fields(new String[]{"id BIGINT", "name VARCHAR"})).create(instance);
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType("Organization").fields(new String[]{"id BIGINT", "name VARCHAR", "office Office"})).create(instance);
        CompactNestedFieldsTest.createCompactMapping(instance, "test", "UserCompactType", "id BIGINT", "name VARCHAR", "organization Organization");
    }

    static void createCompactMapping(HazelcastInstance instance, String name, String valueCompactTypeName, String ... valueFields) {
        ((SqlTestSupport.SqlMapping)((SqlTestSupport.SqlMapping)((SqlTestSupport.SqlMapping)new SqlTestSupport.SqlMapping(name, IMapSqlConnector.class).fields(new String[]{"__key BIGINT"})).fields(valueFields)).options(new Object[]{"keyFormat", "bigint", "valueFormat", "compact", "valueCompactTypeName", valueCompactTypeName})).create(instance);
    }

    private static void createType(String name, String ... fields) {
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType(name).fields(fields)).create(CompactNestedFieldsTest.client());
    }

    private static SqlResult execute(String sql) {
        return CompactNestedFieldsTest.client().getSql().execute(sql, new Object[0]);
    }

    @Test
    public void test_basicQuerying() {
        CompactNestedFieldsTest.setupCompactTypesForNestedQuery(CompactNestedFieldsTest.client());
        CompactNestedFieldsTest.execute("INSERT INTO test VALUES (1, 1, 'user1', (1, 'organization1', (1, 'office1')))");
        CompactNestedFieldsTest.assertRowsAnyOrder("SELECT (organization).office.name FROM test", CompactNestedFieldsTest.rows(1, "office1"));
    }

    @Test
    public void test_nestedCompactsAreReturnedAsDeserialized() {
        CompactNestedFieldsTest.createType("Office", "id BIGINT", "name VARCHAR");
        CompactNestedFieldsTest.createType("Organization", "id BIGINT", "name VARCHAR", "office Office");
        CompactNestedFieldsTest.createType("OrganizationAndLong", "id BIGINT", "l BIGINT", "organization Organization");
        CompactNestedFieldsTest.createCompactMapping(CompactNestedFieldsTest.client(), "test", "UserCompactType", "id BIGINT", "name VARCHAR", "organizationAndLong OrganizationAndLong");
        CompactNestedFieldsTest.execute("INSERT INTO test VALUES (1, 1, 'user1', (1, 1, (1, 'organization1', (1, 'office1'))))");
        SqlResult result = CompactNestedFieldsTest.execute("SELECT (organizationAndLong).organization.office FROM test");
        ArrayList<SqlRow> rows = new ArrayList<SqlRow>();
        for (SqlRow row : result) {
            rows.add(row);
        }
        Assert.assertEquals((long)1L, (long)rows.size());
        CompactNestedFieldsTest.assertInstanceOf(DeserializedGenericRecord.class, (Object)((SqlRow)rows.get(0)).getObject(0));
    }

    @Test
    public void test_emptyColumnList() {
        CompactNestedFieldsTest.createType("Office", new String[0]);
        Assertions.assertThatThrownBy(() -> CompactNestedFieldsTest.createCompactMapping(CompactNestedFieldsTest.client(), "test", "OfficesCompactType", "office Office")).hasMessageContaining("Column list is required to create Compact-based types");
    }
}

