/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.OptimizerContext;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.pretty.SqlPrettyWriter;
import com.hazelcast.sql.impl.schema.SqlCatalog;
import com.hazelcast.sql.impl.security.NoOpSqlSecurityContext;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class UnparseTest {
    private OptimizerContext context;

    @Before
    public void before() {
        this.context = UnparseTest.createContext();
    }

    @Test
    public void test_JSON_QUERY() {
        this.checkQuery("SELECT JSON_QUERY('[1,2,3]', '$' WITHOUT ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)");
        this.checkQuery("SELECT JSON_QUERY('[1,2,3]', '$' WITH UNCONDITIONAL ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)");
        this.checkQuery("SELECT JSON_QUERY('[1,2,3]', '$' WITH CONDITIONAL ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)");
        this.checkQuery("SELECT JSON_QUERY('[1,2,3]', '$' WITHOUT ARRAY WRAPPER ERROR ON EMPTY ERROR ON ERROR)");
        this.checkQuery("SELECT JSON_QUERY('[1,2,3]', '$' WITHOUT ARRAY WRAPPER EMPTY ARRAY ON EMPTY EMPTY OBJECT ON ERROR)");
    }

    @Test
    public void test_JSON_VALUE() {
        this.checkQuery("SELECT JSON_VALUE('[1,2,3]', '$[0]' RETURNING BIGINT)");
        this.checkQuery("SELECT JSON_VALUE('[1,2,3]', '$[0]' RETURNING BIGINT DEFAULT 1 ON EMPTY ERROR ON ERROR)");
        this.checkQuery("SELECT JSON_VALUE('[1,2,3]', '$[0]' RETURNING VARCHAR NULL ON EMPTY DEFAULT '1' ON ERROR)");
    }

    @Test
    public void test_JSON_OBJECT() {
        this.checkQuery("SELECT JSON_OBJECT()");
        this.checkQuery("SELECT JSON_OBJECT(KEY 'k1' VALUE 'v1' ABSENT ON NULL)");
        this.checkQuery("SELECT JSON_OBJECT(KEY 'k1' VALUE 'v1', KEY 'k2' VALUE 'v2' NULL ON NULL)");
    }

    @Test
    public void test_JSON_ARRAY() {
        this.checkQuery("SELECT JSON_ARRAY()");
        this.checkQuery("SELECT JSON_ARRAY(1, 'b', 3 ABSENT ON NULL)");
        this.checkQuery("SELECT JSON_ARRAY(1, 'b', 3 NULL ON NULL)");
    }

    @Test
    public void test_ANALYZE() {
        this.checkQuery("ANALYZE SELECT JSON_ARRAY()");
        this.checkQuery("ANALYZE\nWITH OPTIONS (\n  'processingGuarantee'='exactlyOnce',\n  'snapshotIntervalMillis'='121'\n) SELECT JSON_ARRAY()");
    }

    private void checkQuery(String query) {
        SqlNode node = this.context.parse(query).getNode();
        SqlPrettyWriter writer = new SqlPrettyWriter(SqlPrettyWriter.config());
        node.unparse((SqlWriter)writer, 0, 0);
        String result = writer.toSqlString().toString();
        Assertions.assertThat((String)result).isEqualToNormalizingNewlines((CharSequence)query);
        Assert.assertNotNull((Object)this.context.parse(result).getNode());
    }

    private static OptimizerContext createContext() {
        return OptimizerContext.create((SqlCatalog)new SqlCatalog(Collections.emptyList()), Collections.emptyList(), Collections.emptyList(), name -> null, null, (SqlSecurityContext)NoOpSqlSecurityContext.INSTANCE);
    }
}

